/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.compare;

import de.dal33t.powerfolder.transfer.Transfer;
import java.util.Comparator;

public class TransferComparator
implements Comparator<Transfer> {
    public static final int BY_EXT = 0;
    public static final int BY_FILE_NAME = 1;
    public static final int BY_PROGRESS = 2;
    public static final int BY_SIZE = 3;
    public static final int BY_FOLDER = 4;
    public static final int BY_MEMBER = 5;
    private int sortBy;

    public TransferComparator(int n) {
        this.sortBy = n;
    }

    @Override
    public int compare(Transfer transfer, Transfer transfer2) {
        switch (this.sortBy) {
            case 0: {
                return transfer.getFile().getExtension().compareTo(transfer2.getFile().getExtension());
            }
            case 1: {
                return transfer.getFile().getFilenameOnly().compareToIgnoreCase(transfer2.getFile().getFilenameOnly());
            }
            case 2: {
                int n = transfer.getState().compareTo(transfer2.getState());
                if (n == 0 && transfer.getCompletedDate() != null && transfer2.getCompletedDate() != null) {
                    return -transfer.getCompletedDate().compareTo(transfer2.getCompletedDate());
                }
                return n;
            }
            case 3: {
                long l = transfer.getFile().getSize();
                long l2 = transfer2.getFile().getSize();
                if (l == l2) {
                    return 0;
                }
                return l - l2 > 0L ? 1 : -1;
            }
            case 4: {
                return transfer.getFile().getFolderInfo().getName().compareTo(transfer2.getFile().getFolderInfo().getName());
            }
            case 5: {
                return transfer.getPartner().getNick().compareTo(transfer2.getPartner().getNick());
            }
        }
        return 0;
    }

    public String toString() {
        Object object = "FileInfo comparator, sorting by ";
        switch (this.sortBy) {
            case 0: {
                object = (String)object + "extension";
                break;
            }
            case 1: {
                object = (String)object + "extension";
                break;
            }
            case 2: {
                object = (String)object + "progress";
                break;
            }
            case 3: {
                object = (String)object + "size";
                break;
            }
            case 4: {
                object = (String)object + "folder";
                break;
            }
            case 5: {
                object = (String)object + "member";
            }
        }
        return object;
    }
}

