/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.WrappedCallable;
import de.dal33t.powerfolder.util.WrappedRunnable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class WrapperExecutorService
implements ExecutorService {
    private ExecutorService deligate;

    public WrapperExecutorService(ExecutorService executorService) {
        Reject.ifNull(executorService, "Deligate is null");
        this.deligate = executorService;
    }

    @Override
    public void execute(Runnable runnable) {
        this.deligate.execute(new WrappedRunnable(runnable));
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.deligate.submit(new WrappedCallable<T>(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.deligate.submit(new WrappedRunnable(runnable), t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.deligate.submit(new WrappedRunnable(runnable));
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.deligate.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.deligate.invokeAll(collection);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.deligate.invokeAll(collection, l, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.deligate.invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.deligate.invokeAny(collection, l, timeUnit);
    }

    @Override
    public boolean isShutdown() {
        return this.deligate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.deligate.isTerminated();
    }

    @Override
    public void shutdown() {
        this.deligate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.deligate.shutdownNow();
    }
}

