/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.message.FileChunk;
import de.dal33t.powerfolder.util.Format;
import java.io.Serializable;
import java.util.Date;

public class TransferCounter
implements Serializable {
    private static final long serialVersionUID = 100L;
    private static final long CURRENT_CPS_CALCULATION_PERIOD = 10000L;
    private Date since;
    private long bytesTransferred;
    private long bytesAlreadyTransferred;
    private long bytesExpected;
    private Date counter1Since;
    private Date counter2Since;
    private long counter1Bytes;
    private long counter2Bytes;
    private boolean counter1Active;

    public TransferCounter() {
    }

    public TransferCounter(long l, long l2) {
        this();
        this.bytesAlreadyTransferred = l;
        this.bytesExpected = l2;
    }

    public synchronized void startedTransfer() {
        this.counter1Since = new Date();
        this.counter2Since = new Date();
        this.counter1Bytes = 0L;
        this.counter2Bytes = 0L;
    }

    public synchronized void stoppedTransfer() {
        this.counter2Since = null;
        this.counter1Since = null;
    }

    public synchronized boolean isTransferring() {
        return this.counter1Since != null && this.counter2Since != null;
    }

    public void chunkTransferred(FileChunk fileChunk) {
        this.bytesTransferred(fileChunk.data.length);
    }

    public void bytesTransferred(long l) {
        if (this.since == null) {
            this.since = new Date();
        }
        if (!this.isTransferring()) {
            this.startedTransfer();
        } else {
            this.counter1Bytes += l;
            this.counter2Bytes += l;
        }
        this.bytesTransferred += l;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public long getBytesExpected() {
        return this.bytesExpected;
    }

    public double calculateAverageCPS() {
        if (this.since == null) {
            return 0.0;
        }
        long l = System.currentTimeMillis() - this.since.getTime();
        return (double)this.bytesTransferred * 1000.0 / (double)l;
    }

    public double calculateAverageKBS() {
        return this.calculateAverageCPS() / 1024.0;
    }

    public synchronized double calculateCurrentCPS() {
        if (this.counter1Since == null || this.counter1Since == null) {
            return 0.0;
        }
        long l = this.counter1Active ? this.counter1Bytes : this.counter2Bytes;
        Date date = this.counter1Active ? this.counter1Since : this.counter2Since;
        Date date2 = this.counter1Active ? this.counter2Since : this.counter1Since;
        long l2 = System.currentTimeMillis() - date.getTime();
        if (System.currentTimeMillis() - date2.getTime() > 10000L) {
            this.switchActiveCounter();
        }
        if (l2 == 0L) {
            return 0.0;
        }
        return (double)l * 1000.0 / (double)l2;
    }

    public double calculateCurrentKBS() {
        return this.calculateCurrentCPS() / 1024.0;
    }

    public double calculateCompletionPercentage() {
        if (this.bytesExpected == 0L) {
            return 100.0;
        }
        double d = this.bytesAlreadyTransferred + this.bytesTransferred;
        return d / (double)this.bytesExpected * 100.0;
    }

    public long calculateEstimatedMillisToCompletion() {
        if (this.calculateAverageCPS() < 1.0E-5) {
            return 0L;
        }
        long l = (long)((double)((this.bytesExpected - this.bytesAlreadyTransferred - this.bytesTransferred) * 1000L) / this.calculateAverageCPS());
        return l > 0L ? l : 0L;
    }

    private void switchActiveCounter() {
        if (this.counter1Active) {
            this.counter1Active = false;
            this.counter1Bytes = 0L;
            this.counter1Since.setTime(System.currentTimeMillis());
        } else {
            this.counter1Active = true;
            this.counter2Bytes = 0L;
            this.counter2Since.setTime(System.currentTimeMillis());
        }
    }

    public String toString() {
        return "TransferCounter {bytes: " + Format.formatBytesShort(this.getBytesTransferred()) + " current: " + Format.formatBytesShort((long)(1024.0 * this.calculateCurrentKBS())) + "/s}";
    }
}

