/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import java.lang.reflect.Method;
import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProUtil {
    private static final Logger LOG = Logger.getLogger(Util.class.getName());

    private ProUtil() {
    }

    public static final boolean isServerConfig(Controller controller) {
        return controller.getConfig().get("plugin.server.maintenancefolderid") != null;
    }

    public static final String getBuyNowURL(Controller controller) {
        String string = ConfigurationEntry.PROVIDER_BUY_URL.getValue(controller);
        if (StringUtils.isBlank(string)) {
            return null;
        }
        return string;
    }

    public static final boolean isRunningProVersion() {
        return Util.class.getClassLoader().getResourceAsStream("de/dal33t/powerfolder/ConfigurationProEntry.class") != null;
    }

    public static final boolean isTrial(Controller controller) {
        if (!ProUtil.isRunningProVersion()) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName("de.dal33t.powerfolder.CD");
            Method method = clazz.getMethod("isTrial", Controller.class);
            return (Boolean)method.invoke(null, controller);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Exception. " + exception, exception);
            return true;
        }
    }

    public static final PublicKey getPublicKey(Controller controller, MemberInfo memberInfo) {
        if (!ProUtil.isRunningProVersion()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("de.dal33t.powerfolder.BC");
            Method method = clazz.getMethod("getPublicKey", Controller.class, MemberInfo.class);
            return (PublicKey)method.invoke(null, controller, memberInfo);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Exception. " + exception, exception);
            return null;
        }
    }

    public static final boolean addNodeToKeyStore(Controller controller, MemberInfo memberInfo, PublicKey publicKey) {
        try {
            Class<?> clazz = Class.forName("de.dal33t.powerfolder.BC");
            Method method = clazz.getMethod("addNodeToKeyStore", Controller.class, MemberInfo.class, PublicKey.class);
            return (Boolean)method.invoke(null, controller, memberInfo, publicKey);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Exception. " + exception, exception);
            return false;
        }
    }

    public static final String rtrvePwssd(Controller controller, String string) {
        try {
            Class<?> clazz = Class.forName("de.dal33t.powerfolder.CD");
            Method method = clazz.getMethod("rtrvePwssd", Controller.class, String.class);
            return (String)method.invoke(null, controller, string);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Exception. " + exception, exception);
            return null;
        }
    }
}

