/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.task.SendMessageTask;
import de.dal33t.powerfolder.util.Reject;
import java.util.logging.Logger;

public class InvitationUtil {
    private static final Logger log = Logger.getLogger(InvitationUtil.class.getName());

    private InvitationUtil() {
    }

    public static boolean isDefaultMessage(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("Attach a personal message") || string.equalsIgnoreCase("Pers\u00f6nliche Nachrichten anh\u00e4ngen");
    }

    public static boolean invitationToNode(Controller controller, Invitation invitation, Member member) {
        Reject.ifNull(controller, "Controller is null");
        Reject.ifNull(invitation, "Invitation is null");
        Reject.ifNull(member, "Node is null");
        controller.getTaskManager().scheduleTask(new SendMessageTask(invitation, member.getId()));
        if (!member.isCompletelyConnected()) {
            member.markForImmediateConnect();
            return false;
        }
        return true;
    }
}

