/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ImmutableList<E>
implements Iterable<E>,
Serializable {
    private static final long serialVersionUID = -654244056844800570L;
    private final E head;
    private final ImmutableList<E> tail;

    public ImmutableList(E e) {
        this.head = e;
        this.tail = null;
    }

    private ImmutableList(E e, ImmutableList<E> immutableList) {
        assert (immutableList != null);
        this.head = e;
        this.tail = immutableList;
    }

    public E getHead() {
        return this.head;
    }

    public ImmutableList<E> getTail() {
        return this.tail;
    }

    public int hashCode() {
        ImmutableList<E> immutableList = this;
        int n = 17;
        while (immutableList != null) {
            n = n * 37 + immutableList.head.hashCode();
            immutableList = immutableList.tail;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ImmutableList<E> immutableList = this;
        ImmutableList<E> immutableList2 = (ImmutableList<E>)object;
        while (immutableList != null && immutableList2 != null) {
            if (immutableList.head != immutableList2.head) {
                return false;
            }
            immutableList = immutableList.tail;
            immutableList2 = immutableList2.tail;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private ImmutableList<E> pos;
            {
                this.pos = ImmutableList.this;
            }

            @Override
            public boolean hasNext() {
                return this.pos.tail != null;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.pos = this.pos.tail;
                return this.pos.head;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ImmutableList<E> add(E e) {
        return new ImmutableList<E>(e, this);
    }
}

