/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.widget.LinkLabel;
import de.dal33t.powerfolder.ui.wizard.ChooseMultiDiskLocationPanel;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.MultiFolderSetupPanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import jwf.WizardContext;
import jwf.WizardPanel;

public class WhatToDoPanel
extends PFWizardPanel {
    static final int PICTO_FONT_SIZE = 6;
    private static final Object synchronizedOption = new Object();
    private static final Object backupOption = new Object();
    private static final Object hostOption = new Object();
    private static final Object downloadOption = new Object();
    private static final Object customOption = new Object();
    private ActionLabel synchronizedLink;
    private ActionLabel backupLink;
    private ActionLabel hostLink;
    private ActionLabel downloadLink;
    private ActionLabel moreLink;
    private ActionLabel customLink;
    private LinkLabel documentationLink;
    private ValueModel decision;

    public WhatToDoPanel(Controller controller) {
        super(controller);
    }

    @Override
    public boolean hasNext() {
        return this.decision.getValue() != null;
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("140dlu, 3dlu, pref", "pref, 12dlu, pref, 30dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(Borders.createEmptyBorder("20dlu, 10dlu, 0, 0"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.synchronizedLink.getUIComponent(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.hostLink.getUIComponent(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.backupLink.getUIComponent(), cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.downloadLink.getUIComponent(), cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this.moreLink.getUIComponent(), cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.customLink.getUIComponent(), cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.documentationLink.getUIComponent(), cellConstraints.xy(3, 5));
        panelBuilder.getPanel().setOpaque(false);
        return panelBuilder.getPanel();
    }

    @Override
    public WizardPanel next() {
        Object object = this.decision.getValue();
        if (object == synchronizedOption) {
            return WhatToDoPanel.doSyncOption(this.getController(), this.getWizardContext(), true);
        }
        if (object == backupOption) {
            return WhatToDoPanel.doBackupOption(this.getController(), this.getWizardContext());
        }
        if (object == hostOption) {
            return WhatToDoPanel.doHostOption(this.getController(), this.getWizardContext());
        }
        if (object == downloadOption) {
            return WhatToDoPanel.doDownloadOption(this.getController(), this.getWizardContext());
        }
        if (object == customOption) {
            return this.doCustomAction();
        }
        return null;
    }

    private WizardPanel doCustomAction() {
        this.getWizardContext().setAttribute("disklocation.folder_info", null);
        this.getWizardContext().setAttribute("disklocation.sync_profile", SyncProfile.AUTOMATIC_SYNCHRONIZATION);
        this.getWizardContext().setAttribute("disklocation.prompt_text", null);
        this.getWizardContext().setAttribute("disklocation.send_invitations", true);
        this.getWizardContext().setAttribute("folder_create.backup_by_os", true);
        TextPanelPanel textPanelPanel = new TextPanelPanel(this.getController(), Translation.get("wizard.setup_success"), Translation.get("exp.wizard.project_name.folder_project_success") + Translation.get("wizard.what_to_do.pcs_join"));
        this.getWizardContext().setAttribute("successpanel", textPanelPanel);
        MultiFolderSetupPanel multiFolderSetupPanel = new MultiFolderSetupPanel(this.getController());
        return new ChooseMultiDiskLocationPanel(this.getController(), multiFolderSetupPanel, true);
    }

    public static PFWizardPanel doHostOption(Controller controller, WizardContext wizardContext) {
        wizardContext.setAttribute("disklocation.folder_info", null);
        wizardContext.setAttribute("disklocation.sync_profile", SyncProfile.HOST_FILES);
        wizardContext.setAttribute("disklocation.prompt_text", Translation.get("wizard.what_to_do.host_pcs.select"));
        wizardContext.setAttribute("disklocation.send_invitations", true);
        wizardContext.setAttribute("folder_create.backup_by_os", true);
        TextPanelPanel textPanelPanel = new TextPanelPanel(controller, Translation.get("wizard.setup_success"), Translation.get("wizard.what_to_do.folder_host_success") + Translation.get("wizard.what_to_do.host_pcs_join"));
        wizardContext.setAttribute("successpanel", textPanelPanel);
        FolderCreatePanel folderCreatePanel = new FolderCreatePanel(controller);
        return new ChooseMultiDiskLocationPanel(controller, folderCreatePanel, true);
    }

    public static PFWizardPanel doDownloadOption(Controller controller, WizardContext wizardContext) {
        wizardContext.setAttribute("disklocation.folder_info", null);
        wizardContext.setAttribute("disklocation.sync_profile", SyncProfile.AUTOMATIC_DOWNLOAD);
        wizardContext.setAttribute("disklocation.prompt_text", Translation.get("wizard.what_to_do.download.select"));
        wizardContext.setAttribute("disklocation.send_invitations", false);
        wizardContext.setAttribute("folder_create.backup_by_os", false);
        TextPanelPanel textPanelPanel = new TextPanelPanel(controller, Translation.get("wizard.setup_success"), Translation.get("wizard.what_to_do.folder_download_sucess"));
        wizardContext.setAttribute("successpanel", textPanelPanel);
        FolderCreatePanel folderCreatePanel = new FolderCreatePanel(controller);
        return new ChooseMultiDiskLocationPanel(controller, folderCreatePanel, true);
    }

    public static PFWizardPanel doBackupOption(Controller controller, WizardContext wizardContext) {
        wizardContext.setAttribute("disklocation.folder_info", null);
        wizardContext.setAttribute("disklocation.sync_profile", SyncProfile.BACKUP_SOURCE);
        wizardContext.setAttribute("disklocation.prompt_text", Translation.get("wizard.what_to_do.backp.select"));
        wizardContext.setAttribute("disklocation.send_invitations", false);
        wizardContext.setAttribute("folder_create.backup_by_os", true);
        TextPanelPanel textPanelPanel = new TextPanelPanel(controller, Translation.get("wizard.setup_success"), Translation.get("wizard.what_to_do.folder_backup_success") + Translation.get("wizard.what_to_do.pcs_join"));
        wizardContext.setAttribute("successpanel", textPanelPanel);
        FolderCreatePanel folderCreatePanel = new FolderCreatePanel(controller);
        return new ChooseMultiDiskLocationPanel(controller, folderCreatePanel, true);
    }

    public static PFWizardPanel doSyncOption(Controller controller, WizardContext wizardContext, boolean bl) {
        wizardContext.setAttribute("disklocation.folder_info", null);
        wizardContext.setAttribute("disklocation.sync_profile", SyncProfile.AUTOMATIC_SYNCHRONIZATION);
        wizardContext.setAttribute("disklocation.send_invitations", false);
        wizardContext.setAttribute("folder_create.backup_by_os", controller.getOSClient().isBackupByDefault());
        wizardContext.setAttribute("disklocation.prompt_text", Translation.get("wizard.what_to_do.sync_pcs.select"));
        TextPanelPanel textPanelPanel = new TextPanelPanel(controller, Translation.get("wizard.setup_success"), Translation.get("wizard.what_to_do.sync_pcs.success") + Translation.get("wizard.what_to_do.sync_pcs.pcs_join"));
        wizardContext.setAttribute("successpanel", textPanelPanel);
        FolderCreatePanel folderCreatePanel = new FolderCreatePanel(controller);
        return new ChooseMultiDiskLocationPanel(controller, folderCreatePanel, bl);
    }

    @Override
    public void initComponents() {
        this.decision = new ValueHolder();
        this.decision.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WhatToDoPanel.this.updateButtons();
            }
        });
        this.synchronizedLink = new ActionLabel(this.getController(), new WhatToDoAction(Translation.get("wizard.what_to_do.synchronized_folder"), synchronizedOption, this.decision));
        this.synchronizedLink.setToolTipText(Translation.get("wizard.what_to_do.synchronized_folder.tip"));
        this.synchronizedLink.convertToBigLabel();
        this.backupLink = new ActionLabel(this.getController(), new WhatToDoAction(Translation.get("wizard.what_to_do.backup_folder"), backupOption, this.decision));
        this.backupLink.setToolTipText(Translation.get("wizard.what_to_do.backup_folder.tip"));
        this.backupLink.convertToBigLabel();
        this.hostLink = new ActionLabel(this.getController(), new WhatToDoAction(Translation.get("wizard.what_to_do.host_work"), hostOption, this.decision));
        this.hostLink.setToolTipText(Translation.get("wizard.what_to_do.host_work.tip"));
        this.hostLink.convertToBigLabel();
        this.downloadLink = new ActionLabel(this.getController(), new WhatToDoAction(Translation.get("wizard.what_to_do.download"), downloadOption, this.decision));
        this.downloadLink.setToolTipText(Translation.get("wizard.what_to_do.download.tip"));
        this.downloadLink.convertToBigLabel();
        this.moreLink = new ActionLabel(this.getController(), new AbstractAction(Translation.get("wizard.what_to_do.more")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WhatToDoPanel.this.moreLink.setVisible(false);
                WhatToDoPanel.this.customLink.setVisible(true);
                WhatToDoPanel.this.documentationLink.setVisible(true);
            }
        });
        this.moreLink.setToolTipText(Translation.get("wizard.what_to_do.more.tip"));
        this.moreLink.convertToBigLabel();
        this.customLink = new ActionLabel(this.getController(), new WhatToDoAction(Translation.get("wizard.what_to_do.custom_sync"), customOption, this.decision));
        this.customLink.setToolTipText(Translation.get("wizard.what_to_do.custom_sync.tip"));
        this.customLink.convertToBigLabel();
        this.customLink.setVisible(false);
        this.documentationLink = Help.createQuickstartGuideLabel(this.getController(), Translation.get("wizard.what_to_do.open_online_documentation"));
        this.documentationLink.setToolTipText(Translation.get("wizard.what_to_do.open_online_documentation.tip"));
        this.documentationLink.convertToBigLabel();
        this.documentationLink.setVisible(false);
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.what_to_do.title");
    }

    private class WhatToDoAction
    extends AbstractAction {
        private ValueModel model;
        private Object option;

        private WhatToDoAction(String string, Object object, ValueModel valueModel) {
            this.model = valueModel;
            this.option = object;
            this.putValue("Name", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.model.setValue(this.option);
            WhatToDoPanel.this.getWizard().next();
        }
    }
}

