/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.panel.SyncProfileSelectorPanel;
import de.dal33t.powerfolder.ui.wizard.FolderCreateItem;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.UserDirectories;
import de.dal33t.powerfolder.util.UserDirectory;
import java.awt.Component;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jwf.WizardPanel;

public class TypicalFolderSetupPanel
extends PFWizardPanel {
    private JLabel folderTextField;
    private JTextField localFolderField;
    private SyncProfileSelectorPanel syncProfileSelectorPanel;
    private FolderInfo folderInfo;

    public TypicalFolderSetupPanel(Controller controller) {
        super(controller);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public WizardPanel next() {
        ArrayList<FolderCreateItem> arrayList = new ArrayList<FolderCreateItem>();
        Path path = Paths.get(this.localFolderField.getText(), new String[0]);
        FolderCreateItem folderCreateItem = new FolderCreateItem(path);
        folderCreateItem.setArchiveHistory(ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.getController()));
        folderCreateItem.setSyncProfile(this.syncProfileSelectorPanel.getSyncProfile());
        folderCreateItem.setFolderInfo(this.folderInfo);
        arrayList.add(folderCreateItem);
        this.getWizardContext().setAttribute("disklocation.folder_create_items", arrayList);
        return new FolderCreatePanel(this.getController());
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, 140dlu, 3dlu, 15dlu, pref:grow", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(Translation.get("general.folder"), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.folderTextField, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)new JLabel(Translation.get("wizard.multi_online_storage_setup.local_folder_location")), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.localFolderField, cellConstraints.xy(3, 3));
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)new JLabel(Translation.get("general.transfer_mode")), cellConstraints.xy(1, 5));
            JPanel jPanel = (JPanel)this.syncProfileSelectorPanel.getUIComponent();
            jPanel.setOpaque(false);
            panelBuilder.add((Component)jPanel, cellConstraints.xyw(3, 5, 4));
        }
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        this.folderTextField = new JLabel();
        this.localFolderField = new JTextField();
        this.localFolderField.setEditable(false);
        this.syncProfileSelectorPanel = new SyncProfileSelectorPanel(this.getController());
    }

    @Override
    public void afterDisplay() {
        this.folderInfo = (FolderInfo)this.getWizardContext().getAttribute("folder.info");
        ServerClient serverClient = this.getController().getOSClient();
        if (serverClient.isConnected() && serverClient.isLoggedIn()) {
            for (FolderInfo object2 : serverClient.getAccountFolders()) {
                if (!this.folderInfo.getName().equals(object2.getName())) continue;
                this.folderInfo = object2;
                break;
            }
        }
        Reject.ifNull(this.folderInfo, "Expecting a single folder info");
        this.folderTextField.setText(this.folderInfo.getLocalizedName());
        boolean bl = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController());
        Map<String, UserDirectory> map = UserDirectories.getUserDirectoriesFiltered(this.getController(), bl);
        for (String string : map.keySet()) {
            if (!string.equals(this.folderInfo.getName())) continue;
            UserDirectory userDirectory = map.get(string);
            this.localFolderField.setText(userDirectory.getDirectory().toAbsolutePath().toString());
        }
    }

    @Override
    protected String getTitle() {
        return Translation.get("exp.wizard.typical_folder_setup.title");
    }
}

