/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import jwf.Wizard;
import jwf.WizardPanel;

public class SwingWorkerPanel
extends PFWizardPanel {
    private static final Logger LOG = Logger.getLogger(SwingWorkerPanel.class.getName());
    private JLabel statusLabel;
    private JLabel problemLabel;
    private JProgressBar bar;
    private SwingWorker<Void, Void> worker;
    private Runnable task;
    private String title;
    private String text;
    private WizardPanel nextPanel;
    private boolean canFinish;

    public SwingWorkerPanel(Controller controller, Runnable runnable, String string, String string2, WizardPanel wizardPanel) {
        super(controller);
        this.title = string;
        this.text = string2;
        this.nextPanel = wizardPanel;
        this.task = runnable;
        this.canFinish = false;
    }

    public void setTask(Runnable runnable) {
        this.task = runnable;
    }

    @Override
    public boolean canFinish() {
        return this.canFinish;
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("140dlu, 0:grow", "pref, 7dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        this.statusLabel = panelBuilder.addLabel(this.text, cellConstraints.xyw(1, n, 2));
        this.bar = new JProgressBar();
        this.bar.setIndeterminate(true);
        panelBuilder.add((Component)this.bar, cellConstraints.xy(1, n += 2));
        this.problemLabel = new JLabel();
        this.problemLabel.setIcon(Icons.getIconById("warning.icon"));
        this.problemLabel.setVisible(false);
        panelBuilder.add((Component)this.problemLabel, cellConstraints.xyw(1, n, 2));
        return panelBuilder.getPanel();
    }

    @Override
    protected void afterDisplay() {
        if (this.worker != null) {
            this.worker.cancel(true);
            this.getWizard().back();
        } else {
            this.bar.setVisible(true);
            this.problemLabel.setVisible(false);
            this.updateButtons();
            this.worker = new MySwingWorker();
            this.worker.execute();
        }
    }

    @Override
    protected void initComponents() {
    }

    @Override
    protected String getTitle() {
        return !this.isProblem() ? this.title : Translation.get("wizard.worker.problem");
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public WizardPanel next() {
        return this.nextPanel;
    }

    private void showProblem(String string) {
        LOG.warning(string);
        this.bar.setVisible(false);
        this.statusLabel.setText(" ");
        String string2 = string.replace("de.dal33t.powerfolder.", "");
        if (string2.contains("\n")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(string2.replace("\n", "<br />"));
            stringBuilder.append("</html>");
            string2 = stringBuilder.toString();
        }
        this.problemLabel.setText(string2);
        this.problemLabel.setVisible(true);
        this.canFinish = false;
        this.updateButtons();
        this.updateTitle();
    }

    private boolean isProblem() {
        return this.problemLabel.isVisible();
    }

    private class MySwingWorker
    extends SwingWorker<Void, Void> {
        private MySwingWorker() {
        }

        @Override
        public void done() {
            SwingWorkerPanel.this.bar.setVisible(false);
            try {
                this.get();
                Wizard wizard = SwingWorkerPanel.this.getWizard();
                if (wizard.getCurrentPanel() == SwingWorkerPanel.this) {
                    wizard.next();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (ExecutionException executionException) {
                String string = executionException.getCause().getMessage();
                if (StringUtils.isBlank(string)) {
                    string = executionException.getMessage();
                }
                if (StringUtils.isBlank(string)) {
                    string = executionException.toString();
                }
                LOG.warning(string);
                LOG.log(Level.FINE, executionException.toString(), executionException);
                SwingWorkerPanel.this.showProblem(string);
            }
        }

        @Override
        protected Void doInBackground() throws Exception {
            Reject.ifNull(SwingWorkerPanel.this.task, "No task found to execute");
            SwingWorkerPanel.this.task.run();
            return null;
        }
    }
}

