/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.FolderService;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.FileArchiver;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.wizard.FileRestoringPanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.data.SingleFileRestoreItem;
import de.dal33t.powerfolder.ui.wizard.table.SingleFileRestoreTable;
import de.dal33t.powerfolder.ui.wizard.table.SingleFileRestoreTableModel;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jwf.WizardPanel;

public class SingleFileRestorePanel
extends PFWizardPanel {
    private final Folder folder;
    private final FileInfo fileInfoToRestore;
    private final FileInfo selectedFileInfo;
    private final JLabel infoLabel;
    private boolean hasNext;
    private SwingWorker<List<SingleFileRestoreItem>, Object> worker;
    private final JProgressBar bar;
    private JScrollPane scrollPane;
    private final SingleFileRestoreTableModel tableModel;
    private final SingleFileRestoreTable table;
    private final JRadioButton originalRadio;
    private final JLabel originalLabel;
    private final JRadioButton alternateLocationRadio;
    private final JTextField alternateLocationTF;
    private final JButton alternateLocationButton;
    private final JRadioButton alternateNameRadio;
    private final JTextField alternateNameTF;

    public SingleFileRestorePanel(Controller controller, Folder folder, FileInfo fileInfo) {
        this(controller, folder, fileInfo, null);
    }

    public SingleFileRestorePanel(Controller controller, Folder folder, FileInfo fileInfo, FileInfo fileInfo2) {
        super(controller);
        this.folder = folder;
        this.fileInfoToRestore = fileInfo;
        this.selectedFileInfo = fileInfo2;
        this.infoLabel = new JLabel();
        this.bar = new JProgressBar();
        this.tableModel = new SingleFileRestoreTableModel(this.getController());
        this.table = new SingleFileRestoreTable(this.tableModel);
        this.originalRadio = new JRadioButton(Translation.get("wizard.single_file_restore.original.text"));
        this.originalLabel = new JLabel();
        this.alternateLocationRadio = new JRadioButton(Translation.get("wizard.single_file_restore.alternate_location.text"));
        this.alternateLocationTF = new JTextField();
        this.alternateLocationButton = new JButtonMini(Icons.getIconById("directory.icon"), Translation.get("wizard.single_file_restore.select_directory.tip"));
        this.alternateNameRadio = new JRadioButton(Translation.get("wizard.single_file_restore.alternate_name.text"));
        this.alternateNameTF = new JTextField();
    }

    @Override
    protected JComponent buildContent() {
        FormLayout formLayout = new FormLayout("140dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.infoLabel, cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.buildLocationPanel(), cellConstraints.xyw(1, 3, 2));
        panelBuilder.add((Component)this.bar, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.scrollPane, cellConstraints.xyw(1, 5, 2));
        return panelBuilder.getPanel();
    }

    private JComponent buildLocationPanel() {
        FormLayout formLayout = new FormLayout("pref, 3dlu, 140dlu, 3dlu, pref", "pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.originalRadio, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.originalLabel, cellConstraints.xyw(3, 1, 3));
        panelBuilder.add((Component)this.alternateLocationRadio, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.alternateLocationTF, cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this.alternateLocationButton, cellConstraints.xy(5, 3));
        this.alternateLocationButton.addActionListener(new MyActionListener());
        panelBuilder.add((Component)this.alternateNameRadio, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.alternateNameTF, cellConstraints.xy(3, 5));
        return panelBuilder.getPanel();
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.single_file_restore.title");
    }

    @Override
    protected void initComponents() {
        this.bar.setIndeterminate(true);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(400, 200));
        this.scrollPane.setVisible(false);
        UIUtil.removeBorder(this.scrollPane);
        UIUtil.setZeroWidth(this.scrollPane);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.originalRadio);
        buttonGroup.add(this.alternateLocationRadio);
        buttonGroup.add(this.alternateNameRadio);
        this.originalRadio.setSelected(true);
        this.originalLabel.setText(this.fileInfoToRestore.getDiskFile(this.getController().getFolderRepository()).getParent().toString());
        this.originalRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleFileRestorePanel.this.updateLocations();
            }
        });
        this.alternateLocationRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleFileRestorePanel.this.updateLocations();
            }
        });
        this.alternateLocationTF.setEditable(false);
        this.alternateLocationTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SingleFileRestorePanel.this.updateLocations();
            }
        });
        this.alternateNameRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleFileRestorePanel.this.defaultName();
            }
        });
        this.alternateNameTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SingleFileRestorePanel.this.updateLocations();
            }
        });
        this.updateLocations();
    }

    private void defaultName() {
        SingleFileRestoreItem singleFileRestoreItem = this.table.getSelectedRestoreItem();
        if (singleFileRestoreItem != null) {
            Object object = singleFileRestoreItem.getFileInfo().getFilenameOnly();
            int n = singleFileRestoreItem.getFileInfo().getVersion();
            if (((String)object).lastIndexOf(46) >= 0) {
                String string = ((String)object).substring(0, ((String)object).lastIndexOf(46));
                String string2 = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
                object = string + "_" + n + "." + string2;
            } else {
                object = (String)object + "_" + n;
            }
            this.alternateNameTF.setText((String)object);
        } else {
            this.alternateNameTF.setText("");
        }
        this.updateLocations();
    }

    private void updateLocations() {
        SingleFileRestoreItem singleFileRestoreItem = this.table.getSelectedRestoreItem();
        if (singleFileRestoreItem == null) {
            this.originalRadio.setVisible(false);
            this.originalLabel.setVisible(false);
            this.alternateLocationRadio.setVisible(false);
            this.alternateLocationTF.setVisible(false);
            this.alternateLocationButton.setVisible(false);
            this.alternateNameRadio.setVisible(false);
            this.alternateNameTF.setVisible(false);
            this.hasNext = false;
        } else {
            this.originalRadio.setVisible(true);
            this.originalLabel.setVisible(true);
            this.originalLabel.setEnabled(this.originalRadio.isSelected());
            if (singleFileRestoreItem.isLocal()) {
                this.alternateLocationRadio.setVisible(true);
                this.alternateLocationTF.setVisible(true);
                this.alternateLocationButton.setVisible(true);
                this.alternateNameRadio.setVisible(false);
                this.alternateNameTF.setVisible(false);
                if (this.alternateNameRadio.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SingleFileRestorePanel.this.originalRadio.setSelected(true);
                        }
                    });
                }
            } else {
                this.alternateLocationRadio.setVisible(false);
                this.alternateLocationTF.setVisible(false);
                this.alternateLocationButton.setVisible(false);
                this.alternateNameRadio.setVisible(true);
                this.alternateNameTF.setVisible(true);
                this.alternateNameTF.setEnabled(this.alternateNameRadio.isSelected());
                if (this.alternateLocationRadio.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SingleFileRestorePanel.this.originalRadio.setSelected(true);
                        }
                    });
                }
            }
            this.hasNext = this.originalRadio.isSelected() || this.alternateLocationRadio.isSelected() && this.alternateLocationTF.getText().length() > 0 || this.alternateNameRadio.isSelected() && this.alternateNameTF.getText().length() > 0;
        }
        this.updateButtons();
    }

    @Override
    protected void afterDisplay() {
        this.loadVersions();
    }

    private void loadVersions() {
        this.infoLabel.setText(Translation.get("wizard.multi_file_restore.retrieving.text"));
        this.hasNext = false;
        this.updateButtons();
        if (this.worker != null) {
            this.worker.cancel(false);
        }
        this.tableModel.setFileInfos(new ArrayList<SingleFileRestoreItem>());
        this.bar.setVisible(true);
        this.scrollPane.setVisible(false);
        this.worker = new VersionLoaderWorker();
        this.worker.execute();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public WizardPanel next() {
        Path path;
        String string;
        SingleFileRestoreItem singleFileRestoreItem = this.table.getSelectedRestoreItem();
        if (singleFileRestoreItem == null) {
            throw new IllegalStateException("Could not find the selected file info.");
        }
        if (this.alternateLocationRadio.isSelected() && (string = this.alternateLocationTF.getText()) != null && string.trim().length() > 0 && Files.isDirectory(path = Paths.get(string.trim(), new String[0]), new LinkOption[0]) && Files.isWritable(path)) {
            return new FileRestoringPanel(this.getController(), this.folder, singleFileRestoreItem.getFileInfo(), path);
        }
        if (this.alternateNameRadio.isSelected()) {
            return new FileRestoringPanel(this.getController(), this.folder, singleFileRestoreItem.getFileInfo(), this.alternateNameTF.getText().trim());
        }
        return new FileRestoringPanel(this.getController(), this.folder, singleFileRestoreItem.getFileInfo());
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SingleFileRestorePanel.this.alternateLocationRadio.setSelected(true);
                    SingleFileRestorePanel.this.updateLocations();
                }
            });
            List<Path> list = DialogFactory.chooseDirectory(SingleFileRestorePanel.this.getController().getUIController(), SingleFileRestorePanel.this.alternateLocationTF.getText(), false);
            if (list.isEmpty()) {
                return;
            }
            Path path = list.get(0);
            SingleFileRestorePanel.this.alternateLocationTF.setText(path.toString());
            SingleFileRestorePanel.this.updateLocations();
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SingleFileRestorePanel.this.updateLocations();
        }
    }

    private class VersionLoaderWorker
    extends SwingWorker<List<SingleFileRestoreItem>, Object> {
        private VersionLoaderWorker() {
        }

        @Override
        protected List<SingleFileRestoreItem> doInBackground() {
            FolderService folderService = null;
            ServerClient serverClient = SingleFileRestorePanel.this.getController().getOSClient();
            if (serverClient.isConnected() && serverClient.isLoggedIn()) {
                folderService = serverClient.getFolderService(SingleFileRestorePanel.this.folder.getInfo());
            }
            FileArchiver fileArchiver = SingleFileRestorePanel.this.folder.getFileArchiver();
            List<FileInfo> list = fileArchiver.getArchivedFilesInfos(SingleFileRestorePanel.this.fileInfoToRestore);
            ArrayList<SingleFileRestoreItem> arrayList = new ArrayList<SingleFileRestoreItem>();
            for (FileInfo object : list) {
                arrayList.add(new SingleFileRestoreItem(object, true));
            }
            if (folderService != null) {
                try {
                    List<FileInfo> list2 = folderService.getArchivedFilesInfos(SingleFileRestorePanel.this.fileInfoToRestore);
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        FileInfo fileInfo = (FileInfo)iterator.next();
                        boolean bl = false;
                        for (SingleFileRestoreItem singleFileRestoreItem : arrayList) {
                            if (!fileInfo.isVersionDateAndSizeIdentical(singleFileRestoreItem.getFileInfo())) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        arrayList.add(new SingleFileRestoreItem(fileInfo, false));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return arrayList;
        }

        @Override
        protected void done() {
            try {
                if (((List)this.get()).isEmpty()) {
                    SingleFileRestorePanel.this.infoLabel.setText(Translation.get("wizard.single_file_restore.retrieved_none.text", SingleFileRestorePanel.this.fileInfoToRestore.getFilenameOnly()));
                } else {
                    SingleFileRestorePanel.this.infoLabel.setText(Translation.get("wizard.single_file_restore.retrieved.text", String.valueOf(((List)this.get()).size()), SingleFileRestorePanel.this.fileInfoToRestore.getFilenameOnly()));
                }
                List list = (List)this.get();
                Collections.sort(list, new Comparator<SingleFileRestoreItem>(){

                    @Override
                    public int compare(SingleFileRestoreItem singleFileRestoreItem, SingleFileRestoreItem singleFileRestoreItem2) {
                        return singleFileRestoreItem.getFileInfo().getVersion() - singleFileRestoreItem2.getFileInfo().getVersion();
                    }
                });
                SingleFileRestorePanel.this.tableModel.setFileInfos(list);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SingleFileRestorePanel.this.table.setSelectedFileInfo(SingleFileRestorePanel.this.selectedFileInfo);
                    }
                });
            }
            catch (CancellationException cancellationException) {
                SingleFileRestorePanel.this.infoLabel.setText(Translation.get("wizard.single_file_restore.retrieve_cancelled.text"));
            }
            catch (Exception exception) {
                SingleFileRestorePanel.this.infoLabel.setText(Translation.get("wizard.single_file_restore.retrieve_exception.text", exception.getMessage()));
            }
            SingleFileRestorePanel.this.bar.setVisible(false);
            SingleFileRestorePanel.this.scrollPane.setVisible(true);
        }
    }
}

