/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.widget.LinkLabel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.SwingWorkerPanel;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jwf.WizardPanel;

public class FolderOnlineStoragePanel
extends PFWizardPanel {
    private static final Logger log = Logger.getLogger(FolderOnlineStoragePanel.class.getName());
    private FolderInfo foInfo;
    private boolean removeFolder;
    private JLabel folderLabel;

    public FolderOnlineStoragePanel(Controller controller, FolderInfo folderInfo) {
        super(controller);
        boolean bl;
        Reject.ifNull(folderInfo, "FolderInfo");
        this.foInfo = folderInfo;
        Folder folder = this.getController().getFolderRepository().getFolder(folderInfo);
        this.removeFolder = bl = folder != null && controller.getOSClient().joinedByCloud(folder);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public boolean validateNext() {
        if (this.removeFolder) {
            int n = DialogFactory.genericDialog(this.getController(), Translation.get("exp.wizard.folder_online_storage.warning_title"), Translation.get("exp.wizard.folder_online_storage.warning_message"), new String[]{Translation.get("exp.wizard.folder_online_storage.warning_stop_backing"), Translation.get("general.cancel")}, 0, GenericDialogType.WARN);
            return n == 0;
        }
        return true;
    }

    @Override
    public WizardPanel next() {
        TextPanelPanel textPanelPanel;
        Runnable runnable;
        if (this.removeFolder) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    FolderOnlineStoragePanel.this.getController().getOSClient().getFolderService(FolderOnlineStoragePanel.this.foInfo).removeFolder(FolderOnlineStoragePanel.this.foInfo, true, false);
                }
            };
            textPanelPanel = new TextPanelPanel(this.getController(), Translation.get("exp.wizard.folder_online_storage.remove_success_title"), Translation.get("exp.wizard.folder_online_storage.remove_success_message", this.foInfo.getLocalizedName()), true);
        } else {
            runnable = new Runnable(){

                @Override
                public void run() {
                    FolderOnlineStoragePanel.this.getController().getOSClient().getFolderService().createFolder(FolderOnlineStoragePanel.this.foInfo, null);
                }
            };
            textPanelPanel = new TextPanelPanel(this.getController(), Translation.get("exp.wizard.folder_online_storage.backup_success_title"), Translation.get("exp.wizard.folder_online_storage.backup_success_message", this.foInfo.getLocalizedName()));
        }
        return new SwingWorkerPanel(this.getController(), runnable, Translation.get("exp.wizard.folder_online_storage.working"), Translation.get("exp.wizard.folder_online_storage.working.text"), textPanelPanel);
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("$wlabel, $lcg, $wfield, 0:g", "pref, 6dlu, pref, 6dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        if (this.removeFolder) {
            panelBuilder.addLabel(Translation.get("exp.wizard.webservice.unmirror_folder"), cellConstraints.xyw(1, 1, 4));
        } else {
            panelBuilder.addLabel(Translation.get("exp.wizard.webservice.mirror_folder"), cellConstraints.xyw(1, 1, 4));
        }
        panelBuilder.addLabel(Translation.get("general.folder"), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.folderLabel, cellConstraints.xy(3, 3));
        LinkLabel linkLabel = new LinkLabel(this.getController(), Translation.get("exp.wizard.webservice.learn_more"), ConfigurationEntry.PROVIDER_ABOUT_URL.getValue(this.getController()));
        panelBuilder.add((Component)linkLabel.getUIComponent(), cellConstraints.xyw(1, 5, 3));
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        ServerClient serverClient = this.getController().getOSClient();
        ArrayList<Folder> arrayList = new ArrayList<Folder>(this.getController().getFolderRepository().getFolders());
        arrayList.removeAll(serverClient.getJoinedCloudFolders());
        this.folderLabel = new JLabel(this.foInfo.getName());
        this.updateButtons();
    }

    @Override
    protected String getTitle() {
        if (this.removeFolder) {
            return Translation.get("exp.wizard.webservice.unmirror_setup");
        }
        return Translation.get("exp.wizard.webservice.mirror_setup");
    }
}

