/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.panel.SyncProfileSelectorPanel;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.wizard.FolderAutoConfigPanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jwf.WizardPanel;

public class FolderAutoCreatePanel
extends PFWizardPanel {
    private final FolderInfo folderInfo;
    private JLabel folderNameLabel;
    private SyncProfileSelectorPanel syncProfileSelectorPanel;
    private JCheckBox useCloudCB;
    private JCheckBox inviteCB;
    private ActionLabel undoLabel;

    public FolderAutoCreatePanel(Controller controller, FolderInfo folderInfo) {
        super(controller);
        this.folderInfo = folderInfo;
    }

    @Override
    public boolean hasNext() {
        return this.folderInfo != null;
    }

    @Override
    public WizardPanel next() {
        this.getWizardContext().setAttribute("disklocation.folder_info", this.folderInfo);
        this.getWizardContext().setAttribute("disklocation.sync_profile", this.syncProfileSelectorPanel.getSyncProfile());
        this.getWizardContext().setAttribute("use.cloud.storage", this.useCloudCB.isSelected());
        this.getWizardContext().setAttribute("disklocation.send_invitations", this.inviteCB.isSelected());
        TextPanelPanel textPanelPanel = new TextPanelPanel(this.getController(), Translation.get("wizard.setup_success"), Translation.get("wizard.success_configure"));
        this.getWizardContext().setAttribute("successpanel", textPanelPanel);
        return new FolderAutoConfigPanel(this.getController());
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, pref, pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 15dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addLabel(Translation.get("general.folder"), cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.folderNameLabel, cellConstraints.xy(3, n));
        n += 2;
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.addLabel(Translation.get("general.synchonisation"), cellConstraints.xy(1, n));
            JPanel jPanel = (JPanel)this.syncProfileSelectorPanel.getUIComponent();
            panelBuilder.add((Component)jPanel, cellConstraints.xyw(3, n, 2));
        }
        panelBuilder.add((Component)this.useCloudCB, cellConstraints.xyw(3, n += 2, 2));
        n += 2;
        if (!this.getController().isBackupOnly() && ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)this.inviteCB, cellConstraints.xyw(3, n, 2));
        }
        panelBuilder.add((Component)this.undoLabel.getUIComponent(), cellConstraints.xyw(3, n += 2, 2));
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        this.folderNameLabel = SimpleComponentFactory.createLabel();
        this.folderNameLabel.setText(this.folderInfo.getName());
        this.syncProfileSelectorPanel = new SyncProfileSelectorPanel(this.getController());
        Folder folder = this.getController().getFolderRepository().getFolder(this.folderInfo);
        SyncProfile syncProfile = folder.getSyncProfile();
        this.syncProfileSelectorPanel.setSyncProfile(syncProfile, false);
        this.useCloudCB = new JCheckBox(Translation.get("wizard.folder_auto_create.cloud_space"));
        this.useCloudCB.setOpaque(false);
        this.useCloudCB.setSelected(this.getController().getOSClient().isBackupByDefault());
        this.inviteCB = new JCheckBox(Translation.get("exp.wizard.choose_disk_location.send_invitation"));
        this.inviteCB.setOpaque(false);
        this.undoLabel = new ActionLabel(this.getController(), new MyUndoAction(this.getController()));
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.folder_auto_create.title");
    }

    private void undoAutocreate() {
        int n = DialogFactory.genericDialog(this.getController(), Translation.get("wizard.folder_auto_create.undo.title"), Translation.get("wizard.folder_auto_create.undo.text"), new String[]{Translation.get("wizard.folder_auto_create.undo.button"), Translation.get("general.cancel")}, 0, GenericDialogType.QUESTION);
        if (n == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingWorker swingWorker = new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            JDialog jDialog = (JDialog)FolderAutoCreatePanel.this.getWizardContext().getAttribute("dialog");
                            Cursor cursor = CursorUtils.setWaitCursor(jDialog);
                            Folder folder = FolderAutoCreatePanel.this.getController().getFolderRepository().getFolder(FolderAutoCreatePanel.this.folderInfo);
                            FolderAutoCreatePanel.this.getController().getFolderRepository().removeFolder(folder, false);
                            ServerClient serverClient = FolderAutoCreatePanel.this.getController().getOSClient();
                            if (serverClient.isConnected()) {
                                serverClient.getFolderService(FolderAutoCreatePanel.this.folderInfo).removeFolder(FolderAutoCreatePanel.this.folderInfo, true, true);
                            }
                            CursorUtils.returnToOriginal(jDialog, cursor);
                            jDialog.setVisible(false);
                            return null;
                        }
                    };
                    swingWorker.execute();
                }
            });
        }
    }

    private class MyUndoAction
    extends BaseAction {
        MyUndoAction(Controller controller) {
            super("action_undo_auto_create", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FolderAutoCreatePanel.this.undoAutocreate();
        }
    }
}

