/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Color;
import java.awt.Component;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import jwf.WizardContext;
import jwf.WizardPanel;

public class DefaultFolderWizardHelper
extends PFUIComponent {
    private ServerClient client;
    private ServerClientListener listener;
    private JComponent panel;
    private ValueModel setupDefaultModel;
    private JCheckBox setupDefaultCB;
    private Path defaultSynchronizedFolder;

    DefaultFolderWizardHelper(Controller controller, ServerClient serverClient) {
        super(controller);
        this.client = serverClient;
    }

    protected void initComponents() {
        this.listener = new MyServerClientListener();
        this.setupDefaultModel = new ValueHolder(PreferencesEntry.SETUP_DEFAULT_FOLDER.getValueBoolean(this.getController()), true);
        this.setupDefaultCB = BasicComponentFactory.createCheckBox(this.setupDefaultModel, Translation.get("wizard.login_online_storage.setup_default"));
        this.setupDefaultCB.setOpaque(false);
        this.defaultSynchronizedFolder = this.getController().getFolderRepository().getFoldersBasedir().resolve(Translation.get("exp.wizard.basic_setup.default_folder_name"));
        if (Files.exists(this.defaultSynchronizedFolder, new LinkOption[0])) {
            this.setupDefaultCB.setSelected(false);
        }
        this.client.addListener(this.listener);
    }

    public Component getUIComponent() {
        if (this.panel == null) {
            this.initComponents();
            FormLayout formLayout = new FormLayout("pref, 3dlu, pref", "pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add((Component)this.setupDefaultCB, cellConstraints.xy(1, 1));
            panelBuilder.add((Component)Help.createWikiLinkButton(this.getController(), "Default_Folder"), cellConstraints.xy(3, 1));
            panelBuilder.setOpaque(true);
            panelBuilder.setBackground(Color.white);
            this.panel = panelBuilder.getPanel();
            this.panel.setOpaque(false);
            this.updateVisibility();
        }
        return this.panel;
    }

    WizardPanel next(WizardPanel wizardPanel, WizardContext wizardContext) {
        Reject.ifNull(wizardPanel, "Next panel is null");
        boolean bl = (Boolean)this.setupDefaultModel.getValue();
        PreferencesEntry.SETUP_DEFAULT_FOLDER.setValue(this.getController(), bl);
        this.client.removeListener(this.listener);
        if (bl && this.client.isLoggedIn()) {
            FolderInfo folderInfo;
            Account account = this.client.getAccount();
            FolderInfo folderInfo2 = account.getDefaultSynchronizedFolder();
            this.logInfo("Default synced folder on " + account.getUsername() + " is " + folderInfo2);
            if (folderInfo2 == null) {
                String string = this.defaultSynchronizedFolder.getFileName().toString();
                folderInfo = FolderInfoFactory.newTopFolder(string);
            } else {
                folderInfo = folderInfo2;
            }
            wizardContext.setAttribute("set_default_synced_folder", true);
            wizardContext.setAttribute("disklocation.folder_info", folderInfo);
            wizardContext.setAttribute("disklocation.send_invitations", false);
            wizardContext.setAttribute("successpanel", wizardPanel);
            wizardContext.setAttribute("disklocation.sync_profile", SyncProfile.AUTOMATIC_SYNCHRONIZATION);
            wizardContext.setAttribute("disklocation.localbase", this.defaultSynchronizedFolder);
            wizardContext.setAttribute("folder_create.backup_by_os", folderInfo2 == null);
            return new FolderCreatePanel(this.getController());
        }
        return wizardPanel;
    }

    private void updateVisibility() {
        if (this.panel == null) {
            return;
        }
        this.panel.setVisible(Files.notExists(this.defaultSynchronizedFolder, new LinkOption[0]) && this.client.isLoggedIn());
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            DefaultFolderWizardHelper.this.updateVisibility();
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

