/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.widget;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GradientPanel
extends JPanel {
    public static final Color VERY_VERY_LIGHT_GRAY = new Color(255, 255, 255);
    public static final Color VERY_LIGHT_GRAY = new Color(255, 255, 255);

    private GradientPanel(Color color) {
        this.setBackground(color);
    }

    public static JPanel create(JPanel jPanel) {
        return GradientPanel.create(jPanel, VERY_VERY_LIGHT_GRAY);
    }

    public static JPanel create(JPanel jPanel, Color color) {
        jPanel.setOpaque(false);
        GradientPanel gradientPanel = new GradientPanel(color);
        gradientPanel.setOpaque(false);
        FormLayout formLayout = new FormLayout("fill:pref:grow", "fill:pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, gradientPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.setBorder(null);
        panelBuilder.add((Component)jPanel, cellConstraints.xy(1, 1));
        panelBuilder.getPanel().setOpaque(false);
        return panelBuilder.getPanel();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isOpaque()) {
            return;
        }
        Color color = UIManager.getColor("control");
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(new GradientPaint(n, n2, this.getBackground(), (int)((float)n / 1.7f), 0.0f, color));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setPaint(paint);
    }
}

