/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.widget;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AutoTextField
extends JTextField {
    private final List<String> dataList = new CopyOnWriteArrayList<String>();

    public AutoTextField() {
        this((List<String>)null);
    }

    public AutoTextField(List<String> list) {
        if (list != null) {
            this.dataList.addAll(list);
        }
        this.setDocument(new AutoDocument());
    }

    private String getMatch(String string) {
        for (String string2 : this.dataList) {
            if (string2 == null || !string2.toLowerCase().startsWith(string.toLowerCase())) continue;
            return string2;
        }
        return "";
    }

    public void setDataList(List<String> list) {
        if (list != null) {
            this.dataList.clear();
            this.dataList.addAll(list);
        }
    }

    @Override
    public void replaceSelection(String string) {
        AutoDocument autoDocument = (AutoDocument)this.getDocument();
        try {
            int n = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
            int n2 = Math.max(this.getCaret().getDot(), this.getCaret().getMark());
            autoDocument.replace(n, n2 - n, string, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getText() {
        try {
            String string = this.getDocument().getText(0, this.getDocument().getLength());
            for (String string2 : this.dataList) {
                if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void clear() {
        try {
            this.getDocument().remove(0, this.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private class AutoDocument
    extends PlainDocument {
        private AutoDocument() {
        }

        @Override
        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            super.remove(n, n2);
            this.insertString(n, string, attributeSet);
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            String string2 = this.getText(0, n);
            String string3 = AutoTextField.this.getMatch(string2 + string);
            if (string3.length() == 0) {
                super.insertString(n, string, attributeSet);
                return;
            }
            super.remove(0, this.getLength());
            super.insertString(0, string2, attributeSet);
            super.insertString(n, string, attributeSet);
            super.insertString(n + string.length(), string3.substring(n + string.length(), string3.length()), attributeSet);
            AutoTextField.this.setSelectionStart(n + string.length());
            AutoTextField.this.setSelectionEnd(this.getLength());
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            if (n == 0 && n2 == this.getLength()) {
                super.remove(0, this.getLength());
                return;
            }
            int n3 = AutoTextField.this.getSelectionStart();
            if (n3 > 0) {
                --n3;
            }
            if (n3 == 0) {
                super.remove(0, this.getLength());
                return;
            }
            String string = AutoTextField.this.getMatch(this.getText(0, n3));
            if (string.length() == 0) {
                super.remove(n, n2);
            } else {
                String string2 = this.getText(0, this.getLength());
                super.remove(0, this.getLength());
                super.insertString(0, string2.substring(0, n), null);
                super.insertString(n, string.substring(n, string.length()), null);
            }
            try {
                AutoTextField.this.setSelectionStart(n3);
                AutoTextField.this.setSelectionEnd(this.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

