/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.widget;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ui.UIController;
import de.dal33t.powerfolder.ui.util.SwingWorker;
import de.dal33t.powerfolder.util.ProgressListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.concurrent.Semaphore;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public abstract class ActivityVisualizationWorker
extends SwingWorker {
    private JDialog dialog;
    private JLabel infoText;
    private JProgressBar bar;
    private ProgressListener progressListener;
    private Thread dialogThread;
    private long startTime;
    private boolean stopped = false;
    private Semaphore lock = new Semaphore(1);

    protected ActivityVisualizationWorker(UIController uIController) {
        this(uIController, true);
    }

    protected ActivityVisualizationWorker(UIController uIController, boolean bl) {
        this(uIController.getActiveFrame());
        if (!bl) {
            this.progressListener = new MyProgressListener();
        }
    }

    protected ActivityVisualizationWorker(Window window) {
        this();
        this.dialog = new JDialog(window);
    }

    private ActivityVisualizationWorker() {
        this.dialogThread = new Thread(new DialogRunnable());
    }

    protected abstract String getTitle();

    public void setInfoText(JLabel jLabel) {
        this.infoText = jLabel;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    protected abstract String getWorkingText();

    private void initComponents() {
        if (this.dialog == null) {
            this.dialog = new JDialog();
        }
        this.dialog.setModal(false);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.getTitle());
        this.bar = new JProgressBar();
        this.bar.setIndeterminate(this.progressListener == null);
        this.infoText = new JLabel(this.getWorkingText());
        FormLayout formLayout = new FormLayout("20dlu, max(70dlu;pref):grow, max(70dlu;pref):grow, 20dlu", "pref, 14dlu, pref, 14dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(Borders.DLU14_BORDER);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.infoText, cellConstraints.xywh(1, 1, 4, 1));
        panelBuilder.add((Component)this.bar, cellConstraints.xywh(2, 3, 2, 1));
        this.dialog.getContentPane().add(panelBuilder.getPanel());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.pack();
        Container container = this.dialog.getParent();
        if (container != null) {
            int n = container.getX() + (container.getWidth() - this.dialog.getWidth()) / 2;
            int n2 = container.getY() + (container.getHeight() - this.dialog.getHeight()) / 2;
            this.dialog.setLocation(n, n2);
        }
    }

    private long activityTookedMS() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    protected void beforeConstruct() {
        this.startTime = System.currentTimeMillis();
        this.dialogThread.start();
    }

    @Override
    protected void afterConstruct() {
        this.stopped = true;
        try {
            this.lock.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        this.lock.release();
    }

    private final class MyProgressListener
    implements ProgressListener {
        private MyProgressListener() {
        }

        @Override
        public void progressReached(final double d) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ActivityVisualizationWorker.this.bar == null) {
                        return;
                    }
                    ActivityVisualizationWorker.this.bar.setValue((int)d);
                }
            });
        }
    }

    private class DialogRunnable
    implements Runnable {
        private DialogRunnable() {
        }

        @Override
        public void run() {
            if (ActivityVisualizationWorker.this.stopped) {
                return;
            }
            while (!ActivityVisualizationWorker.this.stopped && ActivityVisualizationWorker.this.activityTookedMS() < 500L) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            if (ActivityVisualizationWorker.this.stopped) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActivityVisualizationWorker.this.lock.tryAcquire();
                    ActivityVisualizationWorker.this.initComponents();
                    ActivityVisualizationWorker.this.lock.release();
                    if (!ActivityVisualizationWorker.this.stopped) {
                        ActivityVisualizationWorker.this.dialog.setVisible(true);
                    }
                }
            });
        }
    }
}

