/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class OverlayedIcon
implements Icon {
    protected static final int[] VALID_X = new int[]{2, 4, 0};
    protected static final int[] VALID_Y = new int[]{1, 3, 0};
    protected Icon mainIcon;
    protected Icon overlayIcon;
    protected int yAlignment = 3;
    protected int xAlignment = 2;

    public OverlayedIcon(Icon icon, Icon icon2, int n, int n2) {
        if (icon2.getIconWidth() > icon.getIconWidth()) {
            throw new IllegalArgumentException("decorator icon is wider than main icon");
        }
        if (icon2.getIconHeight() > icon.getIconHeight()) {
            throw new IllegalArgumentException("decorator icon is higher than main icon");
        }
        if (!this.isLegalValue(n, VALID_X)) {
            throw new IllegalArgumentException("xAlignment must be LEFT, RIGHT or CENTER");
        }
        if (!this.isLegalValue(n2, VALID_Y)) {
            throw new IllegalArgumentException("yAlignment must be TOP, BOTTOM or CENTER");
        }
        this.mainIcon = icon;
        this.overlayIcon = icon2;
        this.xAlignment = n;
        this.yAlignment = n2;
    }

    public boolean isLegalValue(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getIconWidth() {
        return this.mainIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.mainIcon.getIconHeight();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.mainIcon.paintIcon(component, graphics, n, n2);
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        if (this.xAlignment == 0) {
            n += (n3 - this.overlayIcon.getIconWidth()) / 2;
        }
        if (this.xAlignment == 4) {
            n += n3 - this.overlayIcon.getIconWidth();
        }
        if (this.yAlignment == 0) {
            n2 += (n4 - this.overlayIcon.getIconHeight()) / 2;
        }
        if (this.yAlignment == 3) {
            n2 += n4 - this.overlayIcon.getIconHeight();
        }
        this.overlayIcon.paintIcon(component, graphics, n, n2);
    }

    public static Icon overlayWith(Icon icon, Icon icon2) {
        return new OverlayedIcon(icon, icon2, 0, 0);
    }
}

