/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.StyledComboBox;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Waiter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IdPSelectionBox
extends StyledComboBox<String> {
    private static final Logger LOG = Logger.getLogger(IdPSelectionBox.class.getName());
    private final Controller controller;
    private final List<String> idPList;
    private final List<String> samlIdPList;
    private boolean listLoaded;
    private boolean browserLoginOpened;

    public IdPSelectionBox(Controller controller) {
        super(new String[]{Translation.get("general.loading")});
        Reject.ifNull(controller, "Controller");
        this.controller = controller;
        this.idPList = new ArrayList<String>();
        this.samlIdPList = new ArrayList<String>();
        this.listLoaded = false;
        this.setEnabled(false);
        new Initializer().execute();
    }

    public boolean isSAMLIDPSelected() {
        int n = this.getSelectedIndex();
        String string = this.idPList.get(n);
        return string != null && this.samlIdPList.contains(string);
    }

    public boolean isListLoaded() {
        return this.listLoaded;
    }

    public boolean isBrowserLoginOpened() {
        return this.browserLoginOpened;
    }

    private void openSAMLLoginInBrowser(String string, String string2) {
        String string3 = ConfigurationEntry.SERVER_WEB_URL.getValue(this.controller) + "/login/shibboleth/browser";
        string3 = string3 + "?nodeID=" + URLEncoder.encode(this.controller.getMySelf().getId(), Convert.UTF8);
        string3 = string3 + "&nodeNick=" + URLEncoder.encode(this.controller.getMySelf().getNick(), Convert.UTF8);
        string3 = string3 + "&nodeConsumeTokenURL=" + URLEncoder.encode(string2, Convert.UTF8);
        String string4 = ConfigurationEntry.SERVER_WEB_URL.getValue(this.controller) + "/Shibboleth.sso/Login";
        string4 = string4 + "?SAMLDS=1&";
        string4 = string4 + "entityID=" + URLEncoder.encode(string, Convert.UTF8);
        string4 = string4 + "&target=" + URLEncoder.encode(string3, Convert.UTF8);
        try {
            BrowserLauncher.openURL(string4);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        DialogFactory.genericDialog(this.controller, Translation.get("login.saml.browser_login_ongoing.title"), Translation.get("login.saml.browser_login_ongoing.message"), new String[]{Translation.get("general.ok")}, 0, GenericDialogType.INFO);
    }

    private void retrieveECP(String string) {
        String string2 = ConfigurationEntry.SERVER_WEB_URL.getValue(this.controller) + "/api/idpd?entityID=" + URLEncoder.encode(string, Convert.UTF8);
        HttpGet httpGet = new HttpGet(string2);
        HttpClientBuilder httpClientBuilder = Util.createHttpClientBuilder(this.controller);
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        try {
            HttpResponse httpResponse = closeableHttpClient.execute(httpGet);
            String string3 = EntityUtils.toString(httpResponse.getEntity());
            ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.setValue(this.controller, string3);
            LOG.info(string + ": ECP URL is " + string3);
        }
        catch (IOException iOException) {
            LOG.warning(iOException.toString());
        }
        this.controller.saveConfig();
    }

    private class Initializer
    extends SwingWorker<Void, Void> {
        private Initializer() {
        }

        private JSONArray retrieve0() throws IOException, JSONException {
            URL uRL = new URL(ConfigurationEntry.SERVER_IDP_DISCO_FEED_URL.getValue(IdPSelectionBox.this.controller));
            HttpURLConnection httpURLConnection = uRL.toString().startsWith("https") ? (HttpsURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), Convert.UTF8));
            String string = bufferedReader.readLine();
            StringBuilder stringBuilder = new StringBuilder();
            while (string != null) {
                stringBuilder.append(string);
                string = bufferedReader.readLine();
            }
            return new JSONArray(stringBuilder.toString());
        }

        private JSONArray retrieve() {
            Exception exception = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    return this.retrieve0();
                }
                catch (Exception exception2) {
                    exception = exception2;
                    Waiter.waitRandom(500L);
                    continue;
                }
            }
            throw new RuntimeException(exception);
        }

        public void addEntry(String string) {
            SwingUtilities.invokeLater(() -> IdPSelectionBox.this.addItem(string));
        }

        public void setSelectedIndex(int n) {
            SwingUtilities.invokeLater(() -> this.setSelectedIndex(n));
        }

        @Override
        protected Void doInBackground() throws Exception {
            String string = ConfigurationEntry.SERVER_IDP_LAST_CONNECTED.getValue(IdPSelectionBox.this.controller);
            boolean bl = false;
            JSONArray jSONArray = this.retrieve();
            IdPSelectionBox.this.removeAllItems();
            this.addEntry(Translation.get("wizard.login_online_storage.pre_selection_entry"));
            IdPSelectionBox.this.idPList.add(0, "");
            if (ConfigurationEntry.SERVER_IDP_EXTERNAL_NAMES.hasNonBlankValue(IdPSelectionBox.this.controller)) {
                String[] stringArray = ConfigurationEntry.SERVER_IDP_EXTERNAL_NAMES.getValue(IdPSelectionBox.this.controller).split(",");
                for (String string2 : stringArray) {
                    if (!StringUtils.isNotBlank(string2)) continue;
                    if (string2.startsWith("!")) {
                        string2 = string2.substring(1);
                    }
                    this.addEntry(string2.trim());
                    IdPSelectionBox.this.idPList.add(string2.trim());
                    if (bl || !string2.equals(string)) continue;
                    this.setSelectedIndex(IdPSelectionBox.this.getItemCount() - 1);
                    bl = true;
                }
            } else {
                this.addEntry(Translation.get("wizard.login.external_users"));
                IdPSelectionBox.this.idPList.add("ext");
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                String string3 = jSONObject.getString("entityID");
                String string4 = jSONObject.getJSONArray("DisplayNames").getJSONObject(0).getString("value");
                this.addEntry(string4);
                IdPSelectionBox.this.idPList.add(string3);
                IdPSelectionBox.this.samlIdPList.add(string3);
                if (bl || !string3.equals(string)) continue;
                this.setSelectedIndex(IdPSelectionBox.this.getItemCount() - 1);
                bl = true;
            }
            if (!bl) {
                this.setSelectedIndex(0);
                ConfigurationEntry.SERVER_IDP_LAST_CONNECTED.setValue(IdPSelectionBox.this.controller, "ext");
                ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.setValue(IdPSelectionBox.this.controller, "ext");
            }
            IdPSelectionBox.this.addActionListener(new IdPSelectionAction());
            IdPSelectionBox.this.listLoaded = true;
            return null;
        }

        @Override
        protected void done() {
            if (IdPSelectionBox.this.listLoaded) {
                IdPSelectionBox.this.setEnabled(true);
            }
        }
    }

    private class IdPSelectionAction
    implements ActionListener {
        private IdPSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IdPSelectionWorker idPSelectionWorker = new IdPSelectionWorker();
            idPSelectionWorker.execute();
        }

        private class IdPSelectionWorker
        extends SwingWorker<Void, Void> {
            private IdPSelectionWorker() {
            }

            @Override
            protected Void doInBackground() {
                int n = IdPSelectionBox.this.getSelectedIndex();
                String string = (String)IdPSelectionBox.this.idPList.get(n);
                ConfigurationEntry.SERVER_IDP_LAST_CONNECTED.setValue(IdPSelectionBox.this.controller, string);
                String string2 = ConfigurationEntry.SERVER_IDP_EXTERNAL_NAMES.getValue(IdPSelectionBox.this.controller);
                if (StringUtils.isBlank(string)) {
                    return null;
                }
                if ("ext".equals(string) || StringUtils.isNotBlank(string2) && string2.contains(string)) {
                    ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.setValue(IdPSelectionBox.this.controller, "ext");
                    return null;
                }
                int n2 = IdPSelectionBox.this.controller.getRconManager().getPort();
                if (n2 > 0) {
                    IdPSelectionBox.this.browserLoginOpened = true;
                    String string3 = "http://localhost:" + n2 + "/login";
                    IdPSelectionBox.this.openSAMLLoginInBrowser(string, string3);
                } else {
                    IdPSelectionBox.this.retrieveECP(string);
                    DialogFactory.genericDialog(IdPSelectionBox.this.controller, Translation.get("login.saml.browser_init_problem.title"), Translation.get("login.saml.browser_init_problem.message"), GenericDialogType.WARN);
                    LOG.warning("Unable to provide browser based SAML login. Trying to login via ECP.");
                }
                return null;
            }
        }
    }
}

