/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.render;

import com.jgoodies.forms.factories.Borders;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.Transfer;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.EstimatedTime;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.TransferCounter;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DownloadManagerTableCellRenderer
extends DefaultTableCellRenderer {
    private Controller controller;
    private JProgressBar bar;

    public DownloadManagerTableCellRenderer(Controller controller) {
        this.controller = controller;
        this.bar = new JProgressBar();
        this.bar.setBorderPainted(false);
        this.bar.setBorder(Borders.EMPTY_BORDER);
        this.bar.setStringPainted(true);
        UIUtil.addUIChangeTask(new Runnable(){

            @Override
            public void run() {
                DownloadManagerTableCellRenderer.this.bar.updateUI();
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof DownloadManager) {
            DownloadManager downloadManager = (DownloadManager)object;
            TransferCounter transferCounter = downloadManager.getCounter();
            this.bar.setValue((int)(Math.max(0.0, downloadManager.getState().getProgress()) * 100.0));
            Transfer.State state = downloadManager.getState();
            if (state == null) {
                state = new Transfer.State();
                state.setState(Transfer.TransferState.NONE);
            }
            switch (state.getState()) {
                case VERIFYING: {
                    this.bar.setString(Translation.get(state.getState().getTranslationId()));
                    this.bar.setValue(100);
                    break;
                }
                case MATCHING: 
                case FILERECORD_REQUEST: 
                case COPYING: {
                    this.bar.setString(Translation.get(state.getState().getTranslationId()));
                    break;
                }
                case DOWNLOADING: {
                    EstimatedTime estimatedTime = new EstimatedTime(downloadManager.getCounter().calculateEstimatedMillisToCompletion(), downloadManager.isCompleted() && downloadManager.isStarted());
                    String string = Translation.get("transfers.kbs", Format.formatDecimal(transferCounter.calculateCurrentKBS()));
                    String string2 = (String)(estimatedTime.isActive() ? estimatedTime.toString() + " - " : "") + string;
                    this.bar.setString(string2);
                    break;
                }
                default: {
                    if (downloadManager.isCompleted()) {
                        Date date = downloadManager.getCompletedDate();
                        String string = date != null ? Format.formatDateShort(date, true) : "";
                        this.bar.setValue(100);
                        this.bar.setString(Translation.get("transfers.completed", string));
                        break;
                    }
                    if (downloadManager.isStarted()) {
                        this.bar.setString(Translation.get("transfers.started"));
                        break;
                    }
                    this.bar.setString(Translation.get("transfers.requested"));
                }
            }
            return this.bar;
        }
        if (object instanceof FileInfo) {
            if (n2 == 0) {
                FileInfo fileInfo = (FileInfo)object;
                this.setIcon(Icons.getEnabledIconFor(fileInfo, this.controller));
                this.setText("");
            } else {
                FileInfo fileInfo = (FileInfo)object;
                this.setText(fileInfo.getFilenameOnly());
                this.setIcon(null);
                this.setHorizontalAlignment(2);
            }
        } else if (object instanceof Long) {
            Long l = (Long)object;
            this.setText(Format.formatBytesShort(l));
            this.setIcon(null);
            this.setHorizontalAlignment(4);
        } else if (object instanceof FolderInfo) {
            FolderInfo folderInfo = (FolderInfo)object;
            this.setText(folderInfo.getLocalizedName());
            this.setHorizontalAlignment(2);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                this.setText("");
                this.setIcon(null);
            } else {
                Download download = (Download)collection.iterator().next();
                if (collection.size() == 1) {
                    String string = download.getPartner().getNick();
                    this.setText(string);
                } else {
                    this.setText(Translation.get("transfers.swarm", String.valueOf(collection.size())));
                }
                this.setHorizontalAlignment(2);
            }
        } else if (object instanceof EstimatedTime) {
            EstimatedTime estimatedTime = (EstimatedTime)object;
            if (estimatedTime.isActive()) {
                this.setText(Format.formatDeltaTime(estimatedTime.getDeltaTimeMillis()));
            } else {
                this.setText("");
            }
            this.setIcon(null);
            this.setHorizontalAlignment(0);
        } else {
            this.setText(Translation.get("transfers.searching"));
            this.setIcon(null);
            this.setHorizontalAlignment(2);
        }
        if (!bl) {
            this.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
        }
        return component;
    }
}

