/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.ui.preferences.PreferenceTab;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.util.SwingWorker;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.Security;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DynDnsSettingsTab
extends PFComponent
implements PreferenceTab {
    static final int DISP_INFO = 0;
    static final int DISP_WARNING = 1;
    static final int DISP_ERROR = 2;
    private static String password;
    private static String username;
    private static String newDyndns;
    private static String dyndnsSystem;
    private JTextField myDnsField;
    private JLabel myDnsLabel;
    private JPanel panel;
    private JTextField dyndnsUserField;
    private JPasswordField dyndnsPasswordField;
    private JLabel currentIPField;
    private JLabel updatedIPField;
    private JCheckBox cbAutoUpdate;
    private ValueModel mydnsndsModel;
    private JButton updateButton;

    public DynDnsSettingsTab(Controller controller, ValueModel valueModel) {
        super(controller);
        this.mydnsndsModel = valueModel;
        this.initComponents();
    }

    @Override
    public String getTabName() {
        return Translation.get("exp.preferences.dyn_dns.title");
    }

    @Override
    public boolean needsRestart() {
        return false;
    }

    @Override
    public void undoChanges() {
    }

    @Override
    public boolean validate() {
        if (this.mydnsndsModel.getValue() == null || ((String)this.mydnsndsModel.getValue()).trim().length() == 0) {
            return true;
        }
        return this.getController().getDynDnsManager().validateDynDns(this.mydnsndsModel.getValue().toString());
    }

    @Override
    public void save() {
        String string = (String)this.mydnsndsModel.getValue();
        if (StringUtils.isBlank(string)) {
            ConfigurationEntry.HOSTNAME.removeValue(this.getController());
        } else {
            ConfigurationEntry.HOSTNAME.setValue(this.getController(), string);
        }
        if (!StringUtils.isBlank(string)) {
            if (StringUtils.isBlank(this.dyndnsUserField.getText())) {
                ConfigurationEntry.DYNDNS_USERNAME.removeValue(this.getController());
            } else {
                ConfigurationEntry.DYNDNS_USERNAME.setValue(this.getController(), this.dyndnsUserField.getText());
            }
            String string2 = new String(this.dyndnsPasswordField.getPassword());
            if (StringUtils.isBlank(string2)) {
                ConfigurationEntry.DYNDNS_PASSWORD.removeValue(this.getController());
            } else {
                ConfigurationEntry.DYNDNS_PASSWORD.setValue(this.getController(), string2);
            }
        }
        boolean bl = this.cbAutoUpdate.isSelected();
        ConfigurationEntry.DYNDNS_AUTO_UPDATE.setValue(this.getController(), Boolean.valueOf(bl).toString());
        this.getController().getDynDnsManager().updateIfNessesary();
    }

    @Override
    public JPanel getUIPanel() {
        if (this.panel == null) {
            FormLayout formLayout = new FormLayout("right:pref, 3dlu, 140dlu, pref", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(Borders.createEmptyBorder("3dlu, 3dlu, 3dlu, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            panelBuilder.add((Component)this.myDnsLabel, cellConstraints.xy(1, n));
            panelBuilder.add((Component)this.myDnsField, cellConstraints.xy(3, n));
            panelBuilder.add((Component)this.cbAutoUpdate, cellConstraints.xy(3, n += 2));
            panelBuilder.addTitle(Translation.get("exp.preferences.dyn_dns.login_panel"), cellConstraints.xy(1, n += 2));
            panelBuilder.addLabel(Translation.get("exp.preferences.dyn_dns.user_name"), cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.dyndnsUserField, cellConstraints.xy(3, n));
            this.dyndnsPasswordField.setEchoChar('*');
            panelBuilder.addLabel(Translation.get("exp.preferences.dyn_dns.password"), cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.dyndnsPasswordField, cellConstraints.xy(3, n));
            panelBuilder.addLabel(Translation.get("exp.preferences.dyn_dns.current_ip"), cellConstraints.xy(1, n += 4));
            panelBuilder.add((Component)this.currentIPField, cellConstraints.xy(3, n));
            panelBuilder.addLabel(Translation.get("exp.preferences.dyn_dns.updated_ip"), cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.updatedIPField, cellConstraints.xy(3, n));
            panelBuilder.add((Component)this.updateButton, cellConstraints.xy(3, n += 2));
            this.panel = panelBuilder.getPanel();
        }
        return this.panel;
    }

    private void initComponents() {
        this.myDnsField = BasicComponentFactory.createTextField(this.mydnsndsModel, false);
        this.myDnsField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DynDnsSettingsTab.this.updateDynDnsInfo();
            }
        });
        this.myDnsLabel = new JLabel(Translation.get("exp.preferences.dyn_dns_host_name"));
        this.dyndnsUserField = ConfigurationEntry.DYNDNS_USERNAME.getValue(this.getController()) == null ? new JTextField("") : new JTextField(ConfigurationEntry.DYNDNS_USERNAME.getValue(this.getController()));
        this.dyndnsPasswordField = ConfigurationEntry.DYNDNS_PASSWORD.getValue(this.getController()) == null ? new JPasswordField("") : new JPasswordField(ConfigurationEntry.DYNDNS_PASSWORD.getValue(this.getController()));
        this.currentIPField = new JLabel();
        this.updatedIPField = new JLabel();
        this.cbAutoUpdate = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.dyn_dns.auto_update"));
        this.cbAutoUpdate.setSelected(this.isUpdateSelected());
        this.updateButton = this.createUpdateButton(new UpdateDynDnsAction());
        this.mydnsndsModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DynDnsSettingsTab.this.enableDisableComponents();
            }
        });
        this.cbAutoUpdate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DynDnsSettingsTab.this.enableDisableComponents();
            }
        });
        this.enableDisableComponents();
    }

    protected void updateDynDnsInfo() {
        this.logFine("Gathering dyndns infos. Cache: " + Security.getProperty("networkaddress.cache.ttl"));
        SwingWorker swingWorker = new SwingWorker(){
            private String ownIP;
            private String dyndnsIP;

            @Override
            public Object construct() {
                this.ownIP = DynDnsSettingsTab.this.getController().getDynDnsManager().getIPviaHTTPCheckIP();
                this.dyndnsIP = DynDnsSettingsTab.this.getController().getDynDnsManager().getHostIP((String)DynDnsSettingsTab.this.mydnsndsModel.getValue());
                return null;
            }

            @Override
            public void finished() {
                DynDnsSettingsTab.this.currentIPField.setText(this.ownIP);
                DynDnsSettingsTab.this.updatedIPField.setText(this.dyndnsIP);
            }
        };
        swingWorker.start();
    }

    private boolean isUpdateSelected() {
        return ConfigurationEntry.DYNDNS_AUTO_UPDATE.getValueBoolean(this.getController());
    }

    private JButton createUpdateButton(ActionListener actionListener) {
        this.updateButton = new JButton(Translation.get("exp.preferences.dyn_dns.update_button"));
        this.updateButton.addActionListener(actionListener);
        return this.updateButton;
    }

    private void enableDisableComponents() {
        boolean bl = !StringUtils.isBlank((String)this.mydnsndsModel.getValue()) && this.cbAutoUpdate.isSelected();
        this.updateButton.setEnabled(bl);
        this.dyndnsUserField.setEditable(bl);
        this.dyndnsPasswordField.setEditable(bl);
    }

    public static String getPassword() {
        return password;
    }

    public static void setPassword(String string) {
        password = string;
    }

    public static String getUsername() {
        return username;
    }

    public static void setUsername(String string) {
        username = string;
    }

    public static String getNewDyndns() {
        return newDyndns;
    }

    public static void setNewDyndns(String string) {
        newDyndns = string;
    }

    public static String getDyndnsSystem() {
        return dyndnsSystem;
    }

    public static void setDyndnsSystem(String string) {
        dyndnsSystem = string;
    }

    private class UpdateDynDnsAction
    implements ActionListener {
        private UpdateDynDnsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(){

                @Override
                public void run() {
                    DynDnsSettingsTab.this.updateButton.setEnabled(false);
                    DynDnsSettingsTab.setUsername(DynDnsSettingsTab.this.dyndnsUserField.getText());
                    DynDnsSettingsTab.setPassword(new String(DynDnsSettingsTab.this.dyndnsPasswordField.getPassword()));
                    DynDnsSettingsTab.setNewDyndns((String)DynDnsSettingsTab.this.mydnsndsModel.getValue());
                    if (DynDnsSettingsTab.this.dyndnsUserField.getText().length() == 0) {
                        DynDnsSettingsTab.this.dyndnsUserField.grabFocus();
                    } else if (new String(DynDnsSettingsTab.this.dyndnsPasswordField.getPassword()).length() == 0) {
                        DynDnsSettingsTab.this.dyndnsPasswordField.grabFocus();
                    }
                    if (!StringUtils.isEmpty(DynDnsSettingsTab.getNewDyndns()) && DynDnsSettingsTab.this.dyndnsUserField.getText().length() != 0 && new String(DynDnsSettingsTab.this.dyndnsPasswordField.getPassword()).length() != 0) {
                        DynDnsSettingsTab.this.getController().getDynDnsManager().forceUpdate();
                        DynDnsSettingsTab.this.updatedIPField.setText(ConfigurationEntry.DYNDNS_LAST_UPDATED_IP.getValue(DynDnsSettingsTab.this.getController()));
                    } else {
                        DynDnsSettingsTab.this.updateButton.setEnabled(false);
                        DynDnsSettingsTab.this.getController().getDynDnsManager().showPanelErrorMessage();
                    }
                    DynDnsSettingsTab.this.updateButton.setEnabled(true);
                }
            }.start();
        }
    }
}

