/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.skin.Skin;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.preferences.PreferenceTab;
import de.dal33t.powerfolder.ui.preferences.ServerSelectorPanel;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AdvancedSettingsTab
extends PFUIComponent
implements PreferenceTab {
    private JPanel panel;
    private ServerSelectorPanel severSelector;
    private JCheckBox useOnlineStorageCB;
    private JCheckBox lockUICB;
    private JCheckBox underlineLinkCB;
    private JCheckBox autoExpandCB;
    private JCheckBox showHiddenFilesCB;
    private JLabel skinLabel;
    private JComboBox<String> skinCombo;
    private boolean needsRestart;

    public AdvancedSettingsTab(Controller controller) {
        super(controller);
        this.initComponents();
    }

    @Override
    public String getTabName() {
        return Translation.get("exp.preferences.advanced.title");
    }

    @Override
    public boolean needsRestart() {
        return this.needsRestart;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void undoChanges() {
    }

    private void initComponents() {
        Serializable serializable;
        this.severSelector = new ServerSelectorPanel(this.getController());
        this.useOnlineStorageCB = new JCheckBox(Translation.get("exp.preferences.advanced.online_storage_text"));
        this.useOnlineStorageCB.setToolTipText(Translation.get("exp.preferences.advanced.online_storage_tip"));
        this.useOnlineStorageCB.setSelected(PreferencesEntry.USE_ONLINE_STORAGE.getValueBoolean(this.getController()));
        this.lockUICB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.advanced.ui_locked"));
        this.lockUICB.setSelected(ConfigurationEntry.USER_INTERFACE_LOCKED.getValueBoolean(this.getController()));
        this.underlineLinkCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.advanced.underline_link"));
        this.underlineLinkCB.setVisible(false);
        this.underlineLinkCB.setSelected(PreferencesEntry.UNDERLINE_LINKS.getValueBoolean(this.getController()));
        this.autoExpandCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.advanced.auto_expand"));
        this.autoExpandCB.setVisible(false);
        this.autoExpandCB.setSelected(PreferencesEntry.AUTO_EXPAND.getValueBoolean(this.getController()));
        this.showHiddenFilesCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.warnings_notifications.show_hidden_files"));
        this.showHiddenFilesCB.setSelected(PreferencesEntry.SHOW_HIDDEN_FILES.getValueBoolean(this.getController()));
        if (OSUtil.isWindowsSystem() && WinUtils.getInstance() != null) {
            serializable = new ValueHolder(WinUtils.getInstance().hasPFStartup(this.getController()));
            serializable.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    try {
                        if (WinUtils.getInstance() != null) {
                            WinUtils.getInstance().setPFStartup(propertyChangeEvent.getNewValue().equals(true), AdvancedSettingsTab.this.getController());
                        }
                    }
                    catch (IOException iOException) {
                        AdvancedSettingsTab.this.logSevere("IOException", iOException);
                    }
                }
            });
        }
        if (this.getUIController().getSkins().length > 1) {
            this.skinLabel = new JLabel(Translation.get("exp.preferences.advanced.skin_text"));
            serializable = new DefaultComboBoxModel();
            String string = PreferencesEntry.SKIN_NAME.getValueString(this.getController());
            int n = -1;
            int n2 = 0;
            for (Skin skin : this.getUIController().getSkins()) {
                ((DefaultComboBoxModel)serializable).addElement(skin.getName());
                if (skin.getName().equals(string)) {
                    n = n2;
                }
                ++n2;
            }
            this.skinCombo = new JComboBox(serializable);
            if (n > -1) {
                this.skinCombo.setSelectedIndex(n);
            }
            this.skinLabel.setVisible(this.getController().getDistribution().allowSkinChange());
            this.skinCombo.setVisible(this.getController().getDistribution().allowSkinChange());
        }
    }

    @Override
    public JPanel getUIPanel() {
        if (this.panel == null) {
            FormLayout formLayout = new FormLayout("right:pref, 3dlu, 140dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(Borders.createEmptyBorder("3dlu, 3dlu, 3dlu, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            panelBuilder.addLabel(Translation.get("exp.preferences.advanced.server"), cellConstraints.xy(1, n));
            panelBuilder.add(this.severSelector.getUIComponent(), cellConstraints.xy(3, n));
            if (!this.getController().isBackupOnly()) {
                panelBuilder.add((Component)this.useOnlineStorageCB, cellConstraints.xy(3, n += 2));
            }
            panelBuilder.add((Component)this.showHiddenFilesCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.add((Component)this.lockUICB, cellConstraints.xyw(3, n += 2, 2));
            if (this.skinLabel != null && this.skinCombo != null) {
                panelBuilder.add((Component)this.skinLabel, cellConstraints.xy(1, n += 2));
                panelBuilder.add(this.skinCombo, cellConstraints.xy(3, n));
            }
            panelBuilder.add((Component)this.underlineLinkCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.add((Component)this.autoExpandCB, cellConstraints.xyw(3, n += 2, 2));
            this.panel = panelBuilder.getPanel();
        }
        return this.panel;
    }

    @Override
    public void save() {
        PreferencesEntry.USE_ONLINE_STORAGE.setValue(this.getController(), this.useOnlineStorageCB.isSelected());
        PreferencesEntry.UNDERLINE_LINKS.setValue(this.getController(), this.underlineLinkCB.isSelected());
        PreferencesEntry.AUTO_EXPAND.setValue(this.getController(), this.autoExpandCB.isSelected());
        PreferencesEntry.SHOW_HIDDEN_FILES.setValue(this.getController(), this.showHiddenFilesCB.isSelected());
        ConfigurationEntry.USER_INTERFACE_LOCKED.setValue(this.getController(), String.valueOf(this.lockUICB.isSelected()));
        if (this.skinCombo != null) {
            String string = PreferencesEntry.SKIN_NAME.getValueString(this.getController());
            if (!this.skinCombo.getSelectedItem().equals(string)) {
                PreferencesEntry.SKIN_NAME.setValue(this.getController(), (String)this.skinCombo.getSelectedItem());
                this.needsRestart = true;
            }
        }
        this.getController().saveConfig();
    }
}

