/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.panel;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.security.ChangeTransferModePermission;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.dialog.CreateEditSyncProfileDialog;
import de.dal33t.powerfolder.ui.dialog.DeleteSyncProfileDialog;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.model.BoundPermission;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class SyncProfileSelectorPanel
extends PFUIComponent {
    private JComboBox<String> syncProfilesCombo;
    private JPanel panel;
    private ValueModel valueModel;
    private Folder updateableFolder;
    private boolean ignoreChanges;
    private JButtonMini configureButton;
    private JButtonMini deleteButton;
    private BoundPermission changeModePermission;

    public SyncProfileSelectorPanel(Controller controller, SyncProfile syncProfile) {
        super(controller);
        this.initComponents(syncProfile);
    }

    public SyncProfileSelectorPanel(Controller controller) {
        this(controller, SyncProfile.getDefault(controller));
    }

    public Component getUIComponent() {
        if (this.panel == null) {
            this.buildPanel();
            this.changeModePermission = new BoundPermission(this.getController(), ChangeTransferModePermission.INSTANCE){

                @Override
                public void hasPermission(boolean bl) {
                    SyncProfileSelectorPanel.this.setEnabled(bl);
                }
            };
        }
        return this.panel;
    }

    public void setUpdateableFolder(Folder folder) {
        this.updateableFolder = folder;
        this.configureCombo(folder.getSyncProfile());
    }

    private void initComponents(SyncProfile syncProfile) {
        this.syncProfilesCombo = new JComboBox();
        this.syncProfilesCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SyncProfileSelectorPanel.this.udateSyncProfile();
            }
        });
        this.valueModel = new ValueHolder();
        this.valueModel.setValue(syncProfile);
        this.configureButton = new JButtonMini(new MyConfigureAction(this.getController()));
        this.deleteButton = new JButtonMini(new MyDeleteAction(this.getController()));
        this.configureCombo(syncProfile);
        this.addModelValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!SyncProfileSelectorPanel.this.isOkToSwitchToProfile((SyncProfile)propertyChangeEvent.getNewValue())) {
                    SyncProfileSelectorPanel.this.setSyncProfile((SyncProfile)propertyChangeEvent.getOldValue(), false);
                }
            }
        });
        this.enableButtons();
    }

    private void udateSyncProfile() {
        int n;
        if (!this.ignoreChanges && (n = this.syncProfilesCombo.getSelectedIndex()) >= 0) {
            SyncProfile syncProfile = SyncProfile.getSyncProfilesCopy().get(n);
            this.valueModel.setValue(syncProfile);
            if (this.updateableFolder != null) {
                this.updateableFolder.setSyncProfile(syncProfile);
            }
            this.enableButtons();
        }
    }

    private void enableButtons() {
        SyncProfile syncProfile;
        int n = this.syncProfilesCombo.getSelectedIndex();
        if (n >= 0) {
            syncProfile = SyncProfile.getSyncProfilesCopy().get(n);
            this.valueModel.setValue(syncProfile);
            if (this.updateableFolder != null) {
                this.updateableFolder.setSyncProfile(syncProfile);
            }
        }
        this.deleteButton.setEnabled((syncProfile = (SyncProfile)this.valueModel.getValue()) != null && syncProfile.isCustom());
        this.configureButton.setEnabled(syncProfile != null);
    }

    public void configureCombo(SyncProfile syncProfile) {
        this.ignoreChanges = true;
        this.syncProfilesCombo.removeAllItems();
        for (SyncProfile syncProfile2 : SyncProfile.getSyncProfilesCopy()) {
            this.syncProfilesCombo.addItem(syncProfile2.getName());
            if (!syncProfile.equals(syncProfile2)) continue;
            this.syncProfilesCombo.setSelectedItem(syncProfile2.getName());
        }
        this.enableButtons();
        this.ignoreChanges = false;
    }

    private void buildPanel() {
        int n = this.configureButton.getIcon().getIconHeight();
        FormLayout formLayout = new FormLayout("140dlu, 3dlu, pref, pref, pref, pref:grow", "max(pref;" + n + ")");
        this.panel = new JPanel(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.panel.add(this.syncProfilesCombo, cellConstraints.xy(1, 1));
        this.panel.add((Component)this.configureButton, cellConstraints.xy(3, 1));
        this.panel.add((Component)this.deleteButton, cellConstraints.xy(4, 1));
        this.panel.add((Component)Help.createWikiLinkButton(this.getController(), "Transfer_Modes"), cellConstraints.xy(5, 1));
    }

    public boolean isOkToSwitchToProfile(SyncProfile syncProfile) {
        return true;
    }

    public void setSyncProfile(SyncProfile syncProfile, boolean bl) {
        this.valueModel.setValue(syncProfile);
        if (bl && this.updateableFolder != null) {
            this.updateableFolder.setSyncProfile(syncProfile);
            for (Folder folder : this.getController().getFolderRepository().getFolders()) {
                if (!folder.getSyncProfile().equals(syncProfile) || this.updateableFolder.equals(folder)) continue;
                folder.setSyncProfile(syncProfile);
            }
        }
        this.configureCombo(syncProfile);
    }

    public SyncProfile getSyncProfile() {
        return (SyncProfile)this.valueModel.getValue();
    }

    public void addModelValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.valueModel.addValueChangeListener(propertyChangeListener);
    }

    public void setEnabled(boolean bl) {
        this.enableButtons();
        this.syncProfilesCombo.setEnabled(bl);
        this.configureButton.setVisible(bl);
        this.deleteButton.setVisible(bl);
    }

    private void openCustomSyncProfileDialog(boolean bl) {
        Object object;
        int n = 0;
        if (!bl && (object = this.usedFolders()).size() >= 2) {
            n = this.showDuplicates((List<Folder>)object, "dialog.synchronization.duplicate.edit");
        }
        if (n == 0) {
            object = new CreateEditSyncProfileDialog(this.getController(), this, bl);
            ((BaseDialog)object).open();
        }
    }

    public void deleteProfile() {
        List<Folder> list = this.usedFolders();
        int n = 0;
        if (list.size() >= 2) {
            n = this.showDuplicates(list, "dialog.synchronization.duplicate.delete");
        }
        if (n == 0) {
            DeleteSyncProfileDialog deleteSyncProfileDialog = new DeleteSyncProfileDialog(this.getController(), this);
            deleteSyncProfileDialog.open();
        }
    }

    private int showDuplicates(List<Folder> list, String string) {
        String string2 = Translation.get("dialog.synchronization.duplicate.title");
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Folder folder : list) {
            stringBuilder.append("    ");
            if (n++ >= 10) {
                stringBuilder.append(Translation.get("general.more.lower_case") + "...\n");
                break;
            }
            stringBuilder.append(folder.getName() + "\n");
        }
        String string3 = Translation.get("dialog.synchronization.duplicate.use") + "\n\n" + stringBuilder.toString() + "\n" + Translation.get(string);
        return DialogFactory.genericDialog(this.getController(), string2, string3, new String[]{"OK", "Cancel"}, 0, GenericDialogType.WARN);
    }

    private List<Folder> usedFolders() {
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        SyncProfile syncProfile = this.getSyncProfile();
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            if (!folder.getSyncProfile().equals(syncProfile)) continue;
            arrayList.add(folder);
        }
        return arrayList;
    }

    private class MyConfigureAction
    extends BaseAction {
        private MyConfigureAction(Controller controller) {
            super("exp.action_configure_transfer_mode", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyncProfile syncProfile = SyncProfileSelectorPanel.this.getSyncProfile();
            if (syncProfile != null) {
                SyncProfileSelectorPanel.this.openCustomSyncProfileDialog(!syncProfile.isCustom());
            }
        }
    }

    private class MyDeleteAction
    extends BaseAction {
        private MyDeleteAction(Controller controller) {
            super("exp.action_delete_transfer_mode", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyncProfile syncProfile = SyncProfileSelectorPanel.this.getSyncProfile();
            if (syncProfile != null) {
                SyncProfileSelectorPanel.this.deleteProfile();
            }
        }
    }
}

