/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.notification;

import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.ui.util.UIUtil;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.Timer;

public class Slider {
    public static final int ANIMATION_DELAY = 5;
    private int displaySeconds;
    private Window owner;
    private JWindow window;
    private JComponent contents;
    private Timer animateUpTimer;
    private Timer dismissTimer;
    private Timer animateDownTimer;
    private int translucencyPercentage;
    private boolean displayLeft;

    public Slider(JComponent jComponent, int n, int n2, boolean bl) {
        this(jComponent, null, n, n2, bl);
    }

    public Slider(JComponent jComponent, Window window, int n, int n2, boolean bl) {
        this.contents = jComponent;
        this.displaySeconds = n;
        this.translucencyPercentage = n2;
        this.displayLeft = bl;
        this.owner = window;
    }

    public JComponent getContents() {
        return this.contents;
    }

    private static Rectangle initDesktopBounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    }

    public void show() {
        if (this.window != null) {
            return;
        }
        this.window = new JWindow(this.owner);
        this.window.setAlwaysOnTop(true);
        if (Constants.OPACITY_SUPPORTED) {
            UIUtil.applyTranslucency(this.window, Float.valueOf(0.0f));
        }
        Dimension dimension = this.contents.getPreferredSize();
        Rectangle rectangle = Slider.initDesktopBounds();
        int n = this.displayLeft ? 10 : rectangle.width - dimension.width - 10;
        int n2 = rectangle.y + rectangle.height - 10;
        this.window.getContentPane().add(this.contents);
        this.window.pack();
        this.window.setLocation(n, n2 - this.window.getHeight());
        this.window.setVisible(true);
        this.animateDownTimer = new Timer(5, new ActionListener(){
            private int percentage = 99;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Slider.this.animate(this.percentage);
                if (this.percentage-- <= 0) {
                    Slider.this.animateDownTimer.stop();
                }
            }
        });
        this.dismissTimer = new Timer(1000 * this.displaySeconds, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Slider.this.animateDownTimer.start();
            }
        });
        this.dismissTimer.setRepeats(false);
        this.animateUpTimer = new Timer(5, new ActionListener(){
            private int percentage = 1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Slider.this.animate(this.percentage);
                if (this.percentage++ >= 100) {
                    Slider.this.animateUpTimer.stop();
                    Slider.this.dismissTimer.start();
                }
            }
        });
        this.animateUpTimer.start();
    }

    public void close() {
        if (this.animateUpTimer != null && this.animateUpTimer.isRunning()) {
            this.animateUpTimer.stop();
        }
        if (this.animateDownTimer != null && this.animateDownTimer.isRunning()) {
            this.animateDownTimer.stop();
        }
        if (this.dismissTimer != null && this.dismissTimer.isRunning()) {
            this.dismissTimer.stop();
        }
        if (this.window != null) {
            this.window.dispose();
            this.window = null;
        }
    }

    public void animate(long l) {
        if (this.window == null) {
            return;
        }
        if (Constants.OPACITY_SUPPORTED) {
            float f = 1.0f - (float)this.translucencyPercentage / 100.0f;
            UIUtil.applyTranslucency(this.window, Float.valueOf(f * (float)l / 100.0f));
        }
        if (l <= 0L) {
            this.close();
        }
    }
}

