/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.notification;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.notification.NotificationForm;
import de.dal33t.powerfolder.ui.notification.Slider;
import de.dal33t.powerfolder.util.Reject;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JWindow;

public abstract class NotificationHandlerBase
extends PFComponent {
    private String title;
    private String messageText;
    private String acceptOptionLabel;
    private Action acceptAction;
    private String cancelOptionLabel;
    private Action cancelAction;
    private final JWindow dialog = new JWindow();
    private final Slider slider = new Slider((JComponent)this.dialog.getContentPane(), PreferencesEntry.NOTIFICATION_DISPLAY.getValueInt(this.getController()), PreferencesEntry.NOTIFICATION_TRANSLUCENT.getValueInt(this.getController()), this.getController().isNotifyLeft());

    protected NotificationHandlerBase(Controller controller) {
        super(controller);
    }

    public void show() {
        Reject.ifNull(this.title, "Title must not be null");
        Reject.ifNull(this.messageText, "MessageText must not be null");
        NotificationForm notificationForm = new NotificationForm(this.getController(), this.title, this.messageText, this.acceptOptionLabel, this.acceptAction, this.cancelOptionLabel, this.cancelAction);
        this.dialog.getContentPane().add((Component)notificationForm, "Center");
        this.dialog.pack();
        this.slider.show();
    }

    protected void sliderClose() {
        this.slider.close();
    }

    protected void setTitle(String string) {
        this.title = string;
    }

    protected void setMessageText(String string) {
        this.messageText = string;
    }

    protected void setAcceptOptionLabel(String string) {
        this.acceptOptionLabel = string;
    }

    protected void setAcceptAction(Action action) {
        this.acceptAction = action;
    }

    protected void setCancelOptionLabel(String string) {
        this.cancelOptionLabel = string;
    }

    protected void setCancelAction(Action action) {
        this.cancelAction = action;
    }
}

