/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.notification;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AnimatingSheet
extends JPanel {
    private Dimension animatingSize = new Dimension(0, 1);
    private JComponent source;
    private BufferedImage offscreenImage;

    public AnimatingSheet() {
        this.setOpaque(true);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.animatingSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.animatingSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.animatingSize;
    }

    private void makeOffscreenImage(JComponent jComponent) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        this.offscreenImage = graphicsConfiguration.createCompatibleImage(jComponent.getWidth(), jComponent.getHeight());
        Graphics2D graphics2D = (Graphics2D)this.offscreenImage.getGraphics();
        graphics2D.setColor(jComponent.getBackground());
        graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        jComponent.paint(graphics2D);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(this.offscreenImage, 0, 0, this.source.getWidth(), this.animatingSize.height, 0, 0, this.source.getWidth(), this.animatingSize.height, this);
    }

    public void setAnimatingHeight(int n) {
        this.animatingSize.height = n;
        this.setSize(this.animatingSize);
    }

    public void setSource(JComponent jComponent) {
        this.source = jComponent;
        this.animatingSize.width = jComponent.getWidth();
        this.makeOffscreenImage(jComponent);
    }
}

