/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.settings;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.FolderService;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.event.DiskItemFilterListener;
import de.dal33t.powerfolder.event.FolderMembershipEvent;
import de.dal33t.powerfolder.event.FolderMembershipListener;
import de.dal33t.powerfolder.event.PatternChangedEvent;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.FolderDBMaintCommando;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.FolderRemoveDialog;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.event.SelectionChangeEvent;
import de.dal33t.powerfolder.ui.event.SelectionChangeListener;
import de.dal33t.powerfolder.ui.event.SelectionModel;
import de.dal33t.powerfolder.ui.panel.ArchiveModeSelectorPanel;
import de.dal33t.powerfolder.ui.panel.SyncProfileSelectorPanel;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.pattern.Pattern;
import de.dal33t.powerfolder.util.pattern.PatternFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SettingsTab
extends PFUIComponent {
    private final ServerClient serverClient;
    private Folder folder;
    private ValueModel localVersionModel;
    private ValueModel onlineVersionModel;
    private final ValueModel scriptModel;
    private DefaultListModel<String> patternsListModel = new DefaultListModel();
    private final SelectionModel selectionModel;
    private FolderMembershipListener membershipListener;
    private final DiskItemFilterListener patternChangeListener;
    private volatile boolean updatingOnlineArchiveMode;
    private final RemoveFolderAction removeFolderAction;
    private JPanel uiComponent;
    private final SyncProfileSelectorPanel transferModeSelectorPanel;
    private final ArchiveModeSelectorPanel localArchiveModeSelectorPanel;
    private final ArchiveModeSelectorPanel onlineArchiveModeSelectorPanel;
    private JList<String> patternsList;
    private final JTextField localFolderField;
    private final JButton localFolderButton;
    private ActionLabel confOSActionLabel;
    private BaseAction confOSAction;
    private Action maintainDBAction;
    private JButtonMini editButton;
    private JButtonMini removeButton;
    private boolean settingFolder;
    private JLabel onlineLabel;
    private JCheckBox syncPatternsCheckBox;

    public SettingsTab(Controller controller) {
        super(controller);
        this.serverClient = controller.getOSClient();
        this.transferModeSelectorPanel = new SyncProfileSelectorPanel(this.getController());
        MyActionListener myActionListener = new MyActionListener();
        this.selectionModel = new SelectionModel();
        this.localFolderField = new JTextField();
        this.localFolderField.setEditable(false);
        this.localFolderButton = new JButtonMini(Icons.getIconById("directory.icon"), Translation.get("settings_tab.select_directory.text"));
        this.localFolderButton.setEnabled(false);
        this.localFolderButton.addActionListener(myActionListener);
        this.patternChangeListener = new MyPatternChangeListener();
        this.patternsListModel = new DefaultListModel();
        this.removeFolderAction = new RemoveFolderAction(this.getController());
        this.maintainDBAction = new MaintainFolderAction(this.getController());
        this.serverClient.addListener(new MyServerClientListener());
        this.membershipListener = new MyFolderMembershipListener();
        this.scriptModel = new ValueHolder(null, false);
        MyLocalValueChangeListener myLocalValueChangeListener = new MyLocalValueChangeListener();
        this.localVersionModel = new ValueHolder();
        this.localVersionModel.addValueChangeListener(myLocalValueChangeListener);
        MyOnlineValueChangeListener myOnlineValueChangeListener = new MyOnlineValueChangeListener();
        this.onlineVersionModel = new ValueHolder();
        this.onlineVersionModel.addValueChangeListener(myOnlineValueChangeListener);
        ArrayList<ValueModel> arrayList = new ArrayList<ValueModel>();
        ArrayList<ValueModel> arrayList2 = new ArrayList<ValueModel>();
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(controller).booleanValue()) {
            arrayList.add(this.localVersionModel);
            arrayList2.add(this.onlineVersionModel);
        } else {
            arrayList.add(this.localVersionModel);
            arrayList.add(this.onlineVersionModel);
        }
        this.localArchiveModeSelectorPanel = new ArchiveModeSelectorPanel(controller, arrayList, new LocalPurgeListener());
        this.onlineArchiveModeSelectorPanel = new ArchiveModeSelectorPanel(controller, arrayList2, new OnlinePurgeListener());
        this.onlineLabel = new JLabel(Translation.get("general.online_archive_mode"));
        this.onlineLabel.setVisible(false);
        this.onlineArchiveModeSelectorPanel.getUIComponent().setVisible(false);
    }

    public void setFolderInfo(FolderInfo folderInfo) {
        if (this.folder != null) {
            this.folder.getDiskItemFilter().removeListener(this.patternChangeListener);
            this.folder.removeMembershipListener(this.membershipListener);
        }
        this.settingFolder = true;
        this.folder = this.getController().getFolderRepository().getFolder(folderInfo);
        this.folder.getDiskItemFilter().addListener(this.patternChangeListener);
        this.folder.addMembershipListener(this.membershipListener);
        this.transferModeSelectorPanel.setUpdateableFolder(this.folder);
        this.scriptModel.setValue(this.folder.getDownloadScript());
        this.localArchiveModeSelectorPanel.setArchiveMode(this.folder.getFileArchiver().getVersionsPerFile());
        this.syncPatternsCheckBox.setSelected(this.folder.isSyncPatterns());
        this.settingFolder = false;
        this.update();
        this.enableConfigOSAction();
        this.loadOnlineArchiveMode();
    }

    private void loadOnlineArchiveMode() {
        FolderInfo folderInfo;
        FolderInfo folderInfo2 = folderInfo = this.folder == null ? null : this.folder.getInfo();
        if (this.serverClient.isConnected() && this.serverClient.joinedByServer(folderInfo)) {
            new MyServerModeSwingWorker(folderInfo).execute();
        } else {
            this.onlineArchiveModeSelectorPanel.getUIComponent().setVisible(false);
            this.onlineLabel.setVisible(false);
        }
    }

    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    private void buildUIComponent() {
        FormLayout formLayout = new FormLayout("3dlu, right:pref, 3dlu, 140dlu, 3dlu, pref, pref:grow", "3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 12dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 2;
        Boolean bl = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController());
        if (bl.booleanValue()) {
            defaultFormBuilder.add((Component)new JLabel(Translation.get("general.transfer_mode")), cellConstraints.xy(2, n));
            defaultFormBuilder.add(this.transferModeSelectorPanel.getUIComponent(), cellConstraints.xyw(4, n, 4));
        } else {
            this.transferModeSelectorPanel.getUIComponent();
        }
        defaultFormBuilder.add((Component)new JLabel(Translation.get("settings_tab.local_folder_location")), cellConstraints.xy(2, n += 2));
        defaultFormBuilder.add((Component)this.localFolderField, cellConstraints.xy(4, n));
        defaultFormBuilder.add((Component)this.localFolderButton, cellConstraints.xy(6, n));
        defaultFormBuilder.add((Component)new JLabel(Translation.get("general.local_archive_mode")), cellConstraints.xy(2, n += 2));
        defaultFormBuilder.add(this.localArchiveModeSelectorPanel.getUIComponent(), cellConstraints.xyw(4, n, 4));
        if (bl.booleanValue()) {
            defaultFormBuilder.add((Component)this.onlineLabel, cellConstraints.xy(2, n += 2));
            defaultFormBuilder.add(this.onlineArchiveModeSelectorPanel.getUIComponent(), cellConstraints.xyw(4, n, 4));
        }
        n += 2;
        if (bl.booleanValue()) {
            defaultFormBuilder.addLabel(Translation.get("exp.settings_tab.download_script"), cellConstraints.xy(2, n));
            defaultFormBuilder.add((Component)this.createScriptField(), cellConstraints.xyw(4, n, 4));
        }
        n += 2;
        if (bl.booleanValue()) {
            defaultFormBuilder.add((Component)new JLabel(Translation.get("exp.settings_tab.ignore_patterns")), cellConstraints.xy(2, n, "right, top"));
            defaultFormBuilder.add((Component)this.createPatternsPanel(), cellConstraints.xyw(4, n, 4));
            defaultFormBuilder.add((Component)this.createConfigurePanel(), cellConstraints.xy(4, n += 2));
        } else {
            this.createPatternsPanel();
            this.createConfigurePanel();
            n += 2;
        }
        defaultFormBuilder.add((Component)this.createDeletePanel(), cellConstraints.xy(4, n += 2));
        if (bl.booleanValue()) {
            defaultFormBuilder.add((Component)this.createMaintainPanel(), cellConstraints.xy(4, n += 2));
        }
        this.addSelectionListener();
        this.uiComponent = defaultFormBuilder.getPanel();
    }

    private void addSelectionListener() {
        this.selectionModel.addSelectionChangeListener(new SelectionChangeListener(){

            @Override
            public void selectionChanged(SelectionChangeEvent selectionChangeEvent) {
                int n = SettingsTab.this.selectionModel.getSelections() == null ? 0 : SettingsTab.this.selectionModel.getSelections().length;
                SettingsTab.this.editButton.setEnabled(n > 0);
                SettingsTab.this.removeButton.setEnabled(n > 0);
            }
        });
    }

    private JPanel createDeletePanel() {
        FormLayout formLayout = new FormLayout("pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        ActionLabel actionLabel = new ActionLabel(this.getController(), this.removeFolderAction);
        panelBuilder.add((Component)actionLabel.getUIComponent(), cellConstraints.xy(1, 1));
        actionLabel.convertToBigLabel();
        return panelBuilder.getPanel();
    }

    private JPanel createMaintainPanel() {
        FormLayout formLayout = new FormLayout("pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        ActionLabel actionLabel = new ActionLabel(this.getController(), this.maintainDBAction);
        panelBuilder.add((Component)actionLabel.getUIComponent(), cellConstraints.xy(1, 1));
        actionLabel.convertToBigLabel();
        return panelBuilder.getPanel();
    }

    private JPanel createConfigurePanel() {
        FormLayout formLayout = new FormLayout("pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.confOSAction = new FolderOnlineStorageAction(this.getController());
        this.confOSActionLabel = new ActionLabel(this.getController(), this.confOSAction);
        this.confOSActionLabel.convertToBigLabel();
        panelBuilder.add((Component)this.confOSActionLabel.getUIComponent(), cellConstraints.xy(1, 1));
        return panelBuilder.getPanel();
    }

    private JPanel createPatternsPanel() {
        this.patternsList = new JList<String>(this.patternsListModel);
        this.patternsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SettingsTab.this.selectionModel.setSelection(SettingsTab.this.patternsList.getSelectedValue());
            }
        });
        Dimension dimension = new Dimension(200, 100);
        JScrollPane jScrollPane = new JScrollPane(this.patternsList);
        jScrollPane.setPreferredSize(dimension);
        FormLayout formLayout = new FormLayout("140dlu", "pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)jScrollPane, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.createButtonBar(), cellConstraints.xy(1, 3));
        return panelBuilder.getPanel();
    }

    private JComponent createScriptField() {
        this.scriptModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SettingsTab.this.folder.setDownloadScript((String)propertyChangeEvent.getNewValue());
            }
        });
        FormLayout formLayout = new FormLayout("140dlu, 3dlu, pref, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        JTextField jTextField = BasicComponentFactory.createTextField(this.scriptModel, false);
        jTextField.setEditable(true);
        panelBuilder.add((Component)jTextField, cellConstraints.xy(1, 1));
        JButtonMini jButtonMini = new JButtonMini(Icons.getIconById("directory.icon"), Translation.get("exp.settings_tab.download_script"));
        jButtonMini.addActionListener(new SelectScriptAction());
        panelBuilder.add((Component)jButtonMini, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)Help.createWikiLinkButton(this.getController(), "Script_execution"), cellConstraints.xy(4, 1));
        return panelBuilder.getPanel();
    }

    private void update() {
        this.rebuildPatterns();
        this.localFolderField.setText(this.folder.getCommitOrLocalDir().toAbsolutePath().toString());
        this.localFolderButton.setEnabled(true);
    }

    private void rebuildPatterns() {
        this.patternsListModel.clear();
        List<String> list = this.folder.getDiskItemFilter().getPatterns();
        for (String string : list) {
            this.patternsListModel.addElement(string);
        }
    }

    private JPanel createButtonBar() {
        AddAction addAction = new AddAction(this.getController());
        EditAction editAction = new EditAction(this.getController());
        RemoveAction removeAction = new RemoveAction(this.getController());
        FormLayout formLayout = new FormLayout("pref, pref, pref, pref, pref:grow", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.editButton = new JButtonMini(editAction);
        this.removeButton = new JButtonMini(removeAction);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        panelBuilder.add((Component)new JButtonMini(addAction), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.editButton, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.removeButton, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)Help.createWikiLinkButton(this.getController(), "Excluding_Files_from_Synchronization"), cellConstraints.xy(4, 1));
        this.syncPatternsCheckBox = new JCheckBox(Translation.get("exp.settings_tab.sync_patterns"));
        this.syncPatternsCheckBox.setToolTipText(Translation.get("exp.settings_tab.sync_patterns.tip"));
        this.syncPatternsCheckBox.addActionListener(new MyActionListener());
        panelBuilder.add((Component)this.syncPatternsCheckBox, cellConstraints.xy(5, 1));
        this.syncPatternsCheckBox.setVisible(true);
        return panelBuilder.getPanel();
    }

    public void removePatterns(String string) {
        String[] stringArray;
        String[] stringArray2 = new String[]{Translation.get("remove_pattern.remove"), Translation.get("remove_pattern.dont"), Translation.get("general.cancel")};
        block0: for (String string2 : stringArray = string.split("\\n")) {
            Pattern pattern = PatternFactory.createPattern(string2);
            for (String string3 : this.folder.getDiskItemFilter().getPatterns()) {
                if (!pattern.isMatch(string3)) continue;
                int n = DialogFactory.genericDialog(this.getController(), Translation.get("remove_pattern.title"), Translation.get("remove_pattern.prompt", string2), stringArray2, 0, GenericDialogType.INFO);
                if (n == 0) {
                    this.folder.removePattern(string3);
                    continue;
                }
                if (n != 2) continue;
                continue block0;
            }
        }
        this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(this.folder.getInfo());
    }

    public void showAddPane(String string) {
        Reject.ifNull(string, "Patterns required");
        String[] stringArray = string.split("\\n");
        if (stringArray.length == 1) {
            String string2 = stringArray[0];
            String string3 = Translation.get("exp.settings_tab.add_a_pattern.title");
            String string4 = Translation.get("exp.settings_tab.add_a_pattern.text");
            String string5 = (String)JOptionPane.showInputDialog(this.getUIController().getActiveFrame(), string4, string3, -1, null, null, string2);
            if (!StringUtils.isBlank(string5)) {
                this.folder.addPattern(string5);
                this.getController().getTransferManager().checkActiveTranfersForExcludes();
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (String string6 : stringArray) {
                stringBuilder.append("    ");
                if (n++ >= 10) {
                    stringBuilder.append(Translation.get("general.more.lower_case") + "...\n");
                    break;
                }
                stringBuilder.append(string6 + "\n");
            }
            String string7 = Translation.get("exp.settings_tab.add_patterns.text_1") + "\n\n" + stringBuilder.toString();
            String string8 = Translation.get("exp.settings_tab.add_patterns.title");
            int n2 = DialogFactory.genericDialog(this.getController(), string8, string7, new String[]{Translation.get("general.ok"), Translation.get("general.cancel")}, 0, GenericDialogType.QUESTION);
            if (n2 == 0) {
                for (String string9 : stringArray) {
                    this.folder.addPattern(string9);
                }
            }
        }
        this.patternsList.getSelectionModel().clearSelection();
    }

    private void enableConfigOSAction() {
        boolean bl = false;
        if (this.folder != null && this.serverClient.isConnected() && this.serverClient.isLoggedIn()) {
            bl = true;
            boolean bl2 = this.serverClient.joinedByCloud(this.folder);
            if (bl2) {
                this.confOSActionLabel.setText(Translation.get("exp.action_stop_online_storage.name"));
                this.confOSActionLabel.setToolTipText(Translation.get("exp.action_stop_online_storage.description"));
            } else {
                this.confOSActionLabel.setText(Translation.get("exp.action_backup_online_storage.name"));
                this.confOSActionLabel.setToolTipText(Translation.get("exp.action_backup_online_storage.description"));
            }
        }
        this.confOSAction.allowWith(FolderPermission.admin(this.folder.getInfo()));
        this.confOSActionLabel.getUIComponent().setVisible(bl && ConfigurationEntry.SERVER_SYNC_MANDATORY.getValueBoolean(this.getController()) == false);
    }

    private void updateLocalArchiveMode(Object object, Object object2) {
        Integer n = (Integer)this.localVersionModel.getValue();
        this.folder.setArchiveVersions(n);
        if (object2 != null && object != null && object2 instanceof Integer && object instanceof Integer && (Integer)object2 < (Integer)object && (Integer)object2 > -1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = DialogFactory.genericDialog(SettingsTab.this.getController(), Translation.get("exp.settings_tab.offer_maintenance.title"), Translation.get("exp.settings_tab.offer_maintenance.text"), new String[]{Translation.get("exp.settings_tab.offer_maintenance.cleanup_button"), Translation.get("general.cancel")}, 0, GenericDialogType.QUESTION);
                    if (n == 0) {
                        MyMaintainSwingWorker myMaintainSwingWorker = new MyMaintainSwingWorker();
                        myMaintainSwingWorker.execute();
                    }
                }
            });
        }
    }

    private void purgeLocalArchive() {
        if (this.folder == null) {
            this.logSevere("Calling purgeArchive with no folder???");
        } else {
            int n = DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.purge_archive_title"), Translation.get("settings_tab.purge_archive_message"), new String[]{Translation.get("settings_tab.purge_archive_purge"), Translation.get("general.cancel")}, 0, GenericDialogType.WARN);
            if (n == 0) {
                try {
                    this.folder.getFileArchiver().purge(this.folder, this.serverClient.getAccount());
                }
                catch (IOException iOException) {
                    this.logSevere(iOException);
                    DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.purge_archive_title"), Translation.get("settings_tab.purge_archive_problem"), GenericDialogType.ERROR);
                }
            }
        }
    }

    private void purgeOnlineArchive() {
        if (this.folder == null) {
            this.logSevere("Calling purgeArchive with no folder???");
        } else {
            int n = DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.purge_archive_title"), Translation.get("settings_tab.purge_archive_message"), new String[]{Translation.get("settings_tab.purge_archive_purge"), Translation.get("general.cancel")}, 0, GenericDialogType.WARN);
            if (n == 0) {
                try {
                    if (this.serverClient.getFolderService(this.folder.getInfo()).purgeArchive(this.folder.getInfo())) {
                        this.logInfo("Successfully cleared online versioning of folder " + this.folder.getName());
                    }
                }
                catch (Exception exception) {
                    this.logSevere(exception);
                    DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.purge_archive_title"), Translation.get("settings_tab.purge_archive_problem"), GenericDialogType.ERROR);
                }
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SettingsTab.this.settingFolder) {
                if (actionEvent.getSource().equals(SettingsTab.this.localFolderButton)) {
                    SettingsTab.this.getController().getUIController().getApplicationModel().moveLocalFolder(SettingsTab.this.folder);
                } else if (actionEvent.getSource().equals(SettingsTab.this.syncPatternsCheckBox)) {
                    SettingsTab.this.folder.setSyncPatterns(SettingsTab.this.syncPatternsCheckBox.isSelected());
                }
            }
        }
    }

    private class MyPatternChangeListener
    implements DiskItemFilterListener {
        private MyPatternChangeListener() {
        }

        @Override
        public void patternAdded(PatternChangedEvent patternChangedEvent) {
            SettingsTab.this.rebuildPatterns();
        }

        @Override
        public void patternRemoved(PatternChangedEvent patternChangedEvent) {
            SettingsTab.this.rebuildPatterns();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class RemoveFolderAction
    extends BaseAction {
        private RemoveFolderAction(Controller controller) {
            super("action_remove_folder", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FolderRemoveDialog folderRemoveDialog = new FolderRemoveDialog(this.getController(), SettingsTab.this.folder.getInfo());
            folderRemoveDialog.open();
        }
    }

    private class MaintainFolderAction
    extends BaseAction {
        private MaintainFolderAction(Controller controller) {
            super("exp.action_maintain_folder_db", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            this.getController().getIOProvider().startIO(new Runnable(){

                @Override
                public void run() {
                    SettingsTab.this.folder.broadcastMessages(new FolderDBMaintCommando(SettingsTab.this.folder.getInfo(), new Date()));
                    SettingsTab.this.folder.maintainFolderDB(System.currentTimeMillis());
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MaintainFolderAction.this.setEnabled(true);
                            DialogFactory.genericDialog(MaintainFolderAction.this.getController(), "Cleanup Database", Translation.get("database_cleanup_finished"), GenericDialogType.INFO);
                        }
                    });
                }
            });
        }
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            SettingsTab.this.enableConfigOSAction();
            SettingsTab.this.loadOnlineArchiveMode();
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            SettingsTab.this.enableConfigOSAction();
            SettingsTab.this.loadOnlineArchiveMode();
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            SettingsTab.this.enableConfigOSAction();
            SettingsTab.this.loadOnlineArchiveMode();
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            SettingsTab.this.enableConfigOSAction();
            SettingsTab.this.loadOnlineArchiveMode();
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            SettingsTab.this.enableConfigOSAction();
            SettingsTab.this.loadOnlineArchiveMode();
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
            SettingsTab.this.enableConfigOSAction();
            SettingsTab.this.loadOnlineArchiveMode();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyFolderMembershipListener
    implements FolderMembershipListener {
        private MyFolderMembershipListener() {
        }

        @Override
        public void memberJoined(FolderMembershipEvent folderMembershipEvent) {
            if (folderMembershipEvent.getMember().isServer()) {
                SettingsTab.this.enableConfigOSAction();
            }
        }

        @Override
        public void memberLeft(FolderMembershipEvent folderMembershipEvent) {
            if (folderMembershipEvent.getMember().isServer()) {
                SettingsTab.this.enableConfigOSAction();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyLocalValueChangeListener
    implements PropertyChangeListener {
        private MyLocalValueChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == SettingsTab.this.localVersionModel && !SettingsTab.this.settingFolder) {
                SettingsTab.this.updateLocalArchiveMode(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    private class MyOnlineValueChangeListener
    implements PropertyChangeListener {
        private MyOnlineValueChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == SettingsTab.this.onlineVersionModel && !SettingsTab.this.updatingOnlineArchiveMode) {
                MyUpdaterSwingWorker myUpdaterSwingWorker = new MyUpdaterSwingWorker();
                myUpdaterSwingWorker.execute();
            }
        }
    }

    private class LocalPurgeListener
    implements ActionListener {
        private LocalPurgeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SettingsTab.this.purgeLocalArchive();
        }
    }

    private class OnlinePurgeListener
    implements ActionListener {
        private OnlinePurgeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    SettingsTab.this.purgeOnlineArchive();
                    return null;
                }
            }.execute();
        }
    }

    private class MyServerModeSwingWorker
    extends SwingWorker {
        private final FolderInfo folderInfo;

        private MyServerModeSwingWorker(FolderInfo folderInfo) {
            this.folderInfo = folderInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doInBackground() {
            try {
                SettingsTab.this.onlineArchiveModeSelectorPanel.getUIComponent().setVisible(false);
                SettingsTab.this.onlineLabel.setVisible(false);
                if (this.folderInfo != null && SettingsTab.this.serverClient.isLoggedIn()) {
                    FolderService folderService = SettingsTab.this.serverClient.getFolderService(this.folderInfo);
                    int n = folderService.getVersionsPerFile(this.folderInfo);
                    SettingsTab.this.updatingOnlineArchiveMode = true;
                    SettingsTab.this.onlineArchiveModeSelectorPanel.setArchiveMode(n);
                    SettingsTab.this.onlineArchiveModeSelectorPanel.getUIComponent().setVisible(true);
                    boolean bl = SettingsTab.this.serverClient.getSecurityService().hasPermission(SettingsTab.this.serverClient.getAccountInfo(), FolderPermission.admin(this.folderInfo));
                    SettingsTab.this.onlineArchiveModeSelectorPanel.setChangeable(bl);
                    SettingsTab.this.onlineLabel.setVisible(true);
                }
            }
            catch (Exception exception) {
                SettingsTab.this.logWarning(exception.toString());
                Object var2_4 = null;
                return var2_4;
            }
            finally {
                SettingsTab.this.updatingOnlineArchiveMode = false;
            }
            return null;
        }
    }

    private class FolderOnlineStorageAction
    extends BaseAction {
        private FolderOnlineStorageAction(Controller controller) {
            super("exp.action_backup_online_storage", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PFWizard.openMirrorFolderWizard(this.getController(), SettingsTab.this.folder);
        }
    }

    private class SelectScriptAction
    extends AbstractAction {
        private SelectScriptAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)SettingsTab.this.scriptModel.getValue();
            JFileChooser jFileChooser = DialogFactory.createFileChooser();
            jFileChooser.setSelectedFile(Paths.get(string, new String[0]).toFile());
            int n = jFileChooser.showDialog(SettingsTab.this.getUIController().getMainFrame().getUIComponent(), Translation.get("general.select"));
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                SettingsTab.this.scriptModel.setValue(string2);
            }
        }
    }

    private class AddAction
    extends BaseAction {
        private AddAction(Controller controller) {
            super("action_add_ignore", controller);
            this.setIcon(Icons.getIconById("action_remove_ignore.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SettingsTab.this.showAddPane(Translation.get("exp.settings_tab.add_a_pattern.example"));
        }
    }

    private class EditAction
    extends BaseAction {
        EditAction(Controller controller) {
            super("action_edit_ignore", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = Translation.get("exp.settings_tab.edit_a_pattern.text");
            String string2 = Translation.get("exp.settings_tab.edit_a_pattern.title");
            String string3 = (String)JOptionPane.showInputDialog(UIUtil.getParentWindow(actionEvent), string, string2, -1, null, null, SettingsTab.this.selectionModel.getSelection());
            if (!StringUtils.isBlank(string3)) {
                SettingsTab.this.folder.removePattern((String)SettingsTab.this.selectionModel.getSelection());
                SettingsTab.this.folder.addPattern(string3);
                this.getController().getTransferManager().checkActiveTranfersForExcludes();
                this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(SettingsTab.this.folder.getInfo());
            }
            SettingsTab.this.patternsList.getSelectionModel().clearSelection();
        }
    }

    private class RemoveAction
    extends BaseAction {
        private RemoveAction(Controller controller) {
            super("action_remove_ignore", controller);
            this.setIcon(Icons.getIconById("action_add_ignore.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (Object object : SettingsTab.this.selectionModel.getSelections()) {
                String string = (String)object;
                SettingsTab.this.folder.removePattern(string);
                this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(SettingsTab.this.folder.getInfo());
            }
            SettingsTab.this.patternsList.getSelectionModel().clearSelection();
        }
    }

    private class MyUpdaterSwingWorker
    extends SwingWorker {
        private MyUpdaterSwingWorker() {
        }

        protected Object doInBackground() throws Exception {
            try {
                FolderService folderService;
                if (SettingsTab.this.folder == null || SettingsTab.this.settingFolder) {
                    return null;
                }
                FolderInfo folderInfo = SettingsTab.this.folder.getInfo();
                FolderService folderService2 = folderService = SettingsTab.this.serverClient.isLoggedIn() && SettingsTab.this.serverClient.isConnected() ? SettingsTab.this.serverClient.getFolderService(folderInfo) : null;
                if (SettingsTab.this.serverClient.getAccount().hasAdminPermission(folderInfo)) {
                    Integer n = (Integer)SettingsTab.this.onlineVersionModel.getValue();
                    folderService.setArchiveMode(folderInfo, n);
                } else {
                    SettingsTab.this.logWarning("Permission denied to " + SettingsTab.this.serverClient.getAccount().getUsername() + ". FolderAdminPermission on " + folderInfo);
                    new MyServerModeSwingWorker(folderInfo).execute();
                }
            }
            catch (Exception exception) {
                SettingsTab.this.logWarning(exception);
            }
            return null;
        }
    }

    private class MyMaintainSwingWorker
    extends SwingWorker {
        private MyMaintainSwingWorker() {
        }

        public Object doInBackground() {
            try {
                return SettingsTab.this.folder.getFileArchiver().maintain();
            }
            catch (Exception exception) {
                SettingsTab.this.logSevere(exception);
                return null;
            }
        }
    }
}

