/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.members;

import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.SecurityService;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.event.FolderAdapter;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.event.FolderMembershipEvent;
import de.dal33t.powerfolder.event.FolderMembershipListener;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.GroupInfo;
import de.dal33t.powerfolder.net.NodeManager;
import de.dal33t.powerfolder.security.FolderOwnerPermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.security.SecurityException;
import de.dal33t.powerfolder.security.SecurityManagerEvent;
import de.dal33t.powerfolder.security.SecurityManagerListener;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.information.folder.members.FolderMember;
import de.dal33t.powerfolder.ui.information.folder.members.FolderMemberComparator;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MembersSimpleTableModel
extends PFUIComponent
implements TableModel,
SortedTableModel {
    static final int COL_TYPE = 0;
    static final int COL_USERNAME = 1;
    static final int COL_PERMISSION = 2;
    private static final String[] columnHeaders = new String[]{Translation.get("folder_member_table_model.icon"), Translation.get("folder_member_table_model.account"), Translation.get("folder_member_table_model.permission")};
    private static final FolderMemberComparator[] columnComparators = new FolderMemberComparator[]{FolderMemberComparator.BY_TYPE, FolderMemberComparator.BY_DISPLAY_NAME, FolderMemberComparator.BY_PERMISSION};
    private final List<FolderMember> members;
    private final List<TableModelListener> listeners;
    private final FolderRepository folderRepository;
    private Folder folder;
    private MyFolderListener folderListener;
    private int sortColumn = -1;
    private boolean sortAscending = true;
    private ValueModel refreshingModel;
    private ValueModel permissionModel;
    private SelectionInList<FolderPermission> permissionsListModel;
    private boolean permissionsRetrieved;
    private boolean editPermissionsAllowed;
    private boolean updatingDefaultPermissionModel;
    private ValueModel defaultPermissionModel;
    private SelectionInList<FolderPermission> defaultPermissionsListModel;

    public MembersSimpleTableModel(Controller controller) {
        super(controller);
        this.folderRepository = controller.getFolderRepository();
        this.members = new ArrayList<FolderMember>();
        this.listeners = new ArrayList<TableModelListener>();
        this.refreshingModel = new ValueHolder(Boolean.FALSE, false);
        this.permissionModel = new ValueHolder(null, true);
        this.permissionsListModel = new SelectionInList();
        this.permissionsListModel.setSelectionHolder(this.permissionModel);
        this.defaultPermissionModel = new ValueHolder(null, true);
        this.defaultPermissionsListModel = new SelectionInList();
        this.defaultPermissionsListModel.setSelectionHolder(this.defaultPermissionModel);
        this.defaultPermissionModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (MembersSimpleTableModel.this.updatingDefaultPermissionModel) {
                    return;
                }
                FolderPermission folderPermission = (FolderPermission)propertyChangeEvent.getNewValue();
                MembersSimpleTableModel.this.refreshingModel.setValue(Boolean.TRUE);
                new DefaultPermissionSetter(MembersSimpleTableModel.this.folder.getInfo(), folderPermission).execute();
            }
        });
        this.folderListener = new MyFolderListener();
        NodeManager nodeManager = controller.getNodeManager();
        nodeManager.addNodeManagerListener(new MyNodeManagerListener());
        this.getController().getSecurityManager().addListener(new MySecurityManagerListener());
    }

    SelectionInList<FolderPermission> getPermissionsListModel() {
        return this.permissionsListModel;
    }

    SelectionInList<FolderPermission> getDefaultPermissionsListModel() {
        return this.defaultPermissionsListModel;
    }

    FolderPermission getDefaultPermission() {
        return (FolderPermission)this.defaultPermissionModel.getValue();
    }

    boolean isPermissionsRetrieved() {
        return this.permissionsRetrieved;
    }

    public ValueModel getRefreshingModel() {
        return this.refreshingModel;
    }

    public FolderInfo getFolderInfo() {
        return this.folder != null ? this.folder.getInfo() : null;
    }

    public void setFolderInfo(FolderInfo folderInfo) {
        if (this.folder != null) {
            this.folder.removeFolderListener(this.folderListener);
            this.folder.removeMembershipListener(this.folderListener);
        }
        this.folder = this.folderRepository.getFolder(folderInfo);
        this.folder.addFolderListener(this.folderListener);
        this.folder.addMembershipListener(this.folderListener);
        this.members.clear();
        for (Member member : this.folder.getMembersAsCollection()) {
            this.members.add(new FolderMember(this.folder, member, member.getAccountInfo(), null, null, false));
        }
        this.sortMe0(this.sortColumn);
        this.permissionsListModel.clearSelection();
        this.permissionsListModel.getList().clear();
        this.modelChanged(new TableModelEvent(this, 0, this.members.size() - 1));
        this.refreshModel();
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public int getColumnCount() {
        return columnHeaders.length;
    }

    @Override
    public String getColumnName(int n) {
        return columnHeaders[n];
    }

    @Override
    public int getRowCount() {
        return this.members.size();
    }

    public Member getMemberAt(int n) {
        if (n > this.getRowCount() - 1) {
            return null;
        }
        return this.members.get(n).getMember();
    }

    public FolderMember getFolderMemberAt(int n) {
        if (n > this.getRowCount() - 1) {
            return null;
        }
        return this.members.get(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return FolderMember.class;
            }
            case 2: {
                return FolderPermission.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n > this.getRowCount() - 1) {
            return null;
        }
        FolderMember folderMember = this.members.get(n);
        AccountInfo accountInfo = folderMember.getAccountInfo();
        GroupInfo groupInfo = folderMember.getGroupInfo();
        if (n2 == 0) {
            return folderMember;
        }
        if (n2 == 1) {
            if (groupInfo != null) {
                return groupInfo;
            }
            return accountInfo;
        }
        if (n2 == 2) {
            return folderMember.getPermission();
        }
        return 0;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 != 2) {
            return false;
        }
        return this.permissionsRetrieved && this.editPermissionsAllowed && this.getFolderMemberAt(n).getAccountInfo() != null && !(this.getFolderMemberAt(n).getPermission() instanceof FolderOwnerPermission);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Reject.ifFalse(n2 == 2, "Unable to set value in MembersTableModel; not editable");
        FolderMember folderMember = this.getFolderMemberAt(n);
        if (folderMember == null) {
            return;
        }
        if (folderMember.getAccountInfo() == null) {
            this.logSevere("Unable to set permission. No account for " + folderMember.getMember());
            return;
        }
        FolderPermission folderPermission = (FolderPermission)object;
        if (!Util.equals(folderPermission, folderMember.getPermission())) {
            if (folderPermission instanceof FolderOwnerPermission) {
                AccountInfo accountInfo = this.findFolderOwner();
                String string = accountInfo != null ? accountInfo.getDisplayName() : Translation.get("folder_member.nobody");
                AccountInfo accountInfo2 = folderMember.getAccountInfo();
                String string2 = accountInfo2 != null ? accountInfo2.getDisplayName() : Translation.get("folder_member.nobody");
                int n3 = DialogFactory.genericDialog(this.getController(), Translation.get("folder_member.change_owner.title"), Translation.get("folder_member.change_owner.message", string, string2), new String[]{Translation.get("general.continue"), Translation.get("general.cancel")}, 0, GenericDialogType.WARN);
                if (n3 != 0) {
                    return;
                }
            }
            new PermissionSetter(folderMember.getAccountInfo(), folderPermission).execute();
        }
    }

    private AccountInfo findFolderOwner() {
        for (FolderMember folderMember : this.members) {
            if (!(folderMember.getPermission() instanceof FolderOwnerPermission)) continue;
            return folderMember.getAccountInfo();
        }
        return null;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    void refreshModel() {
        this.refreshingModel.setValue(Boolean.TRUE);
        if (this.getController().getOSClient().isLoggedIn()) {
            new ModelRefresher().execute();
        } else {
            this.permissionsRetrieved = false;
            this.rebuild(new HashMap<Serializable, FolderPermission>(), null);
            this.refreshingModel.setValue(Boolean.FALSE);
        }
    }

    private void handleNodeChanged(Member member) {
        try {
            this.check(member);
            for (int i = 0; i < this.members.size(); ++i) {
                FolderMember folderMember = this.members.get(i);
                if (!member.equals(folderMember)) continue;
                this.modelChanged(new TableModelEvent(this, i, i));
                return;
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.logSevere("IllegalStateException", illegalStateException);
        }
    }

    private void check(Member member) throws IllegalStateException {
        if (this.folder == null) {
            throw new IllegalStateException("Folder not set");
        }
        if (member == null) {
            throw new IllegalStateException("Member not set in event");
        }
    }

    private void modelChanged(TableModelEvent tableModelEvent) {
        for (TableModelListener tableModelListener : this.listeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    @Override
    public boolean sortBy(int n) {
        boolean bl = this.sortColumn != n;
        this.sortColumn = n;
        if (!bl) {
            this.sortAscending = !this.sortAscending;
        }
        this.sortMe0(n);
        this.modelChanged(new TableModelEvent(this, 0, this.members.size() - 1));
        return true;
    }

    private void sortMe0(int n) {
        FolderMemberComparator folderMemberComparator = columnComparators[n];
        if (folderMemberComparator == null) {
            this.logWarning("Unknown sort column: " + n);
            return;
        }
        if (this.sortAscending) {
            Collections.sort(this.members, folderMemberComparator);
        } else {
            Collections.sort(this.members, new ReverseComparator<FolderMember>(folderMemberComparator));
        }
    }

    private void rebuild(Map<Serializable, FolderPermission> map, FolderPermission folderPermission) {
        this.members.clear();
        if (!map.isEmpty()) {
            for (Map.Entry<Serializable, FolderPermission> entry : map.entrySet()) {
                FolderMember folderMember = null;
                if (entry.getKey() instanceof AccountInfo) {
                    folderMember = new FolderMember(this.folder, null, (AccountInfo)entry.getKey(), null, entry.getValue(), false);
                } else if (entry.getKey() instanceof GroupInfo) {
                    folderMember = new FolderMember(this.folder, null, null, (GroupInfo)entry.getKey(), entry.getValue(), false);
                }
                this.members.add(folderMember);
            }
        }
        this.permissionsListModel.clearSelection();
        this.permissionsListModel.getList().clear();
        if (this.permissionsRetrieved) {
            this.permissionsListModel.getList().add(null);
            this.permissionsListModel.getList().add(FolderPermission.read(this.folder.getInfo()));
            this.permissionsListModel.getList().add(FolderPermission.readWrite(this.folder.getInfo()));
            if (ConfigurationEntry.SECURITY_PERMISSIONS_SHOW_FOLDER_ADMIN.getValueBoolean(this.getController()).booleanValue()) {
                this.permissionsListModel.getList().add(FolderPermission.admin(this.folder.getInfo()));
            }
            if (ConfigurationEntry.FOLDER_OWNERSHIP_CHANGEABLE.getValueBoolean(this.getController()).booleanValue() && this.getController().getOSClient().getAccount().hasOwnerPermission(this.folder.getInfo())) {
                this.permissionsListModel.getList().add(FolderPermission.owner(this.folder.getInfo()));
            }
        }
        this.updatingDefaultPermissionModel = true;
        this.defaultPermissionsListModel.clearSelection();
        this.defaultPermissionsListModel.getList().clear();
        if (this.permissionsRetrieved) {
            this.defaultPermissionsListModel.getList().add(null);
            this.defaultPermissionsListModel.getList().add(FolderPermission.read(this.folder.getInfo()));
            this.defaultPermissionsListModel.getList().add(FolderPermission.readWrite(this.folder.getInfo()));
            if (ConfigurationEntry.SECURITY_PERMISSIONS_SHOW_FOLDER_ADMIN.getValueBoolean(this.getController()).booleanValue()) {
                this.defaultPermissionsListModel.getList().add(FolderPermission.admin(this.folder.getInfo()));
            }
            this.defaultPermissionModel.setValue(folderPermission);
        }
        this.updatingDefaultPermissionModel = false;
        this.sortMe0(this.sortColumn);
        this.modelChanged(new TableModelEvent(this, 0, this.getRowCount(), -1, 1));
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(this.getUIController().getActiveFrame(), string, "Information", 1);
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }

    private class MyFolderListener
    extends FolderAdapter
    implements FolderMembershipListener {
        private MyFolderListener() {
        }

        @Override
        public void memberJoined(FolderMembershipEvent folderMembershipEvent) {
            MembersSimpleTableModel.this.refreshModel();
        }

        @Override
        public void memberLeft(FolderMembershipEvent folderMembershipEvent) {
            MembersSimpleTableModel.this.refreshModel();
        }

        @Override
        public void statisticsCalculated(FolderEvent folderEvent) {
            MembersSimpleTableModel.this.modelChanged(new TableModelEvent(MembersSimpleTableModel.this, 0, MembersSimpleTableModel.this.members.size() - 1));
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void friendAdded(NodeManagerEvent nodeManagerEvent) {
            MembersSimpleTableModel.this.handleNodeChanged(nodeManagerEvent.getNode());
        }

        @Override
        public void friendRemoved(NodeManagerEvent nodeManagerEvent) {
            MembersSimpleTableModel.this.handleNodeChanged(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            MembersSimpleTableModel.this.handleNodeChanged(nodeManagerEvent.getNode());
            if (nodeManagerEvent.getNode().isServer()) {
                MembersSimpleTableModel.this.refreshModel();
            }
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            MembersSimpleTableModel.this.handleNodeChanged(nodeManagerEvent.getNode());
        }

        @Override
        public void settingsChanged(NodeManagerEvent nodeManagerEvent) {
            MembersSimpleTableModel.this.handleNodeChanged(nodeManagerEvent.getNode());
        }
    }

    private class MySecurityManagerListener
    implements SecurityManagerListener {
        private MySecurityManagerListener() {
        }

        @Override
        public void nodeAccountStateChanged(SecurityManagerEvent securityManagerEvent) {
            if (MembersSimpleTableModel.this.folder.getMembersAsCollection().contains(securityManagerEvent.getNode())) {
                MembersSimpleTableModel.this.refreshModel();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class PermissionSetter
    extends SwingWorker<Void, Void> {
        private AccountInfo aInfo;
        private FolderPermission newPermission;
        private String errorMessage;

        public PermissionSetter(AccountInfo accountInfo, FolderPermission folderPermission) {
            Reject.ifNull(accountInfo, "AccountInfo is null");
            this.aInfo = accountInfo;
            this.newPermission = folderPermission;
            this.errorMessage = null;
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                MembersSimpleTableModel.this.getController().getOSClient().getSecurityService(MembersSimpleTableModel.this.folder.getInfo()).setFolderPermission(this.aInfo, MembersSimpleTableModel.this.folder.getInfo(), this.newPermission);
            }
            catch (SecurityException securityException) {
                this.errorMessage = securityException.getMessage();
            }
            return null;
        }

        @Override
        protected void done() {
            if (StringUtils.isNotBlank(this.errorMessage)) {
                MembersSimpleTableModel.this.showError(this.errorMessage);
            }
            MembersSimpleTableModel.this.refreshModel();
        }
    }

    private class ModelRefresher
    extends SwingWorker<Map<Serializable, FolderPermission>, Void> {
        private Folder refreshFor;
        private FolderPermission defaultPermission;

        private ModelRefresher() {
        }

        @Override
        protected Map<Serializable, FolderPermission> doInBackground() throws Exception {
            this.refreshFor = MembersSimpleTableModel.this.folder;
            SecurityService securityService = MembersSimpleTableModel.this.getController().getOSClient().getSecurityService(this.refreshFor.getInfo());
            this.defaultPermission = securityService.getDefaultPermission(MembersSimpleTableModel.this.folder.getInfo());
            AccountInfo accountInfo = MembersSimpleTableModel.this.getController().getMySelf().getAccountInfo();
            MembersSimpleTableModel.this.editPermissionsAllowed = false;
            if (accountInfo != null) {
                MembersSimpleTableModel.this.editPermissionsAllowed = MembersSimpleTableModel.this.getController().getSecurityManager().hasPermission(accountInfo, (Permission)FolderPermission.admin(MembersSimpleTableModel.this.folder.getInfo()));
            }
            try {
                return securityService.getAllFolderPermissions(this.refreshFor.getInfo());
            }
            catch (RemoteCallException remoteCallException) {
                try {
                    Map<AccountInfo, FolderPermission> map = securityService.getFolderPermissions(this.refreshFor.getInfo());
                    HashMap<Serializable, FolderPermission> hashMap = new HashMap<Serializable, FolderPermission>(map.size());
                    for (Map.Entry<AccountInfo, FolderPermission> entry : map.entrySet()) {
                        hashMap.put(entry.getKey(), entry.getValue());
                    }
                    return hashMap;
                }
                catch (RuntimeException runtimeException) {
                    MembersSimpleTableModel.this.logWarning("Could not retrive permission list from the server");
                    throw runtimeException;
                }
            }
        }

        @Override
        protected void done() {
            try {
                Map map = (Map)this.get();
                MembersSimpleTableModel.this.logFine("Returned " + map);
                if (!this.refreshFor.equals(MembersSimpleTableModel.this.folder)) {
                    MembersSimpleTableModel.this.logFine("Folder has changed. discard result.");
                    return;
                }
                MembersSimpleTableModel.this.permissionsRetrieved = true;
                MembersSimpleTableModel.this.rebuild(map, this.defaultPermission);
            }
            catch (Exception exception) {
                MembersSimpleTableModel.this.logWarning(exception.toString());
                MembersSimpleTableModel.this.permissionsRetrieved = false;
                MembersSimpleTableModel.this.rebuild(new HashMap(), null);
            }
            finally {
                MembersSimpleTableModel.this.refreshingModel.setValue(Boolean.FALSE);
            }
        }
    }

    private class DefaultPermissionSetter
    extends SwingWorker<Void, Void> {
        private FolderInfo folderInfo;
        private FolderPermission newPermission;

        public DefaultPermissionSetter(FolderInfo folderInfo, FolderPermission folderPermission) {
            Reject.ifNull(folderInfo, "Folder info is null");
            this.folderInfo = folderInfo;
            this.newPermission = folderPermission;
        }

        @Override
        protected Void doInBackground() throws Exception {
            MembersSimpleTableModel.this.logInfo("Setting new default permission: " + this.newPermission);
            MembersSimpleTableModel.this.getController().getOSClient().getSecurityService(this.folderInfo).setDefaultPermission(this.folderInfo, this.newPermission);
            MembersSimpleTableModel.this.getController().getFolderRepository().triggerSynchronizeAllFolderMemberships();
            return null;
        }

        @Override
        protected void done() {
            MembersSimpleTableModel.this.refreshModel();
        }
    }
}

