/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.members;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.ui.information.folder.members.FolderMember;
import de.dal33t.powerfolder.ui.information.folder.members.MembersExpertTableModel;
import de.dal33t.powerfolder.ui.render.SortedTableHeaderRenderer;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MembersExpertTable
extends JTable {
    private DefaultCellEditor cellEditor;

    public MembersExpertTable(MembersExpertTableModel membersExpertTableModel) {
        super(membersExpertTableModel);
        this.setRowHeight(Icons.getIconById("node_friend_connected.icon").getIconHeight() + 3);
        this.setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        this.setupColumns();
        this.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        MemberTableCellRenderer memberTableCellRenderer = new MemberTableCellRenderer();
        this.setDefaultRenderer(FolderMember.class, memberTableCellRenderer);
        this.setDefaultRenderer(FolderPermission.class, memberTableCellRenderer);
        this.setDefaultRenderer(String.class, memberTableCellRenderer);
        SortedTableHeaderRenderer.associateHeaderRenderer(membersExpertTableModel, this.getColumnModel(), 1, true);
        this.cellEditor = new DefaultCellEditor(this.createdEditComboBox(membersExpertTableModel));
        this.setDefaultEditor(FolderPermission.class, this.cellEditor);
    }

    void cancelCellEditing() {
        if (this.cellEditor != null) {
            this.cellEditor.cancelCellEditing();
        }
    }

    private void setupColumns() {
        int n = this.getWidth();
        this.getTableHeader().setPreferredSize(new Dimension(n, 20));
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        tableColumn.setPreferredWidth(28);
        tableColumn.setMinWidth(28);
        tableColumn.setMaxWidth(28);
        tableColumn = this.getColumn(this.getColumnName(1));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.getColumn(this.getColumnName(2));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.getColumn(this.getColumnName(3));
        tableColumn.setPreferredWidth(20);
        tableColumn = this.getColumn(this.getColumnName(5));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.getColumn(this.getColumnName(4));
        tableColumn.setPreferredWidth(100);
    }

    private JComboBox createdEditComboBox(final MembersExpertTableModel membersExpertTableModel) {
        return BasicComponentFactory.createComboBox(membersExpertTableModel.getPermissionsListModel(), new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof FolderPermission) {
                    this.setText(((FolderPermission)object).getName());
                } else {
                    FolderMember folderMember;
                    int n2 = MembersExpertTable.this.getSelectedRow();
                    FolderMember folderMember2 = folderMember = n2 >= 0 ? membersExpertTableModel.getFolderMemberAt(n2) : null;
                    if (folderMember != null && folderMember.getMember() == null) {
                        this.setText(Translation.get("permissions.folder.no_access"));
                    } else {
                        FolderPermission folderPermission = membersExpertTableModel.getDefaultPermission();
                        if (folderPermission != null) {
                            this.setText(folderPermission.getName() + " (" + Translation.get("permissions.folder.default") + ")");
                        } else {
                            this.setText(Translation.get("permissions.folder.no_access") + " (" + Translation.get("permissions.folder.default") + ")");
                        }
                    }
                }
                return component;
            }
        });
    }

    private class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                TableModel tableModel = jTableHeader.getTable().getModel();
                if (tableModel instanceof MembersExpertTableModel) {
                    MembersExpertTableModel membersExpertTableModel = (MembersExpertTableModel)tableModel;
                    membersExpertTableModel.sortBy(n2);
                }
            }
        }
    }

    private class MemberTableCellRenderer
    extends DefaultTableCellRenderer {
        private MemberTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3;
            int n3 = UIUtil.toModel(jTable, n2);
            MembersExpertTableModel membersExpertTableModel = (MembersExpertTableModel)MembersExpertTable.this.getModel();
            FolderMember folderMember = membersExpertTableModel.getFolderMemberAt(n);
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setEnabled(true);
            this.setIcon(null);
            this.setForeground(ColorUtil.getTextForegroundColor());
            boolean bl4 = bl3 = folderMember.getMember() != null && folderMember.getMember().isServer();
            if (n3 == 0) {
                Icon icon = null;
                if (folderMember.getGroupInfo() != null) {
                    icon = Icons.getIconById("node_group.icon");
                } else {
                    Member member = folderMember.getMember();
                    icon = Icons.getIconFor(member);
                }
                this.setIcon(icon);
                this.setText("");
            } else if (n3 == 1) {
                if (folderMember.getGroupInfo() != null) {
                    this.setText("");
                } else if (folderMember.getMember() != null) {
                    this.setText(folderMember.getMember().getNick());
                } else {
                    this.setText(Translation.get("folder_member.not_syncing"));
                    this.setForeground(Color.GRAY);
                }
            } else if (n3 == 2) {
                if (!membersExpertTableModel.getController().getOSClient().isConnected()) {
                    this.setText(Translation.get("folder_member.not_connected_to_server"));
                    this.setForeground(Color.GRAY);
                } else if (bl3) {
                    this.setText(Translation.get("folder_member.server"));
                    this.setForeground(Color.GRAY);
                } else if (folderMember.getAccountInfo() != null) {
                    this.setText(folderMember.getAccountInfo().getDisplayName());
                } else if (folderMember.getGroupInfo() != null) {
                    this.setText(folderMember.getGroupInfo().getDisplayName());
                } else {
                    this.setText(Translation.get("folder_member.not_logged_in"));
                    this.setForeground(Color.GRAY);
                }
            } else if (n3 == 5) {
                boolean bl5 = membersExpertTableModel.isCellEditable(n, n2);
                if (!bl5) {
                    this.setForeground(Color.GRAY);
                }
                if (!membersExpertTableModel.isPermissionsRetrieved()) {
                    this.setText("");
                } else if (bl3) {
                    this.setText(Translation.get("permissions.folder.read_write"));
                } else {
                    Object object2;
                    FolderPermission folderPermission = membersExpertTableModel.getDefaultPermission();
                    if (folderMember.getPermission() != null) {
                        object2 = folderMember.getPermission().getName();
                    } else if (folderPermission != null) {
                        object2 = folderPermission.getName();
                        object2 = (String)object2 + " (";
                        object2 = (String)object2 + Translation.get("permissions.folder.default");
                        object2 = (String)object2 + ")";
                    } else {
                        object2 = Translation.get("permissions.folder.no_access");
                    }
                    this.setText((String)object2);
                }
            }
            if (!bl) {
                this.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
            }
            return component;
        }
    }
}

