/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files.table;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.ui.information.folder.files.table.FilesTableModel;
import de.dal33t.powerfolder.ui.render.SortedTableHeaderRenderer;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FilesTable
extends JTable {
    private static final Color AVAILABLE = Color.GRAY;
    private static final Color DOWNLOADING = new Color(40, 170, 40);
    private static final Color DELETED = Color.RED;
    private static final Color NORMAL = Color.BLACK;
    private static final Color NEWER_AVAILABLE = Color.BLUE;

    public FilesTable(FilesTableModel filesTableModel) {
        super(filesTableModel);
        this.setRowHeight(Icons.getIconById("node_friend_connected.icon").getIconHeight() + 3);
        this.setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        this.setupColumns();
        this.setDefaultRenderer(FileInfo.class, new MyDefaultTreeCellRenderer(filesTableModel.getController()));
        this.setDefaultRenderer(DirectoryInfo.class, new MyDefaultTreeCellRenderer(filesTableModel.getController()));
        this.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        SortedTableHeaderRenderer.associateHeaderRenderer(filesTableModel, this.getColumnModel(), 1, true);
    }

    private void setupColumns() {
        int n = this.getWidth();
        this.getTableHeader().setPreferredSize(new Dimension(n, 20));
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        tableColumn.setPreferredWidth(20);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn = this.getColumn(this.getColumnName(1));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.getColumn(this.getColumnName(2));
        tableColumn.setPreferredWidth(70);
        if (ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(((FilesTableModel)this.getModel()).getController()).booleanValue()) {
            tableColumn = this.getColumn(this.getColumnName(3));
            tableColumn.setPreferredWidth(70);
            tableColumn = this.getColumn(this.getColumnName(4));
            tableColumn.setPreferredWidth(60);
        } else {
            tableColumn = this.getColumn(this.getColumnName(3));
            tableColumn.setPreferredWidth(60);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int[] nArray = this.getSelectedRows();
        super.tableChanged(tableModelEvent);
        FilesTableModel filesTableModel = (FilesTableModel)this.getModel();
        if (!filesTableModel.isSignificantlyChanged()) {
            for (int n : nArray) {
                this.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    }

    private static class MyDefaultTreeCellRenderer
    extends DefaultTableCellRenderer {
        private Controller controller;

        private MyDefaultTreeCellRenderer(Controller controller) {
            this.controller = controller;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Object object3;
            Serializable serializable;
            DiskItem diskItem = (DiskItem)object;
            String string = "";
            boolean bl3 = false;
            if (diskItem instanceof DirectoryInfo) {
                serializable = (DirectoryInfo)diskItem;
                object3 = ((FileInfo)serializable).getFolder(this.controller.getFolderRepository());
                string = "";
                this.setIcon(null);
                switch (n2) {
                    case 0: {
                        object2 = Icons.getIconById("directory.icon");
                        this.setIcon((Icon)object2);
                        this.setHorizontalAlignment(2);
                        break;
                    }
                    case 1: {
                        string = ((FileInfo)serializable).getFilenameOnly();
                        if (((Folder)object3).getDiskItemFilter().isExcluded((DiskItem)((Object)serializable))) {
                            this.setForeground(NORMAL);
                            bl3 = true;
                        } else if (((FileInfo)serializable).isDeleted()) {
                            this.setForeground(DELETED);
                            this.setIcon(null);
                        } else if (((FileInfo)serializable).isExpected(this.controller.getFolderRepository())) {
                            this.setForeground(AVAILABLE);
                            this.setIcon(Icons.getIconById("expected.icon"));
                        } else {
                            this.setForeground(NORMAL);
                        }
                        this.setHorizontalAlignment(2);
                    }
                }
            } else if (diskItem instanceof FileInfo) {
                serializable = (FileInfo)diskItem;
                object3 = this.controller.getFolderRepository().getFolder(((FileInfo)serializable).getFolderInfo());
                this.setIcon(null);
                this.setForeground(NORMAL);
                switch (n2) {
                    case 0: {
                        object2 = Icons.getIconFor((FileInfo)serializable, this.controller);
                        this.setIcon((Icon)object2);
                        this.setHorizontalAlignment(2);
                        break;
                    }
                    case 1: {
                        string = ((FileInfo)serializable).getFilenameOnly();
                        Path path = ((FileInfo)serializable).getDiskFile(this.controller.getFolderRepository());
                        if (path != null && Files.notExists(path, new LinkOption[0])) {
                            path = null;
                        }
                        String string2 = path != null ? MyDefaultTreeCellRenderer.replaceSpacesWithNBSP(path.toAbsolutePath().toString()) : MyDefaultTreeCellRenderer.replaceSpacesWithNBSP(((FileInfo)serializable).getFilenameOnly());
                        FileInfo fileInfo = null;
                        FileInfo fileInfo2 = null;
                        if (((FileInfo)serializable).getFolder(this.controller.getFolderRepository()) != null) {
                            fileInfo = ((FileInfo)serializable).getNewestNotDeletedVersion(this.controller.getFolderRepository());
                            fileInfo2 = ((FileInfo)serializable).getNewestVersion(this.controller.getFolderRepository());
                        }
                        this.setIcon(null);
                        String string3 = null;
                        if (((FileInfo)serializable).isDownloading(this.controller)) {
                            this.setForeground(DOWNLOADING);
                            DownloadManager downloadManager = this.controller.getTransferManager().getActiveDownload((FileInfo)serializable);
                            if (downloadManager != null && downloadManager.isStarted()) {
                                StringBuilder stringBuilder = new StringBuilder();
                                for (Download download : downloadManager.getSources()) {
                                    if (stringBuilder.length() > 0) {
                                        stringBuilder.append(", ");
                                    }
                                    stringBuilder.append(download.getPartner().getNick());
                                }
                                this.setIcon(Icons.getIconById("download_active.icon"));
                                string3 = Translation.get("file_info.downloading_from_member", stringBuilder.toString());
                            } else {
                                this.setIcon(Icons.getIconById("download.icon"));
                                string3 = Translation.get("transfers.queued");
                            }
                        } else if (((FileInfo)serializable).isDeleted()) {
                            this.setForeground(DELETED);
                            this.setIcon(null);
                            string3 = Translation.get("file_info.deleted");
                        } else if (object3 != null && ((Folder)object3).getDiskItemFilter().isExcluded((DiskItem)((Object)serializable))) {
                            string3 = MyDefaultTreeCellRenderer.replaceSpacesWithNBSP(Translation.get("file_info.ignore"));
                            bl3 = true;
                        } else if (((FileInfo)serializable).isExpected(this.controller.getFolderRepository())) {
                            this.setForeground(AVAILABLE);
                            this.setIcon(Icons.getIconById("expected.icon"));
                            string3 = Translation.get("file_info.expected");
                        } else if (fileInfo != null && fileInfo.isNewerThan((FileInfo)serializable)) {
                            this.setForeground(NEWER_AVAILABLE);
                            if (fileInfo.isDeleted()) {
                                if (fileInfo.equals(fileInfo2) && SyncProfile.MANUAL_SYNCHRONIZATION.equals(((Folder)object3).getSyncProfile())) {
                                    this.setIcon(Icons.getIconById("delete.icon"));
                                    string3 = Translation.get("file_info.remote_deleted");
                                }
                            } else {
                                this.setIcon(Icons.getIconById("expected.icon"));
                                string3 = Translation.get("file_info.new_version_available");
                            }
                        } else if (this.recentlyDownloaded((FileInfo)serializable)) {
                            string3 = Translation.get("file_info.recently_downloaded");
                        }
                        this.setToolTipText(MyDefaultTreeCellRenderer.getToolTip((FileInfo)serializable, string2, string3));
                        this.setHorizontalAlignment(2);
                        break;
                    }
                    case 2: {
                        string = Format.formatBytesShort(((FileInfo)serializable).getSize());
                        this.setToolTipText(Format.formatBytes(((FileInfo)serializable).getSize()));
                        this.setHorizontalAlignment(4);
                        break;
                    }
                    case 3: {
                        if (!ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(this.controller).booleanValue()) break;
                        MemberInfo memberInfo = ((FileInfo)serializable).getModifiedBy();
                        AccountInfo accountInfo = ((FileInfo)serializable).getModifiedByAccount();
                        String string4 = string = accountInfo != null ? accountInfo.getDisplayName() : "";
                        if (!memberInfo.getNode(this.controller, true).isServer()) {
                            this.setToolTipText(string + " on " + memberInfo.nick);
                        }
                        this.setHorizontalAlignment(2);
                        break;
                    }
                    case 4: {
                        string = Format.formatDateShort(((FileInfo)serializable).getModifiedDate());
                        this.setHorizontalAlignment(4);
                    }
                }
            }
            serializable = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            if (diskItem != null && diskItem.isFile() && this.recentlyDownloaded((FileInfo)diskItem)) {
                ((Component)serializable).setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
            }
            if (!bl) {
                this.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
            }
            if (bl3) {
                object3 = ((Component)serializable).getFont();
                object2 = ((Font)object3).getAttributes();
                object2.put(TextAttribute.STRIKETHROUGH, true);
                ((Component)serializable).setFont(new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object2));
            }
            return serializable;
        }

        private boolean recentlyDownloaded(FileInfo fileInfo) {
            return this.controller.getTransferManager().isCompletedDownload(fileInfo);
        }

        private static String replaceSpacesWithNBSP(String string) {
            return string.replaceAll(" ", "&nbsp;");
        }

        private static String getToolTip(FileInfo fileInfo, String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder("<HTML><HEAD>");
            stringBuilder.append("<style TYPE=\"text/css\"><!--BODY {  font-size: 10px; color: #000000; background : #FFFFFF; }");
            stringBuilder.append(".normal { font-size: 10px; color: #000000;}");
            stringBuilder.append(".deleted { font-size: 10px; color: #FF0000;font-weight: bold;}");
            stringBuilder.append(".new_avail { font-size: 10px; color: #0000FF;font-weight: bold;}");
            stringBuilder.append(".bold { font-size: 10px; color: #000000;font-weight: bold;}");
            stringBuilder.append("--></style>");
            stringBuilder.append("</HEAD><BODY>");
            stringBuilder.append("<TABLE cellspacing=0 cellpadding=0 border=0>");
            if (!StringUtils.isBlank(string)) {
                stringBuilder.append("<TR><TD valign=top class=bold colspan=2>&nbsp;" + string + "&nbsp;</TD></TR>");
            }
            if (!StringUtils.isBlank(string2)) {
                String string3 = string2.equals(Translation.get("file_info.deleted")) ? "deleted" : (string2.equals(Translation.get("file_info.new_version_available")) ? "new_avail" : "bold");
                stringBuilder.append("<TR><TD valign=top class=" + string3 + " colspan=2>&nbsp;" + string2 + "&nbsp;</TD></TR>");
            }
            stringBuilder.append("</TABLE>");
            stringBuilder.append("<!-- " + fileInfo.getFilenameOnly() + "-->");
            stringBuilder.append("</BODY></HTML>");
            return stringBuilder.toString();
        }
    }

    private static class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                FilesTableModel filesTableModel;
                boolean bl;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                TableModel tableModel = jTableHeader.getTable().getModel();
                if (tableModel instanceof FilesTableModel && !(bl = (filesTableModel = (FilesTableModel)tableModel).sortBy(n2))) {
                    filesTableModel.reverseList();
                }
            }
        }
    }
}

