/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.dao.FileInfoCriteria;
import de.dal33t.powerfolder.disk.dao.FileInfoDAO;
import de.dal33t.powerfolder.event.FolderAdapter;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.ui.FilterModel;
import de.dal33t.powerfolder.ui.information.folder.files.DirectoryFilterListener;
import de.dal33t.powerfolder.ui.information.folder.files.DirectoryFilterResult;
import de.dal33t.powerfolder.ui.information.folder.files.FilteredDirectory;
import de.dal33t.powerfolder.ui.information.folder.files.FilteredDirectoryEvent;
import de.dal33t.powerfolder.ui.information.folder.files.FilteredDirectoryModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectoryFilter
extends FilterModel {
    public static final int FILE_FILTER_MODE_LOCAL_AND_INCOMING = 0;
    public static final int FILE_FILTER_MODE_LOCAL_ONLY = 1;
    public static final int FILE_FILTER_MODE_NEW_ONLY = 2;
    public static final int FILE_FILTER_MODE_DELETED_PREVIOUS = 3;
    public static final int FILE_FILTER_MODE_UNSYNCHRONIZED = 4;
    public static final int SEARCH_MODE_FILE_NAME_DIRECTORY_NAME = 10;
    public static final int SEARCH_MODE_FILE_NAME_ONLY = 11;
    public static final int SEARCH_MODE_MODIFIER = 12;
    public static final int SEARCH_MODE_COMPUTER = 13;
    private Folder folder;
    private DirectoryInfo currentDirectoryInfo;
    private int fileFilterMode;
    private final MyFolderListener folderListener;
    private final AtomicBoolean running;
    private final AtomicBoolean pending;
    private final TransferManager transferManager;
    private final List<DirectoryFilterListener> listeners;
    private final AtomicBoolean refilter = new AtomicBoolean();
    private final ValueModel lastFolderName = new ValueHolder("");
    private final ValueModel searchModeVM;

    public DirectoryFilter(Controller controller, ValueModel valueModel, ValueModel valueModel2) {
        super(controller, valueModel);
        this.searchModeVM = valueModel2;
        valueModel2.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DirectoryFilter.this.queueFilterEvent();
            }
        });
        this.folderListener = new MyFolderListener();
        this.running = new AtomicBoolean();
        this.pending = new AtomicBoolean();
        this.transferManager = this.getController().getTransferManager();
        this.listeners = new CopyOnWriteArrayList<DirectoryFilterListener>();
    }

    public void addListener(DirectoryFilterListener directoryFilterListener) {
        this.listeners.add(directoryFilterListener);
    }

    @Override
    public void preScheduleFiltering() {
        this.refilter.set(true);
    }

    public void removeListener(DirectoryFilterListener directoryFilterListener) {
        this.listeners.remove(directoryFilterListener);
    }

    public ValueModel getSearchModeVM() {
        return this.searchModeVM;
    }

    public DirectoryInfo getCurrentDirectoryInfo() {
        return this.currentDirectoryInfo;
    }

    public void setFolder(Folder folder, DirectoryInfo directoryInfo) {
        boolean bl;
        boolean bl2 = bl = this.folder == null || !this.folder.equals(folder);
        if (bl && this.folder != null) {
            this.folder.removeFolderListener(this.folderListener);
        }
        this.folder = folder;
        boolean bl3 = this.currentDirectoryInfo != null && !this.currentDirectoryInfo.equals(directoryInfo);
        this.currentDirectoryInfo = directoryInfo;
        if (bl) {
            folder.addFolderListener(this.folderListener);
            for (DirectoryFilterListener directoryFilterListener : this.listeners) {
                directoryFilterListener.invalidate();
            }
        }
        if (bl3 || bl) {
            this.refilter.set(true);
            this.queueFilterEvent();
        }
    }

    public void setFileFilterMode(int n) {
        int n2 = this.fileFilterMode;
        if (n2 != n) {
            this.fileFilterMode = n;
            this.refilter.set(true);
            this.logFine("Set filter mode to " + n);
            this.queueFilterEvent();
        }
    }

    @Override
    public void scheduleFiltering() {
        this.logFine("Set search field to " + this.getSearchFieldVM());
        this.queueFilterEvent();
    }

    private void queueFilterEvent() {
        if (this.folder == null) {
            return;
        }
        if (this.running.get()) {
            this.pending.set(true);
        } else {
            this.fireFilterEvent();
        }
    }

    private void fireFilterEvent() {
        this.logFine("Firing filter even for folder " + this.folder);
        this.running.set(true);
        this.getController().getThreadPool().execute(() -> {
            while (true) {
                this.doFilter();
                if (!this.pending.get()) break;
                this.pending.set(false);
            }
            this.running.set(false);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter() {
        FilteredDirectory filteredDirectory;
        FilteredDirectoryModel filteredDirectoryModel;
        if (this.folder == null || this.currentDirectoryInfo == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (DirectoryFilterListener directoryFilterListener : DirectoryFilter.this.listeners) {
                    directoryFilterListener.adviseOfFilteringBegin();
                }
            }
        };
        try {
            UIUtil.invokeAndWaitInEDT(runnable);
        }
        catch (InterruptedException interruptedException) {
            this.logWarning(interruptedException.toString());
            return;
        }
        Date date = new Date();
        if (this.isFiner()) {
            this.logFiner("Starting filter of " + this.folder.getName());
        }
        String string = (String)this.getSearchFieldVM().getValue();
        String[] stringArray = null;
        if (!StringUtils.isBlank(string)) {
            stringArray = string.split("\\s+");
        }
        final DirectoryFilterResult directoryFilterResult = new DirectoryFilterResult();
        AtomicBoolean atomicBoolean = this.refilter;
        synchronized (atomicBoolean) {
            Date date2 = null;
            if (this.fileFilterMode == 4) {
                date2 = new Date(System.currentTimeMillis() - (long)ConfigurationEntry.MAX_FILEINFO_DELETED_AGE_SECONDS.getValueInt(this.getController()).intValue());
            }
            filteredDirectoryModel = new FilteredDirectoryModel(this.folder.getName(), this.currentDirectoryInfo.getRelativeName(), date2);
            filteredDirectory = filteredDirectoryModel.getFilteredDirectory();
        }
        if (filteredDirectory != null) {
            if (this.isFlatMode()) {
                this.filterDirectoryFlat(this.folder.getDAO(), this.currentDirectoryInfo, filteredDirectoryModel, stringArray, directoryFilterResult, this.currentDirectoryInfo.getRelativeName().length() == 0);
            } else {
                this.filterDirectory(this.folder.getDAO(), this.currentDirectoryInfo, filteredDirectoryModel, stringArray, directoryFilterResult);
            }
        }
        final boolean bl = !this.folder.getName().equals(this.lastFolderName.getValue());
        this.lastFolderName.setValue(this.folder.getName());
        final boolean bl2 = this.fileFilterMode == 0 && !this.isFlatMode() && StringUtils.isBlank(string);
        runnable = new Runnable(){

            @Override
            public void run() {
                FilteredDirectoryEvent filteredDirectoryEvent = new FilteredDirectoryEvent(directoryFilterResult.getDeletedCount().get(), directoryFilterResult.getIncomingCount().get(), directoryFilterResult.getLocalCount().get(), filteredDirectoryModel, bl, DirectoryFilter.this.fileFilterMode, bl2);
                for (DirectoryFilterListener directoryFilterListener : DirectoryFilter.this.listeners) {
                    directoryFilterListener.adviseOfChange(filteredDirectoryEvent);
                }
            }
        };
        try {
            UIUtil.invokeAndWaitInEDT(runnable);
        }
        catch (InterruptedException interruptedException) {
            this.logWarning(interruptedException.toString());
            return;
        }
        Date date3 = new Date();
        this.logFine("Filtered " + this.folder.getName() + ", original count " + directoryFilterResult.getOriginalCount().get() + ", filtered count " + directoryFilterResult.getFilteredCount().get() + " in " + (date3.getTime() - date.getTime()) + "ms");
    }

    private void filterDirectoryFlat(FileInfoDAO fileInfoDAO, DirectoryInfo directoryInfo, FilteredDirectoryModel filteredDirectoryModel, String[] stringArray, DirectoryFilterResult directoryFilterResult, boolean bl) {
        boolean bl2 = this.currentDirectoryInfo.getRelativeName().equals(directoryInfo.getRelativeName());
        FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
        fileInfoCriteria.addWriteMembersAndMyself(this.folder);
        fileInfoCriteria.setPath(directoryInfo);
        fileInfoCriteria.setRecursive(true);
        fileInfoCriteria.setType(FileInfoCriteria.Type.FILES_ONLY);
        Collection<FileInfo> collection = fileInfoDAO.findFiles(fileInfoCriteria);
        for (FileInfo fileInfo : collection) {
            if (fileInfo instanceof DirectoryInfo) continue;
            this.filterFileInfo(filteredDirectoryModel, stringArray, directoryFilterResult, fileInfo, bl || bl2);
        }
    }

    private void filterDirectory(FileInfoDAO fileInfoDAO, DirectoryInfo directoryInfo, FilteredDirectoryModel filteredDirectoryModel, String[] stringArray, DirectoryFilterResult directoryFilterResult) {
        boolean bl = this.currentDirectoryInfo.getRelativeName().equals(directoryInfo.getRelativeName());
        FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
        fileInfoCriteria.addWriteMembersAndMyself(this.folder);
        fileInfoCriteria.setPath(directoryInfo);
        Collection<FileInfo> collection = fileInfoDAO.findFiles(fileInfoCriteria);
        for (FileInfo fileInfo : collection) {
            if (fileInfo instanceof DirectoryInfo) {
                Object object;
                if (!fileInfo.isDeleted()) {
                    try {
                        object = fileInfo.getDiskFile(this.getController().getFolderRepository());
                        if (!PreferencesEntry.SHOW_HIDDEN_FILES.getValueBoolean(this.getController()).booleanValue() && Files.isHidden((Path)object)) {
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        this.logFine("Unable to access: " + iOException.toString());
                        continue;
                    }
                }
                object = (DirectoryInfo)fileInfo;
                if (!bl || !(this.fileFilterMode != 3 ^ ((FileInfo)object).isDeleted())) continue;
                filteredDirectoryModel.addFileInfo((FileInfo)object);
                continue;
            }
            this.filterFileInfo(filteredDirectoryModel, stringArray, directoryFilterResult, fileInfo, bl);
        }
    }

    private void filterFileInfo(FilteredDirectoryModel filteredDirectoryModel, String[] stringArray, DirectoryFilterResult directoryFilterResult, FileInfo fileInfo, boolean bl) {
        boolean bl2;
        directoryFilterResult.getOriginalCount().incrementAndGet();
        int n = (Integer)this.searchModeVM.getValue();
        boolean bl3 = fileInfo.isDeleted();
        if (!bl3) {
            try {
                if (!PreferencesEntry.SHOW_HIDDEN_FILES.getValueBoolean(this.getController()).booleanValue() && Files.isHidden(fileInfo.getDiskFile(this.getController().getFolderRepository()))) {
                    return;
                }
            }
            catch (IOException iOException) {
                this.logFine("Unable to access: " + iOException.toString());
            }
        }
        boolean bl4 = true;
        if (stringArray != null) {
            bl4 = this.matches(fileInfo, stringArray, n);
        }
        FileInfo fileInfo2 = null;
        if (fileInfo.getFolder(this.getController().getFolderRepository()) != null) {
            fileInfo2 = fileInfo.getNewestNotDeletedVersion(this.getController().getFolderRepository());
        }
        boolean bl5 = bl2 = fileInfo.isDownloading(this.getController()) || fileInfo.isExpected(this.getController().getFolderRepository()) || fileInfo2 != null && fileInfo2.isNewerThan(fileInfo);
        if (!bl4) {
            return;
        }
        boolean bl6 = this.transferManager.isCompletedDownload(fileInfo);
        switch (this.fileFilterMode) {
            case 1: {
                bl4 = !bl2 && !bl3;
                break;
            }
            case 2: {
                bl4 = bl6;
                break;
            }
            case 3: {
                bl4 = bl3;
                break;
            }
            case 4: {
                if (this.folder.getDiskItemFilter().isExcluded(fileInfo)) {
                    bl4 = false;
                    break;
                }
                bl4 = bl2 || !this.isSynchronized(fileInfo);
                break;
            }
            default: {
                boolean bl7 = bl4 = !bl3;
            }
        }
        if (bl4 && bl && filteredDirectoryModel.addFileInfo(fileInfo)) {
            directoryFilterResult.getFilteredCount().incrementAndGet();
        }
        if (bl) {
            if (bl3) {
                directoryFilterResult.getDeletedCount().incrementAndGet();
            } else if (bl2) {
                directoryFilterResult.getIncomingCount().incrementAndGet();
            } else {
                directoryFilterResult.getLocalCount().incrementAndGet();
            }
        }
    }

    private boolean isSynchronized(FileInfo fileInfo) {
        Folder folder = fileInfo.getFolder(this.getController().getFolderRepository());
        if (folder == null) {
            return true;
        }
        boolean bl = true;
        for (Member member : folder.getConnectedMembers()) {
            FileInfo fileInfo2 = member.getFile(fileInfo);
            if (fileInfo2 != null && fileInfo2.getVersion() == fileInfo.getVersion()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean matches(FileInfo fileInfo, String[] stringArray, int n) {
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                if ((string = string.substring(1)).length() == 0 || !this.matchFileInfo(fileInfo, string, n)) continue;
                return true;
            }
            if (this.matchFileInfo(fileInfo, string, n)) continue;
            return false;
        }
        return true;
    }

    private boolean matchFileInfo(FileInfo fileInfo, String string, int n) {
        if (n == 10) {
            String string2 = fileInfo.getLowerCaseFilenameOnly().toLowerCase();
            if (string2.contains(string.toLowerCase())) {
                return true;
            }
        } else if (n == 11) {
            String string3 = fileInfo.getFilenameOnly().toLowerCase();
            if (string3.contains(string.toLowerCase())) {
                return true;
            }
        } else if (n == 12) {
            Member member;
            MemberInfo memberInfo = fileInfo.getModifiedBy();
            if (memberInfo != null && (member = memberInfo.getNode(this.getController(), false)) != null && member.getNick().toLowerCase().contains(string.toLowerCase())) {
                return true;
            }
        } else if (n == 13) {
            FileInfo fileInfo2 = this.folder.getDAO().find(fileInfo, string);
            return fileInfo2 != null;
        }
        return false;
    }

    private class MyFolderListener
    extends FolderAdapter {
        private MyFolderListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void fileChanged(FolderEvent folderEvent) {
            this.checkAndQueue(folderEvent);
        }

        @Override
        public void filesDeleted(FolderEvent folderEvent) {
            this.checkAndQueue(folderEvent);
        }

        @Override
        public void remoteContentsChanged(FolderEvent folderEvent) {
            if (folderEvent.getMember().hasCompleteFileListFor(folderEvent.getFolder().getInfo())) {
                this.checkAndQueue(folderEvent);
            }
        }

        @Override
        public void scanResultCommitted(FolderEvent folderEvent) {
            if (folderEvent.getScanResult().isChangeDetected()) {
                this.checkAndQueue(folderEvent);
            }
        }

        private void checkAndQueue(FolderEvent folderEvent) {
            if (folderEvent.getFolder().getInfo().equals(DirectoryFilter.this.folder.getInfo())) {
                DirectoryFilter.this.queueFilterEvent();
            }
        }
    }
}

