/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.downloads;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.information.downloads.DownloadManagersTable;
import de.dal33t.powerfolder.ui.information.downloads.DownloadManagersTableModel;
import de.dal33t.powerfolder.ui.model.TransferManagerModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.ActivityVisualizationWorker;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DownloadsTablePanel
extends PFUIComponent {
    private JPanel uiComponent;
    private JScrollPane tablePane;
    private DownloadManagersTable table;
    private DownloadManagersTableModel tableModel;
    private Action openDownloadAction;
    private Action abortDownloadsAction;
    private Action clearCompletedDownloadsAction;
    private Action addIgnoreAction;
    private JPopupMenu fileMenu;

    public DownloadsTablePanel(Controller controller, Action action, Action action2, Action action3, Action action4) {
        super(controller);
        this.openDownloadAction = action;
        this.abortDownloadsAction = action2;
        this.clearCompletedDownloadsAction = action3;
        this.addIgnoreAction = action4;
    }

    public JComponent getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    private void initialize() {
        TransferManagerModel transferManagerModel = this.getUIController().getTransferManagerModel();
        this.table = new DownloadManagersTable(transferManagerModel);
        this.table.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this.tablePane = new JScrollPane(this.table);
        this.tableModel = (DownloadManagersTableModel)this.table.getModel();
        this.table.addMouseListener(new TableMouseListener());
        this.table.registerKeyboardAction(new SelectAllAction(), KeyStroke.getKeyStroke(65, 2), 0);
        UIUtil.whiteStripTable(this.table);
        UIUtil.setZeroHeight(this.tablePane);
        UIUtil.removeBorder(this.tablePane);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getUIComponent();
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.getUIComponent();
        this.tableModel.addTableModelListener(tableModelListener);
    }

    private void buildUIComponent() {
        FormLayout formLayout = new FormLayout("fill:pref:grow", "fill:0:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.tablePane, cellConstraints.xy(1, 1));
        this.buildPopupMenus();
        this.uiComponent = panelBuilder.getPanel();
    }

    private void buildPopupMenus() {
        this.fileMenu = new JPopupMenu();
        this.fileMenu.add(this.openDownloadAction);
        this.fileMenu.add(this.abortDownloadsAction);
        this.fileMenu.add(this.clearCompletedDownloadsAction);
        this.fileMenu.add(this.addIgnoreAction);
    }

    public void clearDownloads() {
        ActivityVisualizationWorker activityVisualizationWorker = new ActivityVisualizationWorker(this.getUIController()){

            @Override
            protected String getTitle() {
                return Translation.get("downloads_panel.cleanup_activity.title");
            }

            @Override
            protected String getWorkingText() {
                return Translation.get("downloads_panel.cleanup_activity.description");
            }

            @Override
            public Object construct() {
                int n = DownloadsTablePanel.this.table.getRowCount();
                if (n == 0) {
                    return null;
                }
                boolean bl = true;
                for (int i = 0; i < DownloadsTablePanel.this.table.getRowCount(); ++i) {
                    if (!DownloadsTablePanel.this.table.isRowSelected(i)) continue;
                    bl = false;
                    break;
                }
                ArrayList<DownloadManager> arrayList = new ArrayList<DownloadManager>();
                block1: for (int i = 0; i < DownloadsTablePanel.this.table.getRowCount(); ++i) {
                    if (!bl && !DownloadsTablePanel.this.table.isRowSelected(i)) continue;
                    DownloadManager downloadManager = DownloadsTablePanel.this.tableModel.getDownloadManagerAtRow(i);
                    if (downloadManager.isCompleted()) {
                        arrayList.add(downloadManager);
                        continue;
                    }
                    for (Download download : downloadManager.getSources()) {
                        if (!download.isBroken()) continue;
                        arrayList.add(downloadManager);
                        continue block1;
                    }
                }
                for (DownloadManager downloadManager : arrayList) {
                    DownloadsTablePanel.this.getController().getTransferManager().clearCompletedDownload(downloadManager);
                }
                return null;
            }
        };
        activityVisualizationWorker.start();
    }

    public boolean isRowsExist() {
        return this.table != null && this.table.getRowCount() > 0;
    }

    public boolean isIncompleteSelected() {
        boolean bl;
        if (this.table == null || this.tableModel == null) {
            return false;
        }
        int[] nArray = this.table.getSelectedRows();
        boolean bl2 = bl = nArray.length > 0;
        if (bl) {
            for (int n : nArray) {
                DownloadManager downloadManager = this.tableModel.getDownloadManagerAtRow(n);
                if (downloadManager == null || downloadManager.isCompleted()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSingleCompleteSelected() {
        DownloadManager downloadManager;
        boolean bl;
        if (this.table == null || this.tableModel == null) {
            return false;
        }
        int[] nArray = this.table.getSelectedRows();
        boolean bl2 = bl = nArray.length == 1;
        return bl && (downloadManager = this.tableModel.getDownloadManagerAtRow(nArray[0])) != null && downloadManager.isCompleted();
    }

    public void openSelectedDownload() {
        boolean bl;
        if (this.table == null || this.tableModel == null) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        boolean bl2 = bl = nArray.length == 1;
        if (bl) {
            Path path;
            DownloadManager downloadManager = this.tableModel.getDownloadManagerAtRow(nArray[0]);
            if (downloadManager == null) {
                return;
            }
            if (downloadManager.isCompleted() && (path = downloadManager.getFileInfo().getDiskFile(this.getController().getFolderRepository())) != null && Files.exists(path, new LinkOption[0])) {
                PathUtils.openFile(path);
            }
        }
    }

    public void abortSelectedDownloads() {
        boolean bl;
        if (this.table == null || this.tableModel == null) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        boolean bl2 = bl = nArray.length > 0;
        if (bl) {
            for (int n : nArray) {
                DownloadManager downloadManager = this.tableModel.getDownloadManagerAtRow(n);
                if (downloadManager == null || downloadManager.isCompleted()) continue;
                downloadManager.abort();
            }
        }
    }

    public FileInfo getSelectdFile() {
        DownloadManager downloadManager;
        if (this.table == null || this.tableModel == null) {
            return null;
        }
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 1 && (downloadManager = this.tableModel.getDownloadManagerAtRow(nArray[0])) != null) {
            return downloadManager.getFileInfo();
        }
        return null;
    }

    public int countActiveDownloadCount() {
        int n = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            DownloadManager downloadManager = this.tableModel.getDownloadManagerAtRow(i);
            if (downloadManager == null || !downloadManager.isStarted() || downloadManager.isCompleted()) continue;
            ++n;
        }
        return n;
    }

    public int countCompletedDownloadCount() {
        int n = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            DownloadManager downloadManager = this.tableModel.getDownloadManagerAtRow(i);
            if (downloadManager == null || !downloadManager.isCompleted()) continue;
            ++n;
        }
        return n;
    }

    public DownloadManager[] getSelectedRows() {
        int[] nArray = this.table.getSelectedRows();
        return this.tableModel.getDownloadManagersAtRows(nArray);
    }

    private static class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                DownloadManagersTableModel downloadManagersTableModel;
                boolean bl;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                TableModel tableModel = jTableHeader.getTable().getModel();
                if (tableModel instanceof DownloadManagersTableModel && !(bl = (downloadManagersTableModel = (DownloadManagersTableModel)tableModel).sortBy(n2))) {
                    downloadManagersTableModel.reverseList();
                }
            }
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = DownloadsTablePanel.this.table.rowAtPoint(mouseEvent.getPoint());
                DownloadManager downloadManager = DownloadsTablePanel.this.tableModel.getDownloadManagerAtRow(n);
                FileInfo fileInfo = downloadManager.getFileInfo();
                Path path = fileInfo.getDiskFile(DownloadsTablePanel.this.getController().getFolderRepository());
                if (path != null && Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
                    PathUtils.openFile(path);
                }
            }
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            DownloadsTablePanel.this.fileMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DownloadsTablePanel.this.table.selectAll();
        }
    }
}

