/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.folders;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OnlineStorageComponent
extends PFUIComponent {
    private JPanel uiComponent;
    private ActionLabel syncActionLabel;
    private JButton webButton;
    private MySyncAction syncAction;
    private Folder folder;
    private MyWebButtonAction webButtonAction;

    public OnlineStorageComponent(Controller controller, Folder folder) {
        super(controller);
        this.folder = folder;
    }

    public Component getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
            this.buildUI();
        }
        return this.uiComponent;
    }

    private void initialize() {
        this.syncAction = new MySyncAction(this.getController());
        this.syncActionLabel = new ActionLabel(this.getController(), this.syncAction);
        this.webButtonAction = new MyWebButtonAction(this.getController());
        this.webButton = new JButtonMini(this.webButtonAction);
    }

    private void buildUI() {
        FormLayout formLayout = new FormLayout("pref, pref:grow, pref", "3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(null, cellConstraints.xyw(1, 2, 3));
        panelBuilder.add((Component)this.syncActionLabel.getUIComponent(), cellConstraints.xy(1, 4));
        panelBuilder.add((Component)this.webButton, cellConstraints.xy(3, 4));
        this.uiComponent = panelBuilder.getPanel();
        this.uiComponent.setOpaque(false);
    }

    public void setSyncPercentage(double d, boolean bl, boolean bl2) {
        if (bl2) {
            this.syncActionLabel.setText(Translation.get("online_storage_component.online_storage_text", Format.formatPercent(d)).replace("%%", "%"));
            this.syncActionLabel.setForeground(bl ? Color.red : ColorUtil.getTextForegroundColor());
            this.syncActionLabel.setToolTipText(bl ? Translation.get("online_storage_component.online_storage_warning") : Translation.get("online_storage_component.online_storage_tip"));
            this.webButton.setToolTipText(Translation.get("online_storage_component.online_storage_remove"));
        } else {
            this.syncActionLabel.setText(Translation.get("online_storage_component.online_storage_unjoined_text"));
            this.syncActionLabel.setToolTipText(Translation.get("online_storage_component.online_storage_unjoined_tip"));
            this.webButton.setToolTipText(Translation.get("online_storage_component.online_storage_unjoined_tip"));
        }
        this.syncAction.setJoined(bl2);
    }

    public void setFolder(Folder folder) {
        this.folder = folder;
        if (folder != null) {
            FolderAdminPermission folderAdminPermission = FolderPermission.admin(folder.getInfo());
            this.webButtonAction.allowWith(folderAdminPermission);
            this.syncAction.allowWith(folderAdminPermission);
        }
    }

    private class MySyncAction
    extends BaseAction {
        private boolean joined;

        private MySyncAction(Controller controller) {
            super("action_sync_folder", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.joined) {
                final ServerClient serverClient = this.getController().getOSClient();
                if (serverClient.supportsWebLogin()) {
                    BrowserLauncher.open(this.getController(), new BrowserLauncher.URLProducer(){

                        @Override
                        public String url() {
                            return serverClient.getFolderURLWithCredentials(OnlineStorageComponent.this.folder.getInfo());
                        }
                    });
                }
            } else {
                PFWizard.openMirrorFolderWizard(this.getController(), OnlineStorageComponent.this.folder);
            }
        }

        public void setJoined(boolean bl) {
            this.joined = bl;
            if (bl) {
                OnlineStorageComponent.this.syncAction.allowWith(null);
                OnlineStorageComponent.this.syncAction.setEnabled(true);
            }
        }
    }

    private class MyWebButtonAction
    extends BaseAction {
        private MyWebButtonAction(Controller controller) {
            super("action_online_storage", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PFWizard.openMirrorFolderWizard(this.getController(), OnlineStorageComponent.this.folder);
        }
    }
}

