/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.event;

import de.dal33t.powerfolder.ui.event.SelectionChangeEvent;
import de.dal33t.powerfolder.ui.event.SelectionChangeListener;
import java.util.LinkedList;
import java.util.List;

public class SelectionModel {
    private Object[] selections;
    private Object[] oldSelections;
    private List<SelectionChangeListener> listeners = new LinkedList<SelectionChangeListener>();

    public SelectionModel() {
    }

    public SelectionModel(Object object) {
        this.setSelection(object);
    }

    public void setSelection(Object object) {
        if (object == null) {
            this.setSelections(null);
        } else {
            this.setSelections(new Object[]{object});
        }
    }

    public void setSelections(Object[] objectArray) {
        this.oldSelections = this.selections;
        this.selections = objectArray;
        this.fireSelectionChanged();
    }

    public Object getSelection() {
        if (this.selections == null || this.selections.length == 0) {
            return null;
        }
        return this.selections[0];
    }

    public Object[] getSelections() {
        return this.selections;
    }

    public Object getOldSelection() {
        if (this.oldSelections == null) {
            return null;
        }
        return this.oldSelections[0];
    }

    public Object[] getOldSelections() {
        return this.oldSelections;
    }

    public void addSelectionChangeListener(SelectionChangeListener selectionChangeListener) {
        this.listeners.add(selectionChangeListener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener selectionChangeListener) {
        this.listeners.remove(selectionChangeListener);
    }

    private void fireSelectionChanged() {
        for (SelectionChangeListener selectionChangeListener : this.listeners) {
            selectionChangeListener.selectionChanged(new SelectionChangeEvent(this, this.selections));
        }
    }
}

