/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.binding.value.Trigger;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.dialog.ConfigurationLoaderDialog;
import de.dal33t.powerfolder.ui.preferences.HTTPProxySettingsDialog;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

public class UIUnLockDialog
extends PFUIComponent {
    private JFrame frame;
    private JLabel serverLabel;
    private ActionLabel serverInfoLabel;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JComponent proxySettingsLabel;
    private JProgressBar progressBar;
    private JLabel infoLabel;
    private JButton okButton;
    private Object haltLock = new Object();
    private Trigger serverReloadTrigger;

    public UIUnLockDialog(Controller controller) {
        super(controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAndWait() {
        block5: {
            try {
                UIUtil.invokeAndWaitInEDT(new Runnable(){

                    @Override
                    public void run() {
                        UIUnLockDialog.this.getFrame().setVisible(true);
                    }
                });
                if (EventQueue.isDispatchThread()) break block5;
                Object object = this.haltLock;
                synchronized (object) {
                    this.haltLock.wait();
                }
            }
            catch (Exception exception) {
                this.logSevere(exception);
            }
        }
    }

    private JFrame getFrame() {
        if (this.frame == null) {
            this.initComponents();
            FormLayout formLayout = new FormLayout("p, 3dlu, p:g", "p, 7dlu, p, 0, p, 3dlu, p, 3dlu, p, 7dlu, 12dlu, 14dlu, p");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setDefaultDialogBorder();
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            panelBuilder.addLabel(Translation.get("exp.uilock.dialog.info"), cellConstraints.xyw(1, n, 3));
            this.serverLabel.setBorder(Borders.createEmptyBorder("0, 0, 3dlu, 0"));
            panelBuilder.add((Component)this.serverLabel, cellConstraints.xy(1, n += 2));
            this.serverInfoLabel.getUIComponent().setBorder(Borders.createEmptyBorder("0, 0, 3dlu, 0"));
            panelBuilder.add((Component)this.serverInfoLabel.getUIComponent(), cellConstraints.xy(3, n));
            panelBuilder.addLabel(LoginUtil.getUsernameLabel(this.getController()), cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.usernameField, cellConstraints.xy(3, n));
            panelBuilder.addLabel(Translation.get("general.password") + ":", cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.passwordField, cellConstraints.xy(3, n));
            panelBuilder.add((Component)this.proxySettingsLabel, cellConstraints.xywh(3, n += 2, 1, 1, "right, center"));
            panelBuilder.add((Component)this.progressBar, cellConstraints.xyw(1, n += 2, 3));
            panelBuilder.add((Component)this.infoLabel, cellConstraints.xyw(1, n, 3));
            Component component = this.buildButtonBar();
            panelBuilder.add(component, cellConstraints.xyw(1, n += 2, 3));
            panelBuilder.getPanel().setBackground(Color.WHITE);
            this.frame = new JFrame(this.getTitle());
            this.frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
            this.frame.setIconImage(Icons.getImageById("powerfolder_32.icon"));
            this.frame.setResizable(false);
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    UIUnLockDialog.this.exit();
                }
            });
            this.frame.getContentPane().add(panelBuilder.getPanel());
            this.frame.getRootPane().setDefaultButton(this.okButton);
            this.frame.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.setLocation((dimension.width - this.frame.getWidth()) / 2, (dimension.height - this.frame.getHeight() - 200) / 2);
            this.progressBar.setVisible(false);
            this.infoLabel.setVisible(false);
        }
        return this.frame;
    }

    private void initComponents() {
        this.serverLabel = new JLabel(Translation.get("general.server"));
        this.serverReloadTrigger = new Trigger();
        this.serverReloadTrigger.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                UIUnLockDialog.this.serverInfoLabel.setText(ConfigurationEntry.SERVER_WEB_URL.getValue(UIUnLockDialog.this.getController()));
            }
        });
        this.serverInfoLabel = new ActionLabel(this.getController(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ConfigurationLoaderDialog(UIUnLockDialog.this.getController(), UIUnLockDialog.this.serverReloadTrigger).openAndWait();
            }
        });
        this.serverInfoLabel.setText(ConfigurationEntry.SERVER_WEB_URL.getValue(this.getController()));
        this.usernameField = SimpleComponentFactory.createTextField(true);
        this.passwordField = SimpleComponentFactory.createPasswordField();
        this.proxySettingsLabel = new ActionLabel(this.getController(), new AbstractAction(Translation.get("general.proxy_settings")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HTTPProxySettingsDialog(UIUnLockDialog.this.getController(), UIUnLockDialog.this.frame).open();
            }
        }).getUIComponent();
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.infoLabel = SimpleComponentFactory.createLabel("");
    }

    private String getTitle() {
        return Translation.get("exp.uilock.dialog.title");
    }

    private Component buildButtonBar() {
        this.okButton = UIUnLockDialog.createOKButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UIUnLockDialog.this.showProgressBar();
                new LoadingWorking().execute();
            }
        });
        JButton jButton = new JButton(Translation.get("exp.uilock.dialog.help"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserLauncher.openURL(UIUnLockDialog.this.getController(), Help.getWikiArticleURL(UIUnLockDialog.this.getController(), "User-interface-lock"));
            }
        });
        JButton jButton2 = new JButton(Translation.get("exp.uilock.dialog.exit"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UIUnLockDialog.this.exit();
            }
        });
        JPanel jPanel = ButtonBarFactory.buildCenteredBar(this.okButton, jButton, jButton2);
        jPanel.setOpaque(false);
        return jPanel;
    }

    private void showProgressBar() {
        this.infoLabel.setVisible(false);
        this.progressBar.setVisible(true);
    }

    private void showInfo(String string) {
        this.infoLabel.setText(string);
        this.progressBar.setVisible(false);
        this.infoLabel.setVisible(true);
    }

    private static JButton createOKButton(ActionListener actionListener) {
        JButton jButton = new JButton(Translation.get("general.ok"));
        jButton.setMnemonic(Translation.get("general.ok.key").trim().charAt(0));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private void exit() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.mainProgrammContinue();
        this.getController().exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainProgrammContinue() {
        Object object = this.haltLock;
        synchronized (object) {
            this.haltLock.notifyAll();
        }
    }

    private class LoadingWorking
    extends SwingWorker<Boolean, Void> {
        private LoadingWorking() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            String string = UIUnLockDialog.this.usernameField.getText();
            char[] cArray = UIUnLockDialog.this.passwordField.getPassword();
            if (StringUtils.isBlank(string) || cArray == null || cArray.length == 0) {
                return false;
            }
            Object object = UIUnLockDialog.this.getController().getOSClient() != null ? UIUnLockDialog.this.getController().getOSClient().getWebURL() : ConfigurationEntry.SERVER_WEB_URL.getValue(UIUnLockDialog.this.getController());
            object = (String)object + "/unlock";
            UIUnLockDialog.this.logWarning("Trying to unlock user interface at: " + (String)object);
            object = LoginUtil.decorateURL((String)object, string, cArray);
            URL uRL = new URL((String)object);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n == 403) {
                return false;
            }
            if (n == 200) {
                return true;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamUtils.copyToStream(httpURLConnection.getInputStream(), (OutputStream)byteArrayOutputStream);
            httpURLConnection.getInputStream().close();
            httpURLConnection.disconnect();
            String string2 = new String(byteArrayOutputStream.toByteArray());
            return string2.contains("ALLOWED_TO_UNLOCK_USER_INTERFACE");
        }

        @Override
        protected void done() {
            try {
                boolean bl = (Boolean)this.get();
                if (bl) {
                    UIUnLockDialog.this.frame.setVisible(false);
                    UIUnLockDialog.this.frame.dispose();
                    String string = UIUnLockDialog.this.usernameField.getText();
                    char[] cArray = UIUnLockDialog.this.passwordField.getPassword();
                    UIUnLockDialog.this.getController().getOSClient().login(string, cArray);
                    LoginUtil.clear(cArray);
                    UIUnLockDialog.this.mainProgrammContinue();
                    return;
                }
                UIUnLockDialog.this.showInfo(Translation.get("exp.uilock.dialog.error.wronglogin"));
            }
            catch (InterruptedException interruptedException) {
                UIUnLockDialog.this.logWarning(interruptedException);
            }
            catch (ExecutionException executionException) {
                UIUnLockDialog.this.logWarning(executionException);
                String string = executionException.getCause() != null && executionException.getCause().getMessage() != null ? executionException.getCause().getMessage() : executionException.toString();
                UIUnLockDialog.this.showInfo(string);
            }
        }
    }
}

