/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.dialog.NodesSelectTable;
import de.dal33t.powerfolder.ui.friends.FindComputersDialog;
import de.dal33t.powerfolder.ui.model.NodesSelectTableModel;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class NodesSelectDialog2
extends BaseDialog {
    private NodesSelectTable nodesSelectTable;
    private NodesSelectTableModel nodesSelectTableModel;
    private JCheckBox hideOffline;
    private final Collection<Member> selectedMembers;
    private JButton okButton;

    public NodesSelectDialog2(Controller controller, Collection<Member> collection) {
        super(BaseDialog.Senior.NONE, controller, true);
        this.selectedMembers = collection;
    }

    @Override
    public String getTitle() {
        return Translation.get("dialog.node_select.title");
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    protected JComponent getContent() {
        FormLayout formLayout = new FormLayout("pref:grow", "pref, 3dlu, pref, 3dlu, pref, 6dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(Translation.get("dialog.node_select.text"), cellConstraints.xy(1, 1));
        this.hideOffline = new JCheckBox(Translation.get("dialog.node_select.hide_offline.name"));
        panelBuilder.add((Component)this.hideOffline, cellConstraints.xy(1, 3));
        this.hideOffline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodesSelectDialog2.this.doHide();
            }
        });
        this.nodesSelectTableModel = new NodesSelectTableModel(this.getController());
        this.nodesSelectTable = new NodesSelectTable(this.nodesSelectTableModel);
        this.nodesSelectTable.registerKeyboardAction(new SelectAllAction(), KeyStroke.getKeyStroke(65, 2), 0);
        if (this.nodesSelectTableModel.getRowCount() == 1) {
            this.nodesSelectTable.setRowSelectionInterval(0, 0);
        }
        JScrollPane jScrollPane = new JScrollPane(this.nodesSelectTable);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        panelBuilder.add((Component)jScrollPane, cellConstraints.xy(1, 5));
        return panelBuilder.getPanel();
    }

    @Override
    protected JButton getDefaultButton() {
        return this.okButton;
    }

    @Override
    protected Component getButtonBar() {
        this.okButton = NodesSelectDialog2.createOKButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodesSelectDialog2.this.updateMembers();
                NodesSelectDialog2.this.close();
            }
        });
        JButton jButton = NodesSelectDialog2.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodesSelectDialog2.this.close();
            }
        });
        JButton jButton2 = new JButton(Translation.get("general.search"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindComputersDialog findComputersDialog = new FindComputersDialog(NodesSelectDialog2.this.getController());
                findComputersDialog.open();
            }
        });
        return ButtonBarFactory.buildCenteredBar(this.okButton, jButton2, jButton);
    }

    private void updateMembers() {
        Collection<Member> collection = this.nodesSelectTable.getSelectedMembers();
        this.selectedMembers.clear();
        this.selectedMembers.addAll(collection);
    }

    private void doHide() {
        this.nodesSelectTableModel.setHideOffline(this.hideOffline.isSelected());
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NodesSelectDialog2.this.nodesSelectTable.selectAll();
        }
    }
}

