/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.StreamCallback;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class DownloadUpdateDialog
extends PFUIComponent {
    private JDialog uiComponent;
    private JProgressBar processBar;
    private StreamCallback streamCallback;
    private boolean canceled = false;
    private final String version;

    public DownloadUpdateDialog(Controller controller, String string) {
        super(controller);
        this.version = string;
        this.streamCallback = new MyStreamCallback();
    }

    public void initComponents() {
        this.uiComponent = new JDialog(this.getUIController().getMainFrame().getUIComponent(), Translation.get("dialog.update.updating"), false);
        this.uiComponent.setResizable(false);
        this.uiComponent.setDefaultCloseOperation(2);
        this.uiComponent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                DownloadUpdateDialog.this.canceled = true;
            }
        });
        JButton jButton = new JButton(Translation.get("general.cancel"));
        jButton.setMnemonic(Translation.get("general.cancel").charAt(0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DownloadUpdateDialog.this.cancelPressed();
            }
        });
        JPanel jPanel = ButtonBarFactory.buildCenteredBar(jButton);
        this.processBar = new JProgressBar(0, 0, 100);
        FormLayout formLayout = new FormLayout("20dlu, max(70dlu;pref):grow, max(70dlu;pref):grow, 20dlu", "pref, 14dlu, pref, 14dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(Borders.DLU14_BORDER);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(Translation.get("dialog.update.updating.text", this.version), cellConstraints.xywh(1, 1, 4, 1));
        panelBuilder.add((Component)this.processBar, cellConstraints.xywh(2, 3, 2, 1));
        panelBuilder.add((Component)jPanel, cellConstraints.xywh(2, 5, 2, 1));
        this.uiComponent.getContentPane().add(panelBuilder.getPanel());
        this.uiComponent.pack();
        Window window = this.uiComponent.getOwner();
        if (window != null) {
            int n = window.getX() + (window.getWidth() - this.uiComponent.getWidth()) / 2;
            int n2 = window.getY() + (window.getHeight() - this.uiComponent.getHeight()) / 2;
            this.uiComponent.setLocation(n, n2);
        }
    }

    private synchronized JDialog getUIComponent() {
        if (this.uiComponent == null) {
            this.initComponents();
        }
        return this.uiComponent;
    }

    public void openInEDT() {
        this.logFine("Opening download dialog");
        UIUtil.invokeLaterInEDT(new Runnable(){

            @Override
            public void run() {
                DownloadUpdateDialog.this.getUIComponent().setVisible(true);
            }
        });
    }

    public void close() {
        if (this.uiComponent != null) {
            this.uiComponent.dispose();
        }
    }

    public void setCompletionPercentage(int n) {
        if (this.processBar != null) {
            this.processBar.setValue(n);
        }
    }

    public StreamCallback getStreamCallback() {
        return this.streamCallback;
    }

    public boolean isCancelled() {
        return this.canceled;
    }

    private void cancelPressed() {
        this.canceled = true;
        this.uiComponent.dispose();
    }

    private final class MyStreamCallback
    implements StreamCallback {
        private MyStreamCallback() {
        }

        @Override
        public boolean streamPositionReached(final long l, final long l2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n = (int)(l * 100L / l2);
                    DownloadUpdateDialog.this.setCompletionPercentage(n);
                    if (l >= l2) {
                        DownloadUpdateDialog.this.close();
                        DownloadUpdateDialog.this.canceled = false;
                    }
                }
            };
            UIUtil.invokeLaterInEDT(runnable);
            return DownloadUpdateDialog.this.canceled;
        }
    }
}

