/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.dao.FileInfoCriteria;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.contextmenu.PFContextMenuAction;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class LockAction
extends PFContextMenuAction {
    private static final Logger log = Logger.getLogger(LockAction.class.getName());

    LockAction(Controller controller) {
        super(controller);
    }

    @Override
    public void onSelection(String[] stringArray) {
        try {
            List<FileInfo> list = this.getFileInfos(stringArray);
            for (FileInfo fileInfo : list) {
                this.lockFileInfo(fileInfo);
            }
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.WARNING, "Problem while trying to lock files. " + runtimeException, runtimeException);
        }
    }

    private void lockFileInfo(FileInfo fileInfo) {
        if (fileInfo.isDiretory()) {
            DirectoryInfo directoryInfo = (DirectoryInfo)fileInfo;
            FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
            fileInfoCriteria.addMySelf(fileInfo.getFolder(this.getController().getFolderRepository()));
            fileInfoCriteria.setPath(directoryInfo);
            fileInfoCriteria.setRecursive(true);
            Collection<FileInfo> collection = directoryInfo.getFolder(this.getController().getFolderRepository()).getDAO().findFiles(fileInfoCriteria);
            for (FileInfo fileInfo2 : collection) {
                this.lockFileInfo(fileInfo2);
            }
        }
        this.lock(fileInfo);
    }

    private void lock(FileInfo fileInfo) {
        if (!fileInfo.isLocked(this.getController()) && !fileInfo.lock(this.getController())) {
            log.warning("File " + fileInfo + " could not be locked!");
        }
    }
}

