/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.action;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.ConnectDialog;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class ConnectAction
extends BaseAction {
    private static final Logger log = Logger.getLogger(ConnectAction.class.getName());

    public ConnectAction(Controller controller) {
        super("exp.action_connect", controller);
    }

    public void setInputConnect(String string) {
        this.getController().getPreferences().put("input.lastconnect", string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Window window = UIUtil.getParentWindow(actionEvent);
        if (window == null) {
            window = this.getUIController().getMainFrame().getUIComponent();
        }
        if (StringUtils.isBlank((String)(object = JOptionPane.showInputDialog(window, Translation.get("exp.connect.dialog.text"), Translation.get("exp.connect.dialog.title"), 3, null, null, this.getController().getPreferences().get("input.lastconnect", ""))))) {
            return;
        }
        final ConnectDialog connectDialog = new ConnectDialog(this.getController(), UIUtil.getParentWindow(actionEvent));
        final String string = object.toString();
        this.getController().getPreferences().put("input.lastconnect", string);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block2: {
                    connectDialog.open(string);
                    try {
                        ConnectAction.this.getController().connect(string);
                    }
                    catch (ConnectionException connectionException) {
                        connectDialog.close();
                        log.log(Level.FINER, "", connectionException);
                        if (connectDialog.isCanceled()) break block2;
                        connectionException.show(ConnectAction.this.getController());
                    }
                }
                connectDialog.close();
                log.finer("Connector thread finished");
            }
        };
        new Thread(runnable, "Connector to " + string).start();
    }
}

