/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.action;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.ui.UIController;
import de.dal33t.powerfolder.ui.model.BoundPermission;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public abstract class BaseAction
extends AbstractAction {
    private Controller controller;
    private BoundPermission boundPermission;

    protected BaseAction(String string, Controller controller) {
        this(null, null, controller);
        this.configureFromActionId(string);
    }

    protected BaseAction(String string, Icon icon, Controller controller) {
        super(string, icon);
        if (controller == null) {
            throw new NullPointerException("Controller is null");
        }
        this.controller = controller;
    }

    protected void configureFromActionId(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        this.putValue("Name", Translation.get(string + ".name"));
        this.setMnemonicKey(Translation.get(string + ".key"));
        this.putValue("ShortDescription", Translation.get(string + ".description"));
        Icon icon = Icons.getIconById(string + ".icon");
        if (icon != null && icon.getIconHeight() != -1) {
            this.putValue("SmallIcon", icon);
        }
    }

    protected void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void allowWith(Permission permission) {
        if (permission instanceof FolderPermission) {
            this.setEnabled(this.getController().getOSClient().getAccount().hasPermission(permission));
        }
        if (!ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()).booleanValue()) {
            return;
        }
        if (permission != null && this.boundPermission != null && permission.equals(this.boundPermission.getPermission())) {
            return;
        }
        this.boundPermission = null;
        if (permission != null) {
            this.boundPermission = new BoundPermission(this.getController(), permission){

                @Override
                public void hasPermission(boolean bl) {
                    BaseAction.this.setEnabled(bl);
                }
            };
        }
    }

    public void dispose() {
        if (this.boundPermission != null) {
            this.boundPermission.dispose();
        }
    }

    protected void setMnemonicKey(String string) {
        if (StringUtils.isBlank(string)) {
            this.putValue("MnemonicKey", null);
        } else {
            this.putValue("MnemonicKey", Character.toUpperCase(string.charAt(0)));
        }
    }

    protected Controller getController() {
        return this.controller;
    }

    protected UIController getUIController() {
        return this.controller.getUIController();
    }

    public String toString() {
        return this.getName();
    }
}

