/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Waiter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SplashScreen
extends JWindow {
    private static final Logger log = Logger.getLogger(SplashScreen.class.getName());
    private Controller controller;
    private JProgressBar bar;
    private Thread splashThread;
    private JLabel image;
    private Timer timer;
    private int nPercentageGuessed;
    private int nextPercentage;
    private Date startTime;

    public SplashScreen(final Controller controller, int n) {
        if (controller == null) {
            throw new NullPointerException("Controller is null");
        }
        this.controller = controller;
        long l = controller.getPreferences().getLong("lastStartTookMS", 1000L);
        this.image = new JLabel(Icons.getIconById("splash.icon"));
        this.image.setBorder(BorderFactory.createEmptyBorder());
        this.bar = new JProgressBar(0, 0, 100);
        this.bar.setBorder(BorderFactory.createEmptyBorder());
        this.getContentPane().add((Component)this.image, "North");
        this.getContentPane().add((Component)this.bar, "South");
        this.pack();
        this.timer = new Timer("Splash barupdater", true);
        this.timer.schedule((TimerTask)new BarUpdater(), 0L, (long)Math.max((int)l / 200, 10));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        this.setLocation(dimension.width / 2 - dimension2.width / 2, (int)((double)dimension.height / 2.5) - dimension2.height / 2);
        final int n2 = n;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.timer.purge();
                SplashScreen.this.timer.cancel();
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    Waiter waiter = new Waiter(n2);
                    while (!waiter.isTimeout()) {
                        waiter.waitABit();
                        if (!controller.isShuttingDown()) continue;
                        break;
                    }
                }
                catch (RuntimeException runtimeException) {
                }
                finally {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
        this.setVisible(true);
        this.splashThread = new Thread(runnable2, "SplashScreenThread");
        this.splashThread.start();
    }

    public void setCompletionPercentage(final int n, int n2) {
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        if (n >= 100) {
            long l = System.currentTimeMillis() - this.startTime.getTime();
            this.controller.getPreferences().putLong("lastStartTookMS", l);
        }
        this.nPercentageGuessed = 0;
        this.nextPercentage = n2;
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.this.bar.setValue(n);
                    Graphics graphics = SplashScreen.this.image.getGraphics();
                    if (graphics == null) {
                        return;
                    }
                    String string = "26.0.100";
                    graphics.drawString(string, 20, SplashScreen.this.getHeight() - 25);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            log.log(Level.SEVERE, "InterruptedException", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.log(Level.SEVERE, "InvocationTargetException", invocationTargetException);
        }
    }

    public void shutdown() {
        this.setVisible(false);
        this.dispose();
        if (this.splashThread != null) {
            this.splashThread.interrupt();
        }
        this.timer.purge();
        this.timer.cancel();
    }

    private class BarUpdater
    extends TimerTask {
        private BarUpdater() {
        }

        @Override
        public void run() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = SplashScreen.this.bar.getValue();
                    if (n < SplashScreen.this.nextPercentage && SplashScreen.this.nPercentageGuessed < 30) {
                        SplashScreen.this.bar.setValue(n + 1);
                        SplashScreen.this.nPercentageGuessed++;
                    }
                }
            });
        }
    }
}

