/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.PausedModeEvent;
import de.dal33t.powerfolder.event.PausedModeListener;
import de.dal33t.powerfolder.message.clientserver.AccountDetails;
import de.dal33t.powerfolder.security.ChangePreferencesPermission;
import de.dal33t.powerfolder.security.FolderCreatePermission;
import de.dal33t.powerfolder.ui.MainTabbedPane;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.WindowDragManager;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.event.SyncStatusEvent;
import de.dal33t.powerfolder.ui.event.SyncStatusListener;
import de.dal33t.powerfolder.ui.model.SyncingModel;
import de.dal33t.powerfolder.ui.notices.CloudStorageNotice;
import de.dal33t.powerfolder.ui.notices.SimpleNotificationNotice;
import de.dal33t.powerfolder.ui.util.DelayedUpdater;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.NeverAskAgainResponse;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.util.SyncIconButtonMini;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.widget.JButton3Icons;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.DateUtil;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.LinuxUtil;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.RootPaneUI;

public class MainFrame
extends PFUIComponent {
    public static final int MIN_MAIN_TABBED_WIDTH = 300;
    private JFrame uiComponent;
    private JLabel logoLabel;
    private JPanel centralPanel;
    private MainTabbedPane mainTabbedPane;
    private JPanel inlineInfoPanel;
    private JLabel inlineInfoLabel;
    private JButton inlineInfoCloseButton;
    private JSplitPane split;
    private ServerClient client;
    private JButtonMini allInSyncButton;
    private SyncIconButtonMini syncingButton;
    private JButtonMini setupButton;
    private JButtonMini pauseButton;
    private JLabel notConnectedLoggedInLabel;
    private JButtonMini noticeWarningButton;
    private JButtonMini noticeInfoButton;
    private ActionLabel upperMainTextActionLabel;
    private ActionLabel lowerMainTextActionLabel;
    private ActionLabel setupLabel;
    private ActionLabel loginActionLabel;
    private JProgressBar usagePB;
    private JLabel noStorageText;
    private ActionLabel noticesActionLabel;
    private DelayedUpdater mainStatusUpdater;
    private DelayedUpdater osStatusUpdater;
    private ActionLabel createFolderActionLabel;
    private ActionLabel openWebInterfaceActionLabel;
    private ActionLabel openFoldersBaseActionLabel;
    private ActionLabel pauseResumeActionLabel;
    private ActionLabel configurationActionLabel;
    private ActionLabel openDebugActionLabel;
    private ActionLabel openTransfersActionLabel;
    private FrameMode frameMode = FrameMode.NORMAL;
    private JButton3Icons closeButton;
    private JButton3Icons plusButton;
    private JButton3Icons minusButton;
    private final AtomicBoolean frameStateSet = new AtomicBoolean();

    public MainFrame(Controller controller) throws HeadlessException {
        super(controller);
        this.mainStatusUpdater = new DelayedUpdater(this.getController(), 500L);
        this.osStatusUpdater = new DelayedUpdater(this.getController());
        controller.getFolderRepository().addFolderRepositoryListener(new MyFolderRepositoryListener());
        this.initComponents();
        this.configureUi();
        this.updateOnlineStorageDetails();
        this.frameMode = FrameMode.NORMAL;
        this.setFrameMode(this.frameMode, true);
    }

    private JPanel createMiniPanel() {
        FormLayout formLayout = new FormLayout("left:pref:grow, left:pref", "top:pref:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(Borders.createEmptyBorder("10dlu, 0, 0, 3dlu"));
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add(this.createLeftMiniPanel(), cellConstraints.xy(1, 1));
        defaultFormBuilder.add(this.createRightMiniPanel(), cellConstraints.xy(2, 1));
        return defaultFormBuilder.getPanel();
    }

    private Component createLeftMiniPanel() {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref:grow", "pref, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref:grow", "pref:grow"));
        panelBuilder.add((Component)this.allInSyncButton, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.syncingButton, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.setupButton, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.pauseButton, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.notConnectedLoggedInLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.noticeWarningButton, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.noticeInfoButton, cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)panelBuilder.getPanel(), cellConstraints.xywh(1, 1, 1, 2));
        defaultFormBuilder.add((Component)this.upperMainTextActionLabel.getUIComponent(), cellConstraints.xy(3, 1));
        defaultFormBuilder.add((Component)this.lowerMainTextActionLabel.getUIComponent(), cellConstraints.xy(3, 2));
        if (this.getController().getOSClient().isAllowedToCreateFolders() && this.setupLabel != null) {
            defaultFormBuilder.add((Component)this.setupLabel.getUIComponent(), cellConstraints.xy(3, 2));
        } else {
            defaultFormBuilder.add((Component)new JLabel(" "), cellConstraints.xy(3, 2));
        }
        FormLayout formLayout2 = new FormLayout("pref, 100dlu", "pref, pref, pref");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(formLayout2);
        defaultFormBuilder2.add((Component)new JLabel((Icon)null), cellConstraints.xywh(1, 1, 1, 2));
        defaultFormBuilder2.add((Component)this.loginActionLabel.getUIComponent(), cellConstraints.xy(2, 1));
        defaultFormBuilder2.add((Component)this.usagePB, cellConstraints.xy(2, 2));
        defaultFormBuilder2.add((Component)this.noStorageText, cellConstraints.xy(2, 2));
        defaultFormBuilder2.add((Component)new JLabel(" "), cellConstraints.xy(1, 3));
        defaultFormBuilder2.add((Component)this.noticesActionLabel.getUIComponent(), cellConstraints.xy(2, 3));
        FormLayout formLayout3 = new FormLayout("pref", "pref, 5dlu, pref");
        DefaultFormBuilder defaultFormBuilder3 = new DefaultFormBuilder(formLayout3);
        defaultFormBuilder3.setBorder(Borders.createEmptyBorder("0, 5dlu, 5dlu, 0"));
        defaultFormBuilder3.add((Component)defaultFormBuilder.getPanel(), cellConstraints.xy(1, 1));
        defaultFormBuilder3.add((Component)defaultFormBuilder2.getPanel(), cellConstraints.xy(1, 3));
        return defaultFormBuilder3.getPanel();
    }

    private Component createRightMiniPanel() {
        FormLayout formLayout = new FormLayout("pref:grow", "pref, pref, pref, pref, pref, pref, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        if (ConfigurationEntry.WEB_LOGIN_ALLOWED.getValueBoolean(this.getController()).booleanValue()) {
            defaultFormBuilder.add((Component)this.openWebInterfaceActionLabel.getUIComponent(), cellConstraints.xy(1, 1, "right, top"));
        }
        if (PreferencesEntry.SHOW_BROWSE.getValueBoolean(this.getController()).booleanValue()) {
            defaultFormBuilder.add((Component)this.openFoldersBaseActionLabel.getUIComponent(), cellConstraints.xy(1, 2, "right, top"));
        }
        if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
            defaultFormBuilder.add((Component)this.pauseResumeActionLabel.getUIComponent(), cellConstraints.xy(1, 3, "right, top"));
        }
        defaultFormBuilder.add((Component)this.configurationActionLabel.getUIComponent(), cellConstraints.xy(1, 4, "right, top"));
        if (this.getController().isVerbose()) {
            defaultFormBuilder.add((Component)this.openDebugActionLabel.getUIComponent(), cellConstraints.xy(1, 5, "right, top"));
        }
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            defaultFormBuilder.add((Component)this.openTransfersActionLabel.getUIComponent(), cellConstraints.xy(1, 6, "right, top"));
        }
        if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
            defaultFormBuilder.add((Component)this.createFolderActionLabel.getUIComponent(), cellConstraints.xy(1, 7, "right, top"));
        }
        return defaultFormBuilder.getPanel();
    }

    private void configureUi() {
        this.uiComponent.getRootPane().putClientProperty("Synthetica.titlePane.enabled", Boolean.FALSE);
        this.uiComponent.getRootPane().updateUI();
        FormLayout formLayout = new FormLayout("fill:pref:grow, pref, 3dlu, pref", "pref, pref, fill:0:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addFixed(this.minusButton);
        buttonBarBuilder.addFixed(this.plusButton);
        buttonBarBuilder.addFixed(this.closeButton);
        defaultFormBuilder.add((Component)buttonBarBuilder.getPanel(), cellConstraints.xywh(4, 1, 1, 1, "right, top"));
        defaultFormBuilder.add((Component)this.logoLabel, cellConstraints.xyw(1, 1, 4));
        defaultFormBuilder.add((Component)this.inlineInfoLabel, cellConstraints.xy(2, 2, CellConstraints.DEFAULT, CellConstraints.TOP));
        defaultFormBuilder.add((Component)this.inlineInfoCloseButton, cellConstraints.xy(4, 2, CellConstraints.DEFAULT, CellConstraints.TOP));
        defaultFormBuilder.add((Component)this.centralPanel, cellConstraints.xyw(1, 3, 4));
        defaultFormBuilder.add((Component)this.createMiniPanel(), cellConstraints.xyw(1, 2, 4));
        this.uiComponent.getContentPane().removeAll();
        this.uiComponent.getContentPane().add(defaultFormBuilder.getPanel());
        this.uiComponent.setResizable(true);
        Controller controller = this.getController();
        this.uiComponent.pack();
        this.uiComponent.setSize(this.uiComponent.getWidth(), 500);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = (int)((double)(graphicsDeviceArray[0].getDisplayMode().getWidth() - this.uiComponent.getWidth()) / 2.0);
        int n2 = (int)((double)(graphicsDeviceArray[0].getDisplayMode().getHeight() - this.uiComponent.getHeight()) / 2.0);
        this.uiComponent.setLocation(n, n2);
        this.configureInlineInfo();
        if (!this.getController().getNodeManager().isStarted()) {
            this.updateMainStatus(SyncStatusEvent.NOT_STARTED);
        } else {
            this.updateMainStatus(SyncStatusEvent.NOT_CONNECTED);
        }
        this.updateNoticesLabel();
    }

    private void updateNoticesLabel() {
        int n = (Integer)this.getController().getUIController().getApplicationModel().getNoticesModel().getUnreadNoticesCountVM().getValue();
        if (n == 0) {
            this.noticesActionLabel.setVisible(false);
        } else if (n == 1) {
            this.noticesActionLabel.setVisible(true);
            this.noticesActionLabel.setText(Translation.get("main_frame.unread_notices.single.text"));
        } else {
            this.noticesActionLabel.setVisible(true);
            this.noticesActionLabel.setText(Translation.get("main_frame.unread_notices.plural.text", String.valueOf(n)));
        }
    }

    private void handleExitFirstRequest() {
        boolean bl = PreferencesEntry.ASK_FOR_QUIT_ON_X.getValueBoolean(this.getController());
        if (bl) {
            String[] stringArray = new String[]{Translation.get("dialog.ask_for_quit_on_x.Minimize_button"), Translation.get("dialog.ask_for_quit_on_x.Exit_button")};
            NeverAskAgainResponse neverAskAgainResponse = DialogFactory.genericDialog(this.getController(), Translation.get("dialog.ask_for_quit_on_x.title"), Translation.get("dialog.ask_for_quit_on_x.text"), stringArray, 0, GenericDialogType.QUESTION, Translation.get("general.neverAskAgain"));
            if (neverAskAgainResponse.getButtonIndex() == 1) {
                PreferencesEntry.QUIT_ON_X.setValue(this.getController(), true);
            } else {
                PreferencesEntry.QUIT_ON_X.setValue(this.getController(), false);
            }
            if (neverAskAgainResponse.isNeverAskAgain()) {
                PreferencesEntry.ASK_FOR_QUIT_ON_X.setValue(this.getController(), false);
            }
        }
    }

    private void initComponents() {
        this.uiComponent = new JFrame();
        this.uiComponent.setTransferHandler(new MyTransferHandler());
        this.uiComponent.addWindowFocusListener(new MyWindowFocusListener());
        this.uiComponent.setIconImage(Icons.getImageById("powerfolder_32.icon"));
        this.uiComponent.setBackground(Color.white);
        MySetupAction mySetupAction = new MySetupAction(this.getController());
        if (ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()).booleanValue()) {
            mySetupAction.allowWith(FolderCreatePermission.INSTANCE);
        }
        MyOpenFoldersBaseAction myOpenFoldersBaseAction = new MyOpenFoldersBaseAction(this.getController());
        myOpenFoldersBaseAction.setEnabled(PreferencesEntry.SHOW_BROWSE.getValueBoolean(this.getController()));
        this.allInSyncButton = new JButtonMini(myOpenFoldersBaseAction);
        this.allInSyncButton.setIcon(Icons.getIconById("sync_complete.icon"));
        this.allInSyncButton.setText(null);
        this.pauseButton = new JButtonMini(new MyPauseResumeAction(this.getController()));
        this.pauseButton.setIcon(Icons.getIconById("pause.icon"));
        this.pauseButton.setText(null);
        this.syncingButton = new SyncIconButtonMini(this.getController());
        this.syncingButton.addActionListener(myOpenFoldersBaseAction);
        this.syncingButton.setVisible(false);
        this.setupButton = new JButtonMini(mySetupAction);
        this.setupButton.setIcon(Icons.getIconById("action_arrow.icon"));
        this.setupButton.setText(null);
        this.notConnectedLoggedInLabel = new JLabel(Icons.getIconById("warning.icon"));
        MyShowNoticesAction myShowNoticesAction = new MyShowNoticesAction(this.getController());
        this.noticeWarningButton = new JButtonMini(myShowNoticesAction);
        this.noticeWarningButton.setIcon(Icons.getIconById("warning.icon"));
        this.noticeWarningButton.setText(null);
        this.noticeInfoButton = new JButtonMini(myShowNoticesAction);
        this.noticeInfoButton.setIcon(Icons.getIconById("information.icon"));
        this.noticeInfoButton.setText(null);
        this.upperMainTextActionLabel = new ActionLabel(this.getController(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.handleSyncTextClick();
            }
        });
        this.lowerMainTextActionLabel = new ActionLabel(this.getController(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!PreferencesEntry.EXPERT_MODE.getValueBoolean(MainFrame.this.getController()).booleanValue()) {
                    MainFrame.this.handleSyncTextClick();
                }
            }
        });
        this.upperMainTextActionLabel.setNeverUnderline(true);
        this.lowerMainTextActionLabel.setNeverUnderline(true);
        if (!PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            this.lowerMainTextActionLabel.setNeverUnderline(true);
        }
        if (!ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()).booleanValue() || this.getController().getOSClient().getAccount().hasPermission(FolderCreatePermission.INSTANCE)) {
            this.setupLabel = new ActionLabel(this.getController(), mySetupAction);
        }
        this.loginActionLabel = new ActionLabel(this.getController(), new MyLoginAction(this.getController()));
        this.noticesActionLabel = new ActionLabel(this.getController(), new MyShowNoticesAction(this.getController()));
        this.updateNoticesLabel();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    if (StringUtils.isBlank(MainFrame.this.client.getUsername())) {
                        PFWizard.openLoginWizard(MainFrame.this.getController(), MainFrame.this.client);
                    } else {
                        BrowserLauncher.open(MainFrame.this.getController(), () -> MainFrame.this.client.getWebURL("/myaccount", true));
                    }
                }
            }
        };
        this.noStorageText = SimpleComponentFactory.createLabel(Translation.get("main_frame.no_quota"));
        this.noStorageText.setCursor(Cursor.getPredefinedCursor(12));
        this.noStorageText.addMouseListener(mouseAdapter);
        this.noStorageText.setVisible(false);
        this.usagePB = new JProgressBar();
        this.usagePB.setCursor(Cursor.getPredefinedCursor(12));
        this.usagePB.addMouseListener(mouseAdapter);
        this.createFolderActionLabel = new ActionLabel(this.getController(), this.getApplicationModel().getActionModel().getNewFolderAction());
        this.openWebInterfaceActionLabel = new ActionLabel(this.getController(), new MyOpenWebInterfaceAction(this.getController()));
        this.openFoldersBaseActionLabel = new ActionLabel(this.getController(), myOpenFoldersBaseAction);
        this.pauseResumeActionLabel = new ActionLabel(this.getController(), new MyPauseResumeAction(this.getController()));
        this.configurationActionLabel = new ActionLabel(this.getController(), new MyOpenPreferencesAction(this.getController()));
        this.openDebugActionLabel = new ActionLabel(this.getController(), new MyOpenDebugAction(this.getController()));
        this.openTransfersActionLabel = new ActionLabel(this.getController(), new MyOpenTransfersAction(this.getController()));
        MyWindowListener myWindowListener = new MyWindowListener();
        this.uiComponent.addWindowListener(myWindowListener);
        this.uiComponent.addWindowStateListener(myWindowListener);
        this.split = new JSplitPane(1);
        this.split.setOneTouchExpandable(false);
        this.uiComponent.setDefaultCloseOperation(0);
        this.logoLabel = new JLabel();
        this.logoLabel.setIcon(Icons.getIconById("power_folder_logo_400_ui.icon"));
        this.logoLabel.setHorizontalAlignment(2);
        MyMouseWindowDragListener myMouseWindowDragListener = new MyMouseWindowDragListener();
        this.logoLabel.addMouseListener(myMouseWindowDragListener);
        this.logoLabel.addMouseMotionListener(myMouseWindowDragListener);
        this.closeButton = new JButton3Icons(Icons.getIconById("filter_text_field_clear_button_normal.icon"), Icons.getIconById("filter_text_field_clear_button_hover.icon"), Icons.getIconById("filter_text_field_clear_button_push.icon"));
        this.closeButton.setToolTipText(Translation.get("main_frame.close.tips"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.doCloseOperation();
            }
        });
        this.plusButton = new JButton3Icons(Icons.getIconById("window_maximize_normal.icon"), Icons.getIconById("window_maximize_hover.icon"), Icons.getIconById("window_maximize_push.icon"));
        this.plusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.doPlusOperation();
            }
        });
        this.minusButton = new JButton3Icons(Icons.getIconById("window_minus_normal.icon"), Icons.getIconById("window_minus_hover.icon"), Icons.getIconById("window_minus_push.icon"));
        this.minusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.doMinusOperation();
            }
        });
        this.centralPanel = new JPanel(new BorderLayout(0, 0));
        this.mainTabbedPane = new MainTabbedPane(this.getController());
        this.updateTitle();
        this.inlineInfoCloseButton = new JButton3Icons(Icons.getIconById("filter_text_field_clear_button_normal.icon"), Icons.getIconById("filter_text_field_clear_button_hover.icon"), Icons.getIconById("filter_text_field_clear_button_push.icon"));
        this.inlineInfoCloseButton.setToolTipText(Translation.get("main_frame.inline_info_close.tip"));
        this.inlineInfoCloseButton.addActionListener(new MyInlineCloseInfoActionListener());
        this.inlineInfoCloseButton.setContentAreaFilled(false);
        this.inlineInfoLabel = new JLabel();
        this.configurePauseResumeLink();
        this.client = this.getApplicationModel().getServerClientModel().getClient();
        this.client.addListener(new MyServerClientListener());
        this.getController().getUIController().getApplicationModel().getNoticesModel().getAllNoticesCountVM().addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MainFrame.this.updateNoticesLabel();
            }
        });
        this.getController().getUIController().getApplicationModel().getNoticesModel().getUnreadNoticesCountVM().addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MainFrame.this.updateNoticesLabel();
            }
        });
        this.getController().getUIController().getApplicationModel().addSyncStatusListener(new SyncStatusListener(){

            @Override
            public void syncStatusChanged(final SyncStatusEvent syncStatusEvent) {
                MainFrame.this.mainStatusUpdater.schedule(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.updateMainStatus(syncStatusEvent);
                    }
                });
            }

            @Override
            public boolean fireInEventDispatchThread() {
                return true;
            }
        });
        this.getController().addPausedModeListener(new MyPausedModeListener());
    }

    private void handleSyncTextClick() {
        if (this.noticeWarningButton.isVisible() || this.noticeInfoButton.isVisible()) {
            this.setFrameMode(FrameMode.NORMAL);
            int n = (Integer)this.getController().getUIController().getApplicationModel().getNoticesModel().getUnreadNoticesCountVM().getValue();
            if (n > 0) {
                this.getController().getUIController().openNoticesCard();
            } else {
                for (Folder folder : this.getController().getFolderRepository().getFolders()) {
                    if (folder.getProblems().size() <= 0) continue;
                    this.getController().getUIController().openProblemsInformation(folder.getInfo());
                    break;
                }
            }
        }
    }

    private void updateMainStatus(SyncStatusEvent syncStatusEvent) {
        String string;
        SyncingModel syncingModel = this.getUIController().getApplicationModel().getSyncingModel();
        boolean bl = syncStatusEvent.equals((Object)SyncStatusEvent.NOT_STARTED) || syncStatusEvent.equals((Object)SyncStatusEvent.NO_FOLDERS);
        boolean bl2 = this.getController().getOSClient().isAllowedToCreateFolders() && this.setupLabel != null;
        this.pauseButton.setVisible(syncStatusEvent.equals((Object)SyncStatusEvent.PAUSED));
        if (bl2) {
            this.setupLabel.setVisible(bl);
        }
        this.setupButton.setVisible(bl || !this.client.isLoginExecuted());
        this.setupButton.setEnabled(this.getController().getOSClient().isAllowedToCreateFolders());
        this.allInSyncButton.setVisible(syncStatusEvent.equals((Object)SyncStatusEvent.SYNCHRONIZED));
        this.syncingButton.setVisible(syncStatusEvent.equals((Object)SyncStatusEvent.SYNCING) || syncStatusEvent.equals((Object)SyncStatusEvent.SYNC_INCOMPLETE));
        this.syncingButton.spin(syncStatusEvent.equals((Object)SyncStatusEvent.SYNCING) || syncStatusEvent.equals((Object)SyncStatusEvent.SYNC_INCOMPLETE));
        this.noticeWarningButton.setVisible(syncStatusEvent.equals((Object)SyncStatusEvent.WARNING));
        this.noticeInfoButton.setVisible(syncStatusEvent.equals((Object)SyncStatusEvent.INFORMATION));
        this.notConnectedLoggedInLabel.setVisible((syncStatusEvent.equals((Object)SyncStatusEvent.NOT_CONNECTED) || syncStatusEvent.equals((Object)SyncStatusEvent.NOT_LOGGED_IN)) && this.client.isLoginExecuted());
        Date date = syncingModel.getLastSyncDate();
        double d = syncingModel.getOverallSyncPercentage();
        String string2 = " ";
        String string3 = " ";
        if (syncStatusEvent.equals((Object)SyncStatusEvent.PAUSED)) {
            string = d >= 0.0 && d < 99.5 ? Format.formatDecimal(d) + "%" : "";
            string2 = Translation.get("main_frame.paused", string);
            this.upperMainTextActionLabel.setNeverUnderline(true);
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.NOT_STARTED)) {
            string2 = Translation.get("main_frame.not_running");
            string3 = Translation.get("main_frame.activate_now");
            this.upperMainTextActionLabel.setNeverUnderline(true);
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.NO_FOLDERS)) {
            string2 = this.getController().getOSClient().getAccount().getFolders().isEmpty() ? Translation.get("folders_tab.no_folders_found") : Translation.get("main_frame.no_folders");
            string3 = this.getApplicationModel().getActionModel().getNewFolderAction().getName();
            this.upperMainTextActionLabel.setNeverUnderline(true);
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.SYNCING) || syncStatusEvent.equals((Object)SyncStatusEvent.SYNC_INCOMPLETE)) {
            date = syncingModel.getEstimatedSyncDate();
            string = d >= 0.0 && d < 99.5 ? Format.formatDecimal(d) + "%" : "...";
            string2 = Translation.get("main_frame.syncing", string);
            this.upperMainTextActionLabel.setNeverUnderline(true);
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.SYNCHRONIZED)) {
            string2 = Translation.get("main_frame.in_sync");
            this.upperMainTextActionLabel.setNeverUnderline(true);
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.NOT_CONNECTED)) {
            string2 = Translation.get("main_frame.connecting.text");
            this.upperMainTextActionLabel.setNeverUnderline(true);
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.LOGGING_IN) || !this.client.isLoginExecuted()) {
            string2 = Translation.get("main_frame.logging_in.text");
            this.upperMainTextActionLabel.setNeverUnderline(true);
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.NOT_LOGGED_IN)) {
            string2 = Translation.get("main_frame.log_in_failed.text");
            this.upperMainTextActionLabel.setNeverUnderline(true);
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.WARNING)) {
            string2 = Translation.get("main_frame.warning_notice.text");
            this.upperMainTextActionLabel.setNeverUnderline(false);
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.INFORMATION)) {
            string2 = Translation.get("main_frame.info_notice.text");
            this.upperMainTextActionLabel.setNeverUnderline(false);
        } else {
            this.logSevere("Not handling all sync states: " + syncStatusEvent);
            this.upperMainTextActionLabel.setNeverUnderline(true);
        }
        this.upperMainTextActionLabel.setText(string2);
        if (bl2) {
            this.setupLabel.setText(string3);
            this.setupLabel.setVisible(bl);
        }
        this.lowerMainTextActionLabel.setVisible(!bl);
        string = " ";
        if (date != null && !DateUtil.isDateMoreThanNDaysInFuture(date, 3)) {
            int n;
            int n2;
            int n3;
            String string4 = Format.formatDateShort(date);
            boolean bl3 = date.after(new Date());
            string = bl3 ? (DateUtil.isDateMoreThanNHoursInFuture(date, 20) ? ((n3 = DateUtil.getDaysInFuture(date)) <= 1 ? Translation.get("main_frame.sync_eta_one_day") : Translation.get("main_frame.sync_eta_days", String.valueOf(n3))) : (DateUtil.isDateMoreThanNMinutesInFuture(date, 45) ? ((n2 = DateUtil.getHoursInFuture(date)) <= 1 ? Translation.get("main_frame.sync_eta_one_hour") : Translation.get("main_frame.sync_eta_hours", String.valueOf(n2))) : ((n = DateUtil.getMinutesInFuture(date)) <= 1 ? Translation.get("main_frame.sync_eta_one_minute") : Translation.get("main_frame.sync_eta_minutes", String.valueOf(n))))) : Translation.get("main_frame.last_synced", string4);
        }
        this.lowerMainTextActionLabel.setText(string);
    }

    public void updateTitle() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Translation.get("general.application.name");
        if (StringUtils.isEmpty(string) || string.startsWith("- ")) {
            string = "PowerFolder";
        }
        stringBuilder.append(string);
        if (this.getController().isVerbose()) {
            stringBuilder.append(" v26.0.100");
            if (this.getController().getBuildTime() != null) {
                stringBuilder.append(" | build: " + this.getController().getBuildTime());
            }
            stringBuilder.append(" | " + this.getController().getMySelf().getNick());
        }
        this.uiComponent.setTitle(stringBuilder.toString());
    }

    public JFrame getUIComponent() {
        return this.uiComponent;
    }

    public void addTabbedPaneChangeListener(ChangeListener changeListener) {
        this.mainTabbedPane.addTabbedPaneChangeListener(changeListener);
    }

    public void removeTabbedPaneChangeListener(ChangeListener changeListener) {
        this.mainTabbedPane.removeTabbedPaneChangeListener(changeListener);
    }

    public void storeValues() {
        Controller controller = this.getController();
        if (this.isMaximized()) {
            PreferencesEntry.MAIN_FRAME_MAXIMIZED.setValue(controller, true);
        } else {
            PreferencesEntry.MAIN_FRAME_MAXIMIZED.setValue(controller, false);
        }
    }

    public boolean isIconified() {
        return (this.uiComponent.getExtendedState() & 1) != 0;
    }

    public boolean isMaximized() {
        return (this.uiComponent.getExtendedState() & 6) != 0;
    }

    public boolean isIconifiedOrHidden() {
        return this.isIconified() || !this.uiComponent.isVisible();
    }

    private void showOSFolderList() {
        if (this.frameStateSet.get()) {
            return;
        }
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            return;
        }
        if (!this.getController().getFolderRepository().getFolders().isEmpty()) {
            return;
        }
        if (this.client.getAccountFolders().isEmpty()) {
            return;
        }
        if (this.frameMode == FrameMode.COMPACT) {
            this.setFrameMode(FrameMode.NORMAL);
        }
    }

    public int getSelectedMainTabIndex() {
        return this.mainTabbedPane.getSelectedTabIndex();
    }

    public void showFoldersTab() {
        this.mainTabbedPane.setActiveTab(0);
    }

    public void showInlineInfoPanel(JPanel jPanel, String string) {
        RootPaneUI rootPaneUI = this.uiComponent.getRootPane().getUI();
        if (rootPaneUI instanceof SyntheticaRootPaneUI) {
            ((SyntheticaRootPaneUI)rootPaneUI).setMaximizedBounds(this.uiComponent);
        }
        this.inlineInfoPanel = jPanel;
        this.inlineInfoLabel.setText(string);
        this.configureInlineInfo();
    }

    private void closeInlineInfoPanel() {
        this.inlineInfoPanel = null;
        this.configureInlineInfo();
    }

    public boolean isShowingInfoInline() {
        return this.inlineInfoPanel != null;
    }

    private void configureInlineInfo() {
        boolean bl = this.isShowingInfoInline();
        this.inlineInfoCloseButton.setVisible(bl);
        if (bl) {
            this.centralPanel.removeAll();
            this.split.setLeftComponent(this.mainTabbedPane.getUIComponent());
            this.split.setRightComponent(this.inlineInfoPanel);
            this.centralPanel.add((Component)this.split, "Center");
        } else {
            this.split.setLeftComponent(new JPanel());
            this.split.setRightComponent(new JPanel());
            this.centralPanel.removeAll();
            this.centralPanel.add((Component)this.mainTabbedPane.getUIComponent(), "Center");
            this.inlineInfoPanel = null;
            this.inlineInfoLabel.setText("");
        }
        if (this.frameMode == FrameMode.NORMAL) {
            this.configureNormalSize();
        }
    }

    public void toFront() {
        this.uiComponent.setVisible(true);
        int n = this.uiComponent.getExtendedState();
        this.uiComponent.setExtendedState(n &= 0xFFFFFFFE);
        this.uiComponent.toFront();
        this.uiComponent.requestFocus();
    }

    private void doCloseOperation() {
        if (OSUtil.isSystraySupported()) {
            boolean bl;
            if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
                this.handleExitFirstRequest();
            }
            if (bl = PreferencesEntry.QUIT_ON_X.getValueBoolean(this.getController()).booleanValue()) {
                this.exitProgram();
            } else {
                this.getUIController().hideChildPanels();
                this.uiComponent.setVisible(false);
            }
        } else {
            this.exitProgram();
        }
    }

    private void doMinusOperation() {
        if (OSUtil.isLinux() && LinuxUtil.isNotKDE()) {
            this.getUIComponent().setVisible(false);
        } else {
            this.setFrameMode(FrameMode.MINIMIZED);
        }
    }

    private void doPlusOperation() {
        if (this.frameMode == FrameMode.MAXIMIZED) {
            this.setFrameMode(FrameMode.NORMAL);
        } else {
            this.setFrameMode(FrameMode.MAXIMIZED);
        }
    }

    private void exitProgram() {
        if (this.getUIController().isShutdownAllowed()) {
            this.uiComponent.setVisible(false);
            this.uiComponent.dispose();
            new Thread("Close PowerFolder Thread"){

                @Override
                public void run() {
                    MainFrame.this.getController().exit(0);
                }
            }.start();
        }
    }

    private void configurePauseResumeLink() {
        if (this.getController().isPaused()) {
            this.pauseResumeActionLabel.setText(Translation.get("action_resume_sync.name"));
            this.pauseResumeActionLabel.setToolTipText(Translation.get("action_resume_sync.description"));
        } else {
            this.pauseResumeActionLabel.setText(Translation.get("action_pause_sync.name"));
            this.pauseResumeActionLabel.setToolTipText(Translation.get("action_pause_sync.description"));
        }
    }

    private void updateOnlineStorageDetails() {
        this.osStatusUpdater.schedule(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.updateOnlineStorageDetails0();
            }
        });
    }

    private void updateOnlineStorageDetails0() {
        double d = 0.0;
        long l = 0L;
        long l2 = 0L;
        boolean bl = true;
        if (StringUtils.isBlank(this.client.getUsername())) {
            this.loginActionLabel.setText(Translation.get("main_frame.account_not_set.text"));
        } else if (this.client.isPasswordRequired() && this.client.isPasswordEmpty()) {
            this.loginActionLabel.setText(Translation.get("main_frame.password_required.text"));
        } else if (this.client.isConnected()) {
            if (this.client.isLoggedIn()) {
                String string = "";
                AccountDetails accountDetails = this.client.getAccountDetails();
                if (accountDetails.getAccount().hasOwnStorage()) {
                    l = accountDetails.getAccount().getOSSubscription().getStorageSize();
                    l2 = accountDetails.getSpaceUsed();
                    d = 100.0 * (double)l2 / (double)l;
                    d = Math.max(0.0, d);
                    d = Math.min(100.0, d);
                    if (accountDetails.isSpaceExceededOrDisabled()) {
                        string = Translation.get("main_frame.storage_subscription_disabled.text");
                    }
                } else {
                    bl = false;
                }
                String string2 = accountDetails.getAccount().getDisplayName();
                if (string.isBlank() && StringUtils.isNotBlank(string2)) {
                    string = string2;
                }
                this.loginActionLabel.setText(string);
            } else if (this.client.isLoggingIn() || !this.client.isLoginExecuted()) {
                this.loginActionLabel.setText(" ");
            } else {
                this.loginActionLabel.setText(Translation.get("main_frame.log_in_failed.text_click"));
                if (!PFWizard.isWizardOpen() && this.client.isPasswordRequired()) {
                    this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice(new SimpleNotificationNotice(Translation.get("main_frame.log_in_failed.text"), Translation.get("exp.uilock.dialog.error.wronglogin")));
                    PFWizard.openLoginWizard(this.getController(), this.client);
                }
            }
        } else {
            this.loginActionLabel.setText(" ");
        }
        this.noStorageText.setVisible(!bl);
        this.usagePB.setVisible(bl);
        this.usagePB.setValue((int)d);
        this.usagePB.setToolTipText(Format.formatBytesShort(l2) + " / " + Format.formatBytesShort(l));
    }

    private void setFrameMode(FrameMode frameMode) {
        this.frameStateSet.set(true);
        this.setFrameMode(frameMode, false);
    }

    private void setFrameMode(FrameMode frameMode, boolean bl) {
        this.frameMode = frameMode;
        this.centralPanel.setVisible(true);
        switch (frameMode) {
            case MAXIMIZED: {
                if (this.uiComponent.getRootPane().getUI() instanceof SyntheticaRootPaneUI) {
                    ((SyntheticaRootPaneUI)this.uiComponent.getRootPane().getUI()).setMaximizedBounds(this.uiComponent);
                }
                this.uiComponent.setExtendedState(6);
                this.plusButton.setToolTipText(Translation.get("main_frame.compact.tips"));
                this.plusButton.setIcons(Icons.getIconById("window_plus_normal.icon"), Icons.getIconById("window_plus_hover.icon"), Icons.getIconById("window_plus_push.icon"));
                this.minusButton.setToolTipText(Translation.get("main_frame.minimize.tips"));
                this.minusButton.setVisible(OSUtil.isSystraySupported());
                this.checkSplitMinWidth();
                break;
            }
            case NORMAL: {
                this.uiComponent.setExtendedState(0);
                this.uiComponent.setResizable(true);
                this.plusButton.setToolTipText(Translation.get("main_frame.maximize.tips"));
                this.plusButton.setIcons(Icons.getIconById("window_maximize_normal.icon"), Icons.getIconById("window_maximize_hover.icon"), Icons.getIconById("window_maximize_push.icon"));
                this.minusButton.setToolTipText(Translation.get("main_frame.minimize.tips"));
                this.minusButton.setVisible(OSUtil.isSystraySupported());
                this.configureNormalSize();
                UIUtil.invokeLaterInEDT(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.configureNormalSize();
                    }
                });
                break;
            }
            case COMPACT: {
                this.uiComponent.setExtendedState(0);
                if (!bl) {
                    this.hideInlineInfoPanel();
                }
                this.uiComponent.setSize(this.uiComponent.getMinimumSize());
                this.uiComponent.setResizable(false);
                this.plusButton.setToolTipText(Translation.get("main_frame.maximize.tips"));
                this.plusButton.setIcons(Icons.getIconById("window_maximize_normal.icon"), Icons.getIconById("window_maximize_hover.icon"), Icons.getIconById("window_maximize_push.icon"));
                this.minusButton.setToolTipText(Translation.get("main_frame.minimize.tips"));
                this.minusButton.setVisible(OSUtil.isSystraySupported());
                this.toFront();
                UIUtil.invokeLaterInEDT(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.uiComponent.setSize(MainFrame.this.uiComponent.getMinimumSize());
                    }
                });
                if (!bl) break;
                this.centralPanel.setVisible(false);
                break;
            }
            case MINIMIZED: {
                this.uiComponent.setExtendedState(1);
            }
        }
    }

    public void hideInlineInfoPanel() {
        this.closeInlineInfoPanel();
        this.getUIController().hideChildPanels();
    }

    private void configureNormalSize() {
        int n = this.isShowingInfoInline() ? 1100 : (int)this.uiComponent.getMinimumSize().getWidth();
        int n2 = 600;
        this.uiComponent.setSize(n, n2);
        this.checkSplitMinWidth();
    }

    private void checkSplitMinWidth() {
        if (this.isShowingInfoInline()) {
            if (this.split.getDividerLocation() < 300) {
                this.split.setDividerLocation(300);
            }
            UIUtil.invokeLaterInEDT(new Runnable(){

                @Override
                public void run() {
                    if (MainFrame.this.split.getDividerLocation() < 300) {
                        MainFrame.this.split.setDividerLocation(300);
                    }
                }
            });
        }
    }

    private void setLinkTooltips() {
        if (this.getController().isPaused()) {
            this.upperMainTextActionLabel.setToolTipText(Translation.get("action_resume_sync.description"));
            this.lowerMainTextActionLabel.setToolTipText(Translation.get("action_resume_sync.description"));
        } else if (this.frameMode == FrameMode.COMPACT) {
            this.upperMainTextActionLabel.setToolTipText(Translation.get("action_expand_interface.name"));
            this.lowerMainTextActionLabel.setToolTipText(Translation.get("action_expand_interface.name"));
        } else if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            this.upperMainTextActionLabel.setToolTipText(Translation.get("action_collapse_interface.name"));
            this.lowerMainTextActionLabel.setToolTipText(Translation.get("action_collapse_interface.name"));
        } else {
            this.upperMainTextActionLabel.setToolTipText(Translation.get("main_frame.minimal.change_loging.tip"));
            this.lowerMainTextActionLabel.setToolTipText(Translation.get("main_frame.minimal.change_loging.tip"));
        }
    }

    private static enum FrameMode {
        MAXIMIZED,
        NORMAL,
        COMPACT,
        MINIMIZED;

    }

    private class MyFolderRepositoryListener
    extends FolderRepositoryAdapter {
        private MyFolderRepositoryListener() {
        }

        @Override
        public void folderRemoved(FolderRepositoryEvent folderRepositoryEvent) {
            if (MainFrame.this.isShowingInfoInline()) {
                MainFrame.this.closeInlineInfoPanel();
            }
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            if (MainFrame.this.isShowingInfoInline()) {
                MainFrame.this.closeInlineInfoPanel();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            try {
                Transferable transferable = transferSupport.getTransferable();
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (list == null || list.size() != 1) {
                    MainFrame.this.logInfo("Skipping importData (multiple).");
                    return false;
                }
                Path path = (Path)list.get(0);
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    MainFrame.this.logInfo("Skipping importData (not directory).");
                    return false;
                }
                if (!MainFrame.this.getController().getOSClient().isAllowedToCreateFolders()) {
                    MainFrame.this.logInfo("Skipping importData (no folder create permission).");
                    return false;
                }
                if (MainFrame.this.getController().getFolderRepository().doesFolderAlreadyExist(path)) {
                    MainFrame.this.logInfo("Skipping importData (already have).");
                    return false;
                }
                PFWizard.openExistingDirectoryWizard(MainFrame.this.getController(), path);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                MainFrame.this.logSevere(unsupportedFlavorException);
                return false;
            }
            catch (IOException iOException) {
                MainFrame.this.logSevere(iOException);
                return false;
            }
            return true;
        }
    }

    private class MyWindowFocusListener
    implements WindowFocusListener {
        private MyWindowFocusListener() {
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
            MainFrame.this.getUIController().setActiveFrame(0);
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
        }
    }

    private class MySetupAction
    extends BaseAction {
        protected MySetupAction(Controller controller) {
            super(null, controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.getController().getNodeManager().isStarted() && MainFrame.this.getApplicationModel().getLicenseModel().getActivationAction() != null) {
                MainFrame.this.getApplicationModel().getLicenseModel().getActivationAction().actionPerformed(actionEvent);
            } else if (this.getController().getFolderRepository().getFoldersCount() == 0) {
                MainFrame.this.getApplicationModel().getActionModel().getNewFolderAction().actionPerformed(actionEvent);
            }
        }
    }

    private static class MyOpenFoldersBaseAction
    extends BaseAction {
        private MyOpenFoldersBaseAction(Controller controller) {
            super("action_open_folders_base", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
                this.getUIController().getApplicationModel().openExplorerWebDAVPath();
            } else {
                this.getUIController().getApplicationModel().openExplorer();
            }
        }
    }

    private class MyPauseResumeAction
    extends BaseAction {
        private MyPauseResumeAction(Controller controller) {
            super("action_resume_sync", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getUIController().askToPauseResume();
        }
    }

    private class MyShowNoticesAction
    extends BaseAction {
        MyShowNoticesAction(Controller controller) {
            super("action_show_notices", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.frameMode == FrameMode.COMPACT) {
                MainFrame.this.setFrameMode(FrameMode.NORMAL);
            }
            if (this.getController().getUIController().getApplicationModel().getNoticesModel().getUnreadNoticesCount() > 0) {
                this.getController().getUIController().openNoticesCard();
            } else if (this.getController().getFolderRepository().getFolderProblemsCount() > 0) {
                for (Folder folder : this.getController().getFolderRepository().getFolders()) {
                    if (folder.getProblems().size() <= 0) continue;
                    this.getController().getUIController().openProblemsInformation(folder.getInfo());
                    MainFrame.this.mainTabbedPane.getFoldersTab().getFoldersList().scrollToFolderInfo(folder.getInfo());
                    this.getController().getUIController().openProblemsInformation(folder.getInfo());
                    break;
                }
            } else {
                MainFrame.this.logFine("No Notices and no Problems to show");
            }
        }
    }

    private class MyLoginAction
    extends BaseAction {
        MyLoginAction(Controller controller) {
            super("action_login", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AccountDetails accountDetails;
            if (MainFrame.this.client.isLoggedIn() && (accountDetails = MainFrame.this.client.getAccountDetails()).isSpaceExceededOrDisabled()) {
                this.getController().getIOProvider().startIO(CloudStorageNotice.full().getPayload(this.getController()));
                return;
            }
            if (this.getController().getNodeManager().isStarted() || MainFrame.this.getApplicationModel().getLicenseModel().getActivationAction() == null) {
                PFWizard.openLoginWizard(this.getController(), MainFrame.this.client);
            } else {
                MainFrame.this.getApplicationModel().getLicenseModel().getActivationAction().actionPerformed(actionEvent);
            }
        }
    }

    private class MyOpenWebInterfaceAction
    extends BaseAction {
        private MyOpenWebInterfaceAction(Controller controller) {
            super("action_open_web_interface", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserLauncher.open(this.getController(), new BrowserLauncher.URLProducer(){

                @Override
                public String url() {
                    return MainFrame.this.client.getLoginURLWithCredentials();
                }
            });
        }
    }

    private static class MyOpenPreferencesAction
    extends BaseAction {
        private MyOpenPreferencesAction(Controller controller) {
            super("action_open_preferences", controller);
            this.allowWith(ChangePreferencesPermission.INSTANCE);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getUIController().openPreferences();
        }
    }

    private class MyOpenDebugAction
    extends BaseAction {
        private MyOpenDebugAction(Controller controller) {
            super("action_open_debug_information", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.frameMode == FrameMode.COMPACT) {
                MainFrame.this.setFrameMode(FrameMode.NORMAL);
            }
            this.getUIController().openDebugInformation();
        }
    }

    private class MyOpenTransfersAction
    extends BaseAction {
        private MyOpenTransfersAction(Controller controller) {
            super("exp.action_open_transfers_information", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.frameMode == FrameMode.COMPACT) {
                MainFrame.this.setFrameMode(FrameMode.NORMAL);
            }
            this.getUIController().openTransfersInformation();
        }
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            MainFrame.this.doCloseOperation();
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            if (LinuxUtil.isNotKDE()) {
                // empty if block
            }
        }
    }

    private class MyMouseWindowDragListener
    extends MouseAdapter {
        private static final int UPDATE_INTERVAL = 30;
        private boolean inDrag;
        private WindowDragManager dragManager;

        private MyMouseWindowDragListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (MainFrame.this.isMaximized()) {
                    MainFrame.this.setFrameMode(FrameMode.NORMAL);
                } else {
                    MainFrame.this.setFrameMode(FrameMode.MAXIMIZED);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (MainFrame.this.isMaximized()) {
                return;
            }
            this.dragManager = new WindowDragManager(MainFrame.this.uiComponent, 30);
            this.dragManager.start(mouseEvent);
            this.inDrag = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (MainFrame.this.isMaximized()) {
                return;
            }
            this.dragManager.stop(mouseEvent);
            this.inDrag = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (MainFrame.this.isMaximized()) {
                return;
            }
            if (this.inDrag) {
                this.dragManager.update(mouseEvent);
            }
        }
    }

    private class MyInlineCloseInfoActionListener
    implements ActionListener {
        private MyInlineCloseInfoActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MainFrame.this.inlineInfoCloseButton) {
                MainFrame.this.closeInlineInfoPanel();
            }
        }
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            MainFrame.this.updateOnlineStorageDetails();
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            MainFrame.this.showOSFolderList();
            MainFrame.this.updateOnlineStorageDetails();
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            MainFrame.this.updateOnlineStorageDetails();
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            MainFrame.this.updateOnlineStorageDetails();
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            MainFrame.this.updateOnlineStorageDetails();
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
            MainFrame.this.updateOnlineStorageDetails();
        }
    }

    private class MyPausedModeListener
    implements PausedModeListener {
        private MyPausedModeListener() {
        }

        @Override
        public void setPausedMode(PausedModeEvent pausedModeEvent) {
            MainFrame.this.configurePauseResumeLink();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

