/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.message.FileChunk;
import de.dal33t.powerfolder.message.FileChunkExt;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.ReplyFilePartsRecord;
import de.dal33t.powerfolder.message.RequestDownload;
import de.dal33t.powerfolder.message.RequestFilePartsRecord;
import de.dal33t.powerfolder.message.RequestPart;
import de.dal33t.powerfolder.message.StartUpload;
import de.dal33t.powerfolder.message.StartUploadExt;
import de.dal33t.powerfolder.message.StopUpload;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.transfer.Transfer;
import de.dal33t.powerfolder.transfer.TransferException;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.TransferProblem;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.DateUtil;
import de.dal33t.powerfolder.util.ProgressListener;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.delta.FilePartsRecord;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;

public class Upload
extends Transfer {
    private boolean aborted;
    private transient Queue<Message> pendingRequests = new LinkedList<Message>();
    protected transient FileChannel fileChannel;
    protected transient InputStream in;
    private long inpos;
    private String debugState;
    private byte[] buffer;

    Upload(TransferManager transferManager, Member member, RequestDownload requestDownload) {
        super(transferManager, requestDownload == null ? null : requestDownload.file, member);
        if (requestDownload == null) {
            throw new NullPointerException("Download request is null");
        }
        if (requestDownload.file == null) {
            throw new NullPointerException("File is null");
        }
        this.setStartOffset(requestDownload.startOffset);
        this.aborted = false;
        this.debugState = "initialized";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessage(Message message) {
        try {
            Queue<Message> queue = this.pendingRequests;
            synchronized (queue) {
                if (this.pendingRequests.size() >= this.getTransferManager().getMaxRequestsQueued() * 5) {
                    throw new TransferException("Too many requests queued: " + this.pendingRequests.size() + ", maximum: " + this.getTransferManager().getMaxRequestsQueued() * 5);
                }
                this.pendingRequests.add(message);
                this.pendingRequests.notifyAll();
            }
        }
        catch (TransferException transferException) {
            this.logSevere("TransferException", transferException);
            this.getTransferManager().uploadBroken(this, TransferProblem.TRANSFER_EXCEPTION, transferException.getMessage());
        }
    }

    public void enqueuePartRequest(RequestPart requestPart) {
        Reject.ifNull(requestPart, "Message is null");
        if (this.aborted || !this.isStarted()) {
            return;
        }
        if (!requestPart.getFile().isVersionDateAndSizeIdentical(this.getFile()) || requestPart.getRange().getLength() <= 0L) {
            this.logSevere("Received invalid part request!");
            this.getTransferManager().uploadBroken(this, TransferProblem.INVALID_PART);
            return;
        }
        if (requestPart.getRange().getLength() > (long)this.getTransferManager().getMaxFileChunkSize() && this.isFine()) {
            this.logFine("Got request for a range bigger then my max filechunk size (" + requestPart.getRange() + "): " + requestPart.getRange().getLength() + " on " + this.getFile().toDetailString());
        }
        this.state.setProgress(requestPart.getProgress());
        this.enqueueMessage(requestPart);
    }

    public void receivedFilePartsRecordRequest(RequestFilePartsRecord requestFilePartsRecord) {
        Reject.ifNull(requestFilePartsRecord, "Record is null");
        if (this.isFine()) {
            this.logFine("Received request for a parts record: " + requestFilePartsRecord);
        }
        if (this.aborted || !this.isStarted()) {
            return;
        }
        if (this.getFile().getSize() < 8192L) {
            this.logWarning("Remote side requested invalid PartsRecordRequest!");
            this.getTransferManager().uploadBroken(this, TransferProblem.GENERAL_EXCEPTION, "Remote side requested invalid PartsRecordRequest!");
            return;
        }
        this.enqueueMessage(requestFilePartsRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUploadRequest(StopUpload stopUpload) {
        Reject.ifNull(stopUpload, "Message is null");
        Queue<Message> queue = this.pendingRequests;
        synchronized (queue) {
            this.pendingRequests.clear();
            this.pendingRequests.add(stopUpload);
            this.pendingRequests.notifyAll();
        }
    }

    synchronized void start() {
        if (this.isStarted()) {
            this.logFine("Upload already started. " + this);
            return;
        }
        if (this.isAborted() || this.isBroken()) {
            this.logFine("Upload already broken/aborted. " + this);
            return;
        }
        this.debugState = "Starting";
        this.setStarted();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long l;
                    if (Upload.this.isAborted() || Upload.this.isBroken()) {
                        throw new TransferException("Upload broken/aborted while starting. " + Upload.this);
                    }
                    Upload.this.debugState = "Opening file";
                    boolean bl = true;
                    Folder folder = Upload.this.getFile().getFolder(Upload.this.getController().getFolderRepository());
                    if (folder.getLocalBase().getFileSystem().provider().getScheme().equals("file")) {
                        bl = false;
                        Path path = null;
                        try {
                            path = Upload.this.getFile().getDiskFile(Upload.this.getController().getFolderRepository());
                            Upload.this.fileChannel = FileChannel.open(path, StandardOpenOption.READ);
                            int n = ConfigurationEntry.TRANSFER_BUFFER_THRESHOLD.getValueInt(Upload.this.getController());
                            l = Files.size(path);
                            if (l <= (long)n) {
                                Upload.this.logFine("Using buffer to upload file " + path);
                                ByteBuffer byteBuffer = ByteBuffer.allocate((int)l);
                                FileChannel fileChannel = Upload.this.fileChannel;
                                if (fileChannel != null) {
                                    fileChannel.read(byteBuffer, 0L);
                                    fileChannel.close();
                                    Upload.this.fileChannel = null;
                                }
                                Upload.access$202(Upload.this, byteBuffer.array());
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            bl = true;
                        }
                        catch (IOException iOException) {
                            Upload.this.logWarning("Could not read file " + path + " for upload.", iOException);
                        }
                    }
                    if (bl) {
                        try {
                            Upload.this.in = Files.newInputStream(Upload.this.getFile().getDiskFile(Upload.this.getController().getFolderRepository()), new OpenOption[0]);
                            Upload.this.inpos = 0L;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new TransferException(fileNotFoundException);
                        }
                        catch (IOException iOException) {
                            throw new TransferException(iOException);
                        }
                    }
                    if (Upload.this.isAborted() || Upload.this.isBroken()) {
                        throw new TransferException("Upload broken/aborted while starting. " + Upload.this);
                    }
                    if (Upload.this.isFiner()) {
                        Upload.this.logFiner("Both clients support partial transfers!");
                    }
                    Upload.this.debugState = "Sending StartUpload";
                    try {
                        if (Upload.this.getPartner().getProtocolVersion() >= 110) {
                            Upload.this.getPartner().sendMessage(new StartUploadExt(Upload.this.getFile()));
                        } else {
                            Upload.this.getPartner().sendMessage(new StartUpload(Upload.this.getFile()));
                        }
                    }
                    catch (ConnectionException connectionException) {
                        throw new TransferException(connectionException);
                    }
                    Upload.this.debugState = "Waiting for requests";
                    if (Upload.this.waitForRequests(180000L)) {
                        if (Upload.this.isFiner()) {
                            Upload.this.logFiner("Checking for parts request.");
                        }
                        Upload.this.debugState = "Checking for FPR request.";
                        if (Upload.this.checkForFilePartsRecordRequest()) {
                            Upload.this.debugState = "Waiting for remote matching";
                            Upload.this.state.setState(Transfer.TransferState.REMOTEMATCHING);
                            Upload.this.logFiner("Waiting for initial part requests!");
                            Upload.this.waitForRequests(18000000L);
                        }
                        Upload.this.debugState = "Starting to send parts";
                        if (Upload.this.isFine()) {
                            Upload.this.logFine("Started " + this);
                        }
                        long l2 = System.currentTimeMillis();
                        while (Upload.this.sendPart()) {
                        }
                        l = System.currentTimeMillis() - l2;
                        Upload.this.getTransferManager().logTransfer(false, Upload.this.aborted, l, Upload.this.getFile(), Upload.this.getPartner());
                    }
                    Upload.this.closeIO();
                    if (!Upload.this.isBroken() && !Upload.this.aborted) {
                        Upload.this.getTransferManager().setCompleted(Upload.this);
                    } else {
                        Upload.this.getTransferManager().uploadBroken(Upload.this, TransferProblem.TRANSFER_EXCEPTION, "Upload broken or aborted while sending parts");
                    }
                }
                catch (TransferException transferException) {
                    Upload.this.closeIO();
                    Upload.this.getTransferManager().uploadBroken(Upload.this, TransferProblem.TRANSFER_EXCEPTION, transferException.getMessage());
                }
                finally {
                    Upload.this.closeIO();
                    Upload.this.debugState = "DONE";
                }
            }

            public String toString() {
                return "Upload " + Upload.this.getFile().toDetailString() + " to " + Upload.this.getPartner().getNick();
            }
        };
        this.getTransferManager().perfomUpload(runnable);
    }

    private synchronized void closeIO() {
        if (this.in != null) {
            try {
                this.in.close();
                this.in = null;
            }
            catch (IOException iOException) {
                this.logSevere("IOException", iOException);
            }
        }
        if (this.fileChannel != null) {
            try {
                if (this.isFiner()) {
                    this.logFiner("Closing fileChannel for " + this.getFile().toDetailString());
                }
                this.fileChannel.close();
                this.fileChannel = null;
            }
            catch (IOException iOException) {
                this.logSevere("IOException", iOException);
            }
        }
        if (this.buffer != null) {
            this.buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkForFilePartsRecordRequest() throws TransferException {
        RequestFilePartsRecord requestFilePartsRecord = null;
        Object object = this.pendingRequests;
        synchronized (object) {
            if (this.pendingRequests.isEmpty()) {
                this.logFine(this.getFile() + ": Cancelled message too fast");
                return false;
            }
            if (this.pendingRequests.peek() instanceof RequestFilePartsRecord) {
                requestFilePartsRecord = (RequestFilePartsRecord)this.pendingRequests.remove();
            }
        }
        if (requestFilePartsRecord == null) {
            return false;
        }
        object = requestFilePartsRecord.getFile();
        try {
            this.checkLastModificationDate((FileInfo)object, ((FileInfo)object).getDiskFile(this.getController().getFolderRepository()));
            this.state.setState(Transfer.TransferState.FILEHASHING);
            FilePartsRecord filePartsRecord = this.getTransferManager().getFileRecordManager().retrieveRecord((FileInfo)object, new ProgressListener(){

                @Override
                public void progressReached(double d) {
                    Upload.this.state.setProgress(d);
                }
            });
            this.getPartner().sendMessagesAsynchron(new ReplyFilePartsRecord((FileInfo)object, filePartsRecord));
            this.state.setState(Transfer.TransferState.UPLOADING);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logWarning("FileNotFoundException" + fileNotFoundException);
            this.getTransferManager().uploadBroken(this, TransferProblem.FILE_NOT_FOUND_EXCEPTION, fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.logWarning("IOException: " + iOException);
            this.getTransferManager().uploadBroken(this, TransferProblem.IO_EXCEPTION, iOException.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPart() throws TransferException {
        if (this.getPartner() == null) {
            throw new NullPointerException("Upload member is null");
        }
        if (this.getFile() == null) {
            throw new NullPointerException("Upload file is null");
        }
        if (this.isAborted() || this.isBroken()) {
            return false;
        }
        this.state.setState(Transfer.TransferState.UPLOADING);
        RequestPart requestPart = null;
        long l = 18000000L;
        Iterable<Message> iterable = this.pendingRequests;
        synchronized (iterable) {
            while (this.pendingRequests.isEmpty() && !this.isBroken() && !this.isAborted()) {
                try {
                    this.pendingRequests.wait(l);
                    l = 180000L;
                }
                catch (InterruptedException interruptedException) {
                    this.logFine("Interrupted on " + this + ". " + interruptedException);
                    this.logFiner(interruptedException);
                    throw new TransferException(interruptedException);
                }
            }
            if (this.pendingRequests.isEmpty()) {
                return false;
            }
            if (this.pendingRequests.peek() instanceof StopUpload) {
                this.pendingRequests.remove();
                return false;
            }
            requestPart = (RequestPart)this.pendingRequests.remove();
            if (this.isAborted() || this.isBroken()) {
                return false;
            }
        }
        iterable = requestPart.getFile().getDiskFile(this.getController().getFolderRepository());
        try {
            int n;
            byte[] byArray = new byte[(int)requestPart.getRange().getLength()];
            long l2 = requestPart.getRange().getStart();
            if (this.fileChannel != null) {
                this.fileChannel.position(l2);
            } else if (this.in != null) {
                long l3 = l2 - this.inpos;
                if (l3 >= 0L) {
                    this.inpos += this.in.skip(l3);
                } else {
                    try {
                        try {
                            this.in.close();
                        }
                        catch (Exception exception) {
                            this.logWarning(exception.toString());
                        }
                        this.in = Files.newInputStream(this.getFile().getDiskFile(this.getController().getFolderRepository()), new OpenOption[0]);
                        this.in.skip(l2);
                        this.inpos = l2;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new TransferException(fileNotFoundException);
                    }
                }
            }
            for (int i = 0; i < byArray.length; i += n) {
                int n2 = byArray.length - i;
                if (this.buffer != null && (long)this.buffer.length >= l2 + requestPart.getRange().getLength()) {
                    byArray = Arrays.copyOfRange(this.buffer, (int)l2, (int)(l2 + requestPart.getRange().getLength()));
                    n = byArray.length;
                } else if (this.fileChannel != null) {
                    n = this.fileChannel.read(ByteBuffer.wrap(byArray, i, n2));
                } else if (this.in != null) {
                    n = this.in.read(byArray, i, n2);
                    this.inpos += (long)n;
                } else {
                    throw new TransferException("I/O already closed");
                }
                if (n >= 0) continue;
                this.logWarning("Requested part exceeds filesize!");
                throw new TransferException("Requested part exceeds filesize!");
            }
            FileChunk fileChunk = this.getPartner().getProtocolVersion() >= 110 ? new FileChunkExt(requestPart.getFile(), requestPart.getRange().getStart(), byArray) : new FileChunk(requestPart.getFile(), requestPart.getRange().getStart(), byArray);
            this.getPartner().sendMessage(fileChunk);
            this.getCounter().chunkTransferred(fileChunk);
            this.getTransferManager().getUploadCounter().chunkTransferred(fileChunk);
            this.checkLastModificationDate(requestPart.getFile(), (Path)iterable);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logWarning(iterable + ": FileNotFoundException: " + fileNotFoundException);
            throw new TransferException(fileNotFoundException);
        }
        catch (IOException iOException) {
            this.logWarning(iterable + ": IOException: " + iOException);
            throw new TransferException(iOException);
        }
        catch (ConnectionException connectionException) {
            this.logFine("Connection problem while uploading. " + connectionException.toString());
            if (this.isFiner()) {
                this.logFiner("ConnectionException", connectionException);
            }
            throw new TransferException(connectionException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForRequests(long l) {
        if (this.isBroken() || this.aborted) {
            return false;
        }
        Queue<Message> queue = this.pendingRequests;
        synchronized (queue) {
            if (!this.pendingRequests.isEmpty()) {
                return true;
            }
            try {
                this.pendingRequests.wait(l);
            }
            catch (InterruptedException interruptedException) {
                this.logFine("InterruptedException. " + interruptedException);
            }
        }
        return !this.isBroken() && !this.aborted && !this.pendingRequests.isEmpty();
    }

    synchronized void abort() {
        this.logFiner("Upload aborted: " + this);
        this.aborted = true;
        this.stopUploads();
    }

    @Override
    void shutdown() {
        super.shutdown();
        this.stopUploads();
        this.closeIO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopUploads() {
        Queue<Message> queue = this.pendingRequests;
        synchronized (queue) {
            this.pendingRequests.clear();
            this.pendingRequests.notifyAll();
        }
    }

    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public boolean isBroken() {
        Path path;
        if (super.isBroken()) {
            return true;
        }
        if (!this.stillQueuedAtPartner()) {
            this.logWarning("Upload broken because not enqueued @ partner: queedAtPartner: " + this.stillQueuedAtPartner() + ", folder: " + this.getFile().getFolder(this.getController().getFolderRepository()) + ", diskfile: " + this.getFile().getDiskFile(this.getController().getFolderRepository()) + ", last contime: " + this.getPartner().getLastConnectTime());
        }
        if ((path = this.getFile().getDiskFile(this.getController().getFolderRepository())) == null || Files.notExists(path, new LinkOption[0])) {
            if (!this.getFile().getFolderInfo().isMetaFolder()) {
                Level level = Level.WARNING;
                FileInfo fileInfo = this.getFile().getLocalFileInfo(this.getController().getFolderRepository());
                if (fileInfo != null && fileInfo.isDeleted()) {
                    level = Level.FINE;
                }
                this.logIt(level, "Upload broken because diskfile is not available, folder: " + this.getFile().getFolder(this.getController().getFolderRepository()) + ", diskfile: " + path + ", last contime: " + this.getPartner().getLastConnectTime(), null);
            }
            return true;
        }
        return !this.stillQueuedAtPartner();
    }

    public int hashCode() {
        int n = 0;
        if (this.getFile() != null) {
            n += this.getFile().hashCode();
        }
        if (this.getPartner() != null) {
            n += this.getPartner().hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof Upload) {
            Upload upload = (Upload)object;
            return Util.equals(this.getFile(), upload.getFile()) && Util.equals(this.getPartner(), upload.getPartner());
        }
        return false;
    }

    public String toString() {
        String string = "Upload: State: " + this.debugState + ", TransferState: " + this.state.getState() + " " + this.getFile().toDetailString() + " to '" + this.getPartner().getNick() + "'";
        if (this.getPartner().isOnLAN()) {
            string = string + " (local-net)";
        }
        return string;
    }

    private void checkLastModificationDate(FileInfo fileInfo, Path path) throws TransferException, IOException {
        boolean bl;
        assert (fileInfo != null);
        assert (path != null);
        boolean bl2 = bl = !DateUtil.equalsFileDateCrossPlattform(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis(), fileInfo.getModifiedDate().getTime());
        if (bl) {
            Folder folder = fileInfo.getFolder(this.getController().getFolderRepository());
            if (folder.isDeviceDisconnected() || folder.checkIfDeviceDisconnected()) {
                throw new TransferException("Storage/Device disconnected during upload");
            }
            if (folder.scanAllowedNow()) {
                folder.scanChangedFile(fileInfo);
            }
            throw new TransferException("Last modification date mismatch. '" + path.toAbsolutePath().toString() + "': expected " + Convert.convertToGlobalPrecision(fileInfo.getModifiedDate().getTime()) + ", actual " + Convert.convertToGlobalPrecision(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()));
        }
    }

    static /* synthetic */ byte[] access$202(Upload upload, byte[] byArray) {
        upload.buffer = byArray;
        return byArray;
    }
}

