/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Reject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class TransferPriorities
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Comparator<FileInfo> priorityComparator;
    private Map<FileInfo, TransferPriority> priorities = new HashMap<FileInfo, TransferPriority>();

    public TransferPriorities() {
        this.priorityComparator = new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo fileInfo, FileInfo fileInfo2) {
                return TransferPriorities.this.getPriority(fileInfo2).compareTo(TransferPriorities.this.getPriority(fileInfo));
            }
        };
        this.validatePriorities();
    }

    public Comparator<FileInfo> getComparator() {
        return this.priorityComparator;
    }

    public synchronized TransferPriority getPriority(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "File is null");
        TransferPriority transferPriority = this.priorities.get(fileInfo);
        assert (transferPriority != TransferPriority.NORMAL);
        return transferPriority != null ? transferPriority : TransferPriority.NORMAL;
    }

    public synchronized void setPriority(FileInfo fileInfo, TransferPriority transferPriority) {
        Reject.noNullElements(new Object[]{fileInfo, transferPriority});
        if (transferPriority == TransferPriority.NORMAL) {
            this.priorities.remove(fileInfo);
        } else {
            this.priorities.put(fileInfo, transferPriority);
        }
    }

    public synchronized void removeFile(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "Fileinfo is null");
        this.priorities.remove(fileInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.validatePriorities();
    }

    private void validatePriorities() {
        Reject.ifNull(this.priorities, "Priorities are null");
        assert (!this.priorities.values().contains((Object)TransferPriority.NORMAL)) : "Found 'NORMAL' files!";
    }

    public static enum TransferPriority {
        LOW,
        NORMAL,
        HIGH;

    }
}

