/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileHistory;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.FileHistoryReply;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.ProblemUtil;
import de.dal33t.powerfolder.util.Profiling;
import de.dal33t.powerfolder.util.ProfilingEntry;
import de.dal33t.powerfolder.util.Reject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FileRequestor
extends PFComponent {
    private final Queue<Worker> workerPool;
    private final Queue<Folder> folderQueue;
    private final Queue<FileInfo> pendingRequests;
    private long workerInterval = 1000L * (long)ConfigurationEntry.FILE_REQUESTOR_INTERVAL.getValueInt(this.getController()).intValue();
    private long workerTimeout = this.workerInterval * 30L;

    public FileRequestor(Controller controller) {
        super(controller);
        this.folderQueue = new ConcurrentLinkedQueue<Folder>();
        this.pendingRequests = new ConcurrentLinkedQueue<FileInfo>();
        this.workerPool = new ConcurrentLinkedQueue<Worker>();
    }

    public void start() {
        this.logFine("Started");
        this.getController().scheduleAndRepeat(new PeriodicalTriggerTask(), this.workerInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerFileRequesting(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder is null");
        Folder folder = folderInfo.getFolder(this.getController());
        if (folder == null) {
            this.logWarning("Folder not joined, not requesting files: " + folderInfo);
            return;
        }
        if (this.folderQueue.contains(folder)) {
            return;
        }
        Queue<Folder> queue = this.folderQueue;
        synchronized (queue) {
            if (this.folderQueue.contains(folder)) {
                return;
            }
            this.folderQueue.offer(folder);
            this.addWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerFileRequesting() {
        ProfilingEntry profilingEntry = Profiling.start();
        Collection<Folder> collection = this.getController().getFolderRepository().getFolders(true);
        Queue<Folder> queue = this.folderQueue;
        synchronized (queue) {
            for (Folder folder : collection) {
                if (this.folderQueue.contains(folder)) continue;
                this.folderQueue.offer(folder);
                this.addWorker();
            }
        }
        Profiling.end(profilingEntry, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        for (Worker worker : this.workerPool) {
            worker.stopped = true;
        }
        Queue<Folder> queue = this.folderQueue;
        synchronized (queue) {
            this.folderQueue.notifyAll();
        }
        this.logFine("Stopped");
    }

    public void requestMissingFiles(Folder folder, boolean bl) {
        if (!folder.hasOwnDatabase()) {
            return;
        }
        Collection<FileInfo> collection = folder.getIncomingFiles(false, 100);
        this.retrieveNewestVersions(folder, collection, bl);
    }

    private void requestMissingFilesForAutodownload(Folder folder) {
        if (this.getController().isPaused()) {
            if (this.isFiner()) {
                this.logFiner("Paused: Skipping request of new files.");
            }
            return;
        }
        if (!folder.getSyncProfile().isAutodownload()) {
            if (this.isFiner()) {
                this.logFiner("Skipping " + folder + ". not on auto donwload");
            }
            return;
        }
        if (this.isFiner()) {
            this.logFiner(folder + ": Requesting files (autodownload), has own DB? " + folder.hasOwnDatabase());
        }
        if (!folder.isStarted()) {
            if (this.isFiner()) {
                this.logFiner("Not requesting files. Folder not started yet " + folder);
            }
            return;
        }
        if (folder.isDeviceDisconnected()) {
            if (this.isFine()) {
                this.logFine("Not requesting files. Device disconnected of " + folder);
            }
            return;
        }
        if (!folder.hasOwnDatabase()) {
            if (folder.isScanning() || folder.isDeviceDisconnected()) {
                if (this.isFine()) {
                    this.logFine("Not requesting files. No own database for " + folder);
                }
            } else if (this.isInfo()) {
                this.logInfo("Not requesting files. No own database for " + folder);
            }
            return;
        }
        if (folder.getCompletelyConnectedMembersCount() == 0) {
            if (this.isFiner()) {
                this.logFiner("Not requesting files. No member connected on " + folder);
            }
            return;
        }
        if (!folder.hasUploadCapacity()) {
            if (this.isFiner()) {
                this.logFiner("Not requesting files. Members of folder don't have upload capacity " + folder);
            }
            return;
        }
        Collection<FileInfo> collection = folder.getIncomingFiles(false, 100);
        if (collection.isEmpty()) {
            if (this.isFiner()) {
                this.logFiner("Not requesting files. No incoming files " + folder);
            }
            return;
        }
        if (this.isFine()) {
            this.logFine(collection.size() + " files found by file requestor: " + collection);
        }
        this.retrieveNewestVersions(folder, collection, true);
    }

    private void retrieveNewestVersions(Folder folder, Collection<FileInfo> collection, boolean bl) {
        TransferManager transferManager = this.getController().getTransferManager();
        ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>(collection.size());
        boolean bl2 = false;
        for (FileInfo fileInfo : collection) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (fileInfo.isDeleted() || fileInfo.isFile() && (transferManager.isDownloadingActive(fileInfo) || transferManager.isDownloadingPending(fileInfo))) continue;
            if (fileInfo.isFile()) {
                arrayList.add(fileInfo);
                continue;
            }
            if (!fileInfo.isDiretory()) continue;
            this.createDirectory((DirectoryInfo)fileInfo);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        Collections.sort(arrayList, folder.getTransferPriorities().getComparator());
        for (FileInfo fileInfo : arrayList) {
            try {
                FileInfo fileInfo2 = fileInfo.getNewestVersion(folder);
                if (fileInfo2 == null) {
                    this.logFine("Unable to download. Newest version not found: " + fileInfo.toDetailString());
                    continue;
                }
                this.prepareDownload(fileInfo2, bl);
            }
            catch (RuntimeException runtimeException) {
                this.logWarning("Unable to download: " + fileInfo.toDetailString() + ": " + runtimeException);
            }
        }
    }

    private void createDirectory(DirectoryInfo directoryInfo) {
        try {
            Path path = directoryInfo.getDiskFile(this.getController().getFolderRepository());
            Folder folder = directoryInfo.getFolder(this.getController().getFolderRepository());
            if (folder == null || path == null) {
                this.logWarning("Unable to created directory. not longer on folder: " + directoryInfo.toDetailString());
                return;
            }
            folder.scanDirectory(directoryInfo, path);
            if (this.isFine()) {
                this.logFine("Synced directory: " + directoryInfo.toDetailString());
            }
        }
        catch (RuntimeException runtimeException) {
            this.logWarning(directoryInfo + ": Unable to create directory. " + runtimeException);
        }
    }

    private void prepareDownload(FileInfo fileInfo, boolean bl) {
        TransferManager transferManager = this.getController().getTransferManager();
        transferManager.downloadNewestVersion(fileInfo, bl);
    }

    public void receivedFileHistory(final FileHistoryReply fileHistoryReply) {
        Reject.notNull(fileHistoryReply, "fhReply");
        if (!this.pendingRequests.remove(fileHistoryReply.getRequestFileInfo())) {
            this.logWarning("Received FileHistory for unrequested FileInfo " + fileHistoryReply.getRequestFileInfo());
            return;
        }
        this.getController().getIOProvider().startIO(new Runnable(){

            @Override
            public void run() {
                FileRequestor.this.checkForConflict(fileHistoryReply);
            }
        });
    }

    private void checkForConflict(FileHistoryReply fileHistoryReply) {
        FileInfo fileInfo = fileHistoryReply.getRequestFileInfo();
        FileHistory fileHistory = fileHistoryReply.getFileHistory();
        if (fileHistory == null) {
            this.logFine("Remote client claims not to have a history for " + fileInfo + ", not downloading!");
            this.logFine("That was a lie, since there are no FileHistories I'll download it anyways!");
            this.getController().getTransferManager().downloadNewestVersion(fileInfo, true);
        } else {
            FileHistory fileHistory2 = fileInfo.getFolder(this.getController().getFolderRepository()).getDAO().getFileHistory(fileInfo);
            if (fileHistory2 == null) {
                this.logSevere("Local FileHistory missing for " + fileInfo + ", not downloading!");
            } else {
                FileHistory.Conflict conflict = fileHistory2.getConflictWith(fileHistory);
                if (conflict != null) {
                    if (ProblemUtil.resolveConflict(conflict)) {
                        this.getController().getTransferManager().downloadNewestVersion(fileInfo, true);
                    }
                } else {
                    this.getController().getTransferManager().downloadNewestVersion(fileInfo, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorker() {
        Queue<Worker> queue = this.workerPool;
        synchronized (queue) {
            int n = this.workerPool.size();
            int n2 = ConfigurationEntry.FOLDER_FILE_REQUESTOR_MAX_WORKERS.getValueInt(this.getController());
            int n3 = 2 * ConfigurationEntry.FOLDER_FOLDERS_PER_FILE_REQUESTOR.getValueInt(this.getController());
            int n4 = Math.max(1, Math.min(n2, this.folderQueue.size() / n3));
            int n5 = n4 - n;
            if (this.isFiner() && n5 != 0) {
                this.logFiner("nWorkers: " + n + ", required: " + n4 + ". Diff: " + n5);
            }
            if (n4 == n2) {
                this.logWarning("Maximum number of workers reached: " + n2 + ". Try to increase this value by configuration");
            }
            for (int i = 0; i < n5; ++i) {
                Worker worker = new Worker();
                this.workerPool.add(worker);
                this.getController().schedule(worker, 100L * (long)i);
            }
        }
    }

    private final class PeriodicalTriggerTask
    extends TimerTask {
        private PeriodicalTriggerTask() {
        }

        @Override
        public void run() {
            FileRequestor.this.triggerFileRequesting();
            for (Worker worker : FileRequestor.this.workerPool) {
                if (!worker.isTimeout()) continue;
                FileRequestor.this.logWarning("Worker timed out detected. Restarting... " + worker);
                FileRequestor.this.logWarning(Debug.dumpCurrentStacktraces(true));
                worker.stopped = true;
            }
        }
    }

    private class Worker
    implements Runnable {
        private Date lastActivity = new Date();
        private volatile boolean stopped;

        private Worker() {
        }

        private boolean isTimeout() {
            long l = System.currentTimeMillis() - this.lastActivity.getTime();
            return l > FileRequestor.this.workerTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (FileRequestor.this.folderQueue.isEmpty()) {
                    return;
                }
                if (this.stopped) {
                    return;
                }
                int n = 0;
                if (FileRequestor.this.isFiner()) {
                    FileRequestor.this.logFiner("Started requesting files");
                }
                long l = System.currentTimeMillis();
                for (Folder folder : FileRequestor.this.folderQueue) {
                    if (this.stopped) {
                        return;
                    }
                    try {
                        FileRequestor.this.folderQueue.remove(folder);
                        FileRequestor.this.requestMissingFilesForAutodownload(folder);
                        if (++n % 5 != 0 || this.stopped) continue;
                        this.lastActivity = new Date();
                        if (FileRequestor.this.getMySelf().isServer()) continue;
                        Thread.sleep(1L);
                    }
                    catch (RuntimeException runtimeException) {
                        FileRequestor.this.logSevere("RuntimeException: " + runtimeException.toString(), runtimeException);
                    }
                }
                if (FileRequestor.this.isFine()) {
                    long l2 = System.currentTimeMillis() - l;
                    FileRequestor.this.logFine("Requesting files for " + n + " folder(s) took " + l2 + "ms.");
                    if (l2 > FileRequestor.this.workerInterval) {
                        FileRequestor.this.logWarning("Requesting files for " + n + " folder(s) took " + l2 + "ms.");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                FileRequestor.this.logFine("Stopped");
                FileRequestor.this.logFiner(interruptedException);
            }
            finally {
                this.stopped = true;
                FileRequestor.this.workerPool.remove(this);
                if (!FileRequestor.this.folderQueue.isEmpty()) {
                    FileRequestor.this.addWorker();
                }
            }
        }
    }
}

