/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.transfer.BandwidthLimiterInfo;
import java.util.Date;

public class CoalescedBandwidthStat
implements Comparable<CoalescedBandwidthStat> {
    private final Date date;
    private final BandwidthLimiterInfo info;
    private final long initialBandwidth;
    private final long residualBandwidth;
    private final long peakBandwidth;
    private final long count;

    public CoalescedBandwidthStat(Date date, BandwidthLimiterInfo bandwidthLimiterInfo, long l, long l2, long l3, long l4) {
        this.date = date;
        this.info = bandwidthLimiterInfo;
        this.initialBandwidth = l;
        this.residualBandwidth = l2;
        this.peakBandwidth = l3;
        this.count = l4;
    }

    public Date getDate() {
        return this.date;
    }

    public BandwidthLimiterInfo getInfo() {
        return this.info;
    }

    public long getInitialBandwidth() {
        return this.initialBandwidth;
    }

    public long getResidualBandwidth() {
        return this.residualBandwidth;
    }

    public long getPeakBandwidth() {
        return this.peakBandwidth;
    }

    public long getCount() {
        return this.count;
    }

    public long getUsedBandwidth() {
        return this.initialBandwidth - this.residualBandwidth;
    }

    public double getPercentageUsedBandwidth() {
        return this.initialBandwidth == 0L ? 0.0 : 100.0 * (double)this.getUsedBandwidth() / (double)this.initialBandwidth;
    }

    public double getAverageUsedBandwidth() {
        return this.count == 0L ? 0.0 : 1.0 * (double)this.getUsedBandwidth() / (double)this.count;
    }

    public String toString() {
        return "BandwidthStat{date=" + this.date + ", info=" + this.info + ", initialBandwidth=" + this.initialBandwidth + ", residualBandwidth=" + this.residualBandwidth + ", peakBandwidth=" + this.peakBandwidth + ", count=" + this.count + "}";
    }

    @Override
    public int compareTo(CoalescedBandwidthStat coalescedBandwidthStat) {
        if (this.date.compareTo(coalescedBandwidthStat.date) == 0) {
            return this.info.compareTo(coalescedBandwidthStat.info);
        }
        return this.date.compareTo(coalescedBandwidthStat.date);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CoalescedBandwidthStat coalescedBandwidthStat = (CoalescedBandwidthStat)object;
        if (!this.date.equals(coalescedBandwidthStat.date)) {
            return false;
        }
        return this.info == coalescedBandwidthStat.info;
    }

    public int hashCode() {
        int n = this.date.hashCode();
        n = 31 * n + this.info.hashCode();
        return n;
    }
}

