/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.transfer.BandwidthLimiter;
import de.dal33t.powerfolder.transfer.BandwidthStat;
import de.dal33t.powerfolder.transfer.BandwidthStatsListener;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class BandwidthProvider
extends Loggable {
    public static final int PERIOD = 1000;
    private final Map<BandwidthLimiter, Long> limits = new WeakHashMap<BandwidthLimiter, Long>();
    private ScheduledExecutorService scheduledES;
    private ScheduledFuture<?> task;
    private final BandwidthStatsListener statListenerSupport = ListenerSupportFactory.createListenerSupport(BandwidthStatsListener.class);

    public BandwidthProvider(ScheduledExecutorService scheduledExecutorService) {
        Reject.ifNull(scheduledExecutorService, "scheduledES");
        this.scheduledES = scheduledExecutorService;
    }

    public void start() {
        this.task = this.scheduledES.scheduleWithFixedDelay(() -> {
            Map<BandwidthLimiter, Long> map = this.limits;
            synchronized (map) {
                for (Map.Entry<BandwidthLimiter, Long> entry : this.limits.entrySet()) {
                    BandwidthLimiter bandwidthLimiter = entry.getKey();
                    if (bandwidthLimiter == null) continue;
                    Long l = entry.getValue();
                    BandwidthStat bandwidthStat = bandwidthLimiter.setAvailable(l > 0L ? 1000L * l / 1000L : -1L);
                    this.statListenerSupport.handleBandwidthStat(bandwidthStat);
                }
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimitBPS(BandwidthLimiter bandwidthLimiter, long l) {
        if (l >= 0L) {
            Map<BandwidthLimiter, Long> map = this.limits;
            synchronized (map) {
                this.limits.put(bandwidthLimiter, l);
            }
            this.logFiner("Bandwidth limiter " + bandwidthLimiter + " initalized, max CPS: " + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLimitBPS(BandwidthLimiter bandwidthLimiter) {
        Map<BandwidthLimiter, Long> map = this.limits;
        synchronized (map) {
            try {
                return this.limits.get(bandwidthLimiter);
            }
            catch (NullPointerException nullPointerException) {
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLimiter(BandwidthLimiter bandwidthLimiter) {
        Map<BandwidthLimiter, Long> map = this.limits;
        synchronized (map) {
            this.limits.remove(bandwidthLimiter);
        }
    }

    public void addBandwidthStatListener(BandwidthStatsListener bandwidthStatsListener) {
        ListenerSupportFactory.addListener(this.statListenerSupport, bandwidthStatsListener);
    }

    public void removeBandwidthStatListener(BandwidthStatsListener bandwidthStatsListener) {
        ListenerSupportFactory.addListener(this.statListenerSupport, bandwidthStatsListener);
    }
}

