/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.light.ServerInfo;
import de.dal33t.powerfolder.util.Base58;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@Table(appliesTo="Token", indexes={@Index(name="IDX_TOKEN_AOID", columnNames={"oid"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Token
implements Serializable {
    private static final long serialVersionUID = 100L;
    public static final int TOKEN_VERSION = 1;
    private static final char SEPARATOR = '-';
    public static final String PROPERTYNAME_ID = "id";
    public static final String PROPERTYNAME_SECRET = "secrect";
    public static final String PROPERTYNAME_REVOKED = "revoked";
    public static final String PROPERTYNAME_VALID_TO = "validTo";
    public static final String PROPERTYNAME_NODE_INFO = "nodeInfo";
    public static final String PROPERTYNAME_ACCOUNT_INFO = "accountInfo";
    public static final String PROPERTYNAME_SERVICE_INFO = "serviceInfo";
    private static final long REQUEST_TOKEN_TIMEOUT = 60000L;
    private static final long SERVICE_TOKEN_TIMEOUT = 42163632000000L;
    private static final long MERGE_TOKEN_TIMEOUT = 43200000L;
    private static final long CLOSE_ACCOUNT_TOKEN_TIMEOUT = 86400000L;
    private static final long ADD_EMAIL_TOKEN_TIMEOUT = 43200000L;
    private static final long ACCOUNT_REGISTER_TIMEOUT = 42163632000000L;
    private static final long OAUTH_ACCESS_TOKEN_VALIDITY = 86400000L;
    private static final long OCM_TOKEN_TIMEOUT = 1800000L;
    @Id
    private String id;
    private String secrect;
    private boolean revoked;
    @Index(name="IDX_TOKEN_VALID_TO")
    private Date validTo;
    @ManyToOne
    @JoinColumn(name="nodeInfo_id")
    private MemberInfo nodeInfo;
    @Embedded
    @Fetch(value=FetchMode.JOIN)
    private AccountInfo accountInfo;
    @ManyToOne
    @JoinColumn(name="serviceInfo_id")
    private ServerInfo serviceInfo;
    @Column(length=1024)
    private String notes;

    private Token() {
    }

    public static Token newRequestToken(ServerInfo serverInfo) {
        Reject.ifNull(serverInfo, "Service null");
        Reject.ifFalse(serverInfo.isFederatedService(), "Not a federation service");
        Date date = new Date(System.currentTimeMillis() + 60000L);
        return new Token(date, serverInfo, null, null);
    }

    public static Token newRegistrationToken(AccountInfo accountInfo) {
        Reject.ifNull(accountInfo, "Account info null");
        Date date = new Date(System.currentTimeMillis() + 42163632000000L);
        return new Token(date, null, accountInfo, null);
    }

    public static Token newAccessToken(long l, AccountInfo accountInfo) {
        return Token.newAccessToken(l, accountInfo, null);
    }

    public static Token newAccessToken(long l, AccountInfo accountInfo, MemberInfo memberInfo) {
        Reject.ifFalse(l > 0L, "Invalid time");
        Reject.ifNull(accountInfo, "Account info null");
        Date date = new Date(System.currentTimeMillis() + l);
        return new Token(date, null, accountInfo, memberInfo);
    }

    public static Token newAccessToken(AccountInfo accountInfo, ServerInfo serverInfo) {
        Reject.ifNull(accountInfo, "Account info null");
        Reject.ifNull(serverInfo, "Service null");
        Reject.ifFalse(serverInfo.isFederatedService(), "Not a federation service");
        Date date = new Date(System.currentTimeMillis() + 42163632000000L);
        return new Token(date, serverInfo, accountInfo, null);
    }

    public static Token newMergeToken(AccountInfo accountInfo, String string) {
        Token token = Token.newAccessToken(43200000L, accountInfo);
        token.addNotesWithDate(accountInfo.getUsername() + " merging with " + string);
        return token;
    }

    public static Token newCloseAccountToken(AccountInfo accountInfo) {
        Token token = Token.newAccessToken(86400000L, accountInfo);
        return token;
    }

    public static Token newAddEmailToken(AccountInfo accountInfo, String string) {
        Token token = Token.newAccessToken(43200000L, accountInfo);
        token.addNotesWithDate(accountInfo.getUsername() + " adding email " + string);
        return token;
    }

    public static Token newOAuthAccessToken(AccountInfo accountInfo) {
        Token token = Token.newAccessToken(86400000L, accountInfo);
        token.setNotes("access_token");
        return token;
    }

    public static Token newOAuthRefreshToken(AccountInfo accountInfo) {
        Token token = Token.newAccessToken(42163632000000L, accountInfo);
        token.setNotes("refresh_token");
        return token;
    }

    private Token(Date date, ServerInfo serverInfo, AccountInfo accountInfo, MemberInfo memberInfo) {
        Reject.ifNull(date, "Validto is null");
        this.serviceInfo = serverInfo;
        this.accountInfo = accountInfo;
        this.nodeInfo = memberInfo;
        this.id = "1" + IdGenerator.makeId();
        this.validTo = date;
        Reject.ifTrue(this.isExpired(), "Unable to create expired token");
    }

    public String generateSecret() {
        String string;
        Reject.ifTrue(this.hasSecret(), "Token secret already generated");
        Reject.ifTrue(this.isRevoked(), "Token already revoked");
        String string2 = Token.generate(this.validTo);
        Reject.ifTrue(Token.isExpired(string2), "Token already expired");
        String string3 = this.id + "-" + string2;
        this.secrect = string = LoginUtil.hashAndSalt(string3);
        return string3;
    }

    public boolean matches(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        if (!this.hasSecret()) {
            return false;
        }
        String string2 = Token.extractId(string);
        if (!this.getId().equals(string2)) {
            return false;
        }
        return LoginUtil.matches(string.toCharArray(), this.secrect);
    }

    public boolean validate(String string) {
        return !Token.isExpired(string) && this.isValid() && this.matches(string);
    }

    public boolean isValid() {
        return this.hasSecret() && !this.revoked && !this.isExpired();
    }

    public boolean hasSecret() {
        return StringUtils.isNotBlank(this.secrect);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.validTo.getTime();
    }

    public String getId() {
        return this.id;
    }

    public String getSecret() {
        return this.secrect;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public void revoke() {
        this.revoked = true;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public MemberInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public ServerInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public void addNotesWithDate(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        Object object = Format.formatDateCanonical(new Date());
        object = (String)object + ": ";
        object = (String)object + string;
        if (StringUtils.isBlank(this.notes)) {
            this.setNotes((String)object);
        } else {
            this.setNotes(this.notes + "\n" + (String)object);
        }
    }

    public boolean isAndroid() {
        return this.notes != null && this.notes.toLowerCase().contains("android");
    }

    public void setAndroid() {
        this.notes = "android";
    }

    public static String extractId(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        int n = string.lastIndexOf(45);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String generate(Date date) {
        Reject.ifNull(date, "ValidTo");
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(date.getTime());
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = IdGenerator.makeIdBytes();
        byte[] byArray3 = IdGenerator.makeIdBytes();
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        String string = Base58.encode(byArray4);
        return string;
    }

    public static boolean isExpired(String string) {
        long l;
        byte[] byArray;
        if (StringUtils.isBlank(string)) {
            return true;
        }
        int n = string.lastIndexOf(45);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        try {
            byArray = Base58.decode(string);
        }
        catch (Exception exception) {
            return true;
        }
        if (byArray.length < 8) {
            return true;
        }
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.put(byArray, 0, 8);
            byteBuffer.flip();
            l = byteBuffer.getLong();
        }
        catch (Exception exception) {
            return true;
        }
        return System.currentTimeMillis() > l;
    }

    public String toString() {
        return "Token [id=" + this.id + ", account=" + this.accountInfo + ", device=" + this.nodeInfo + ", service=" + this.serviceInfo + ", validTo=" + this.validTo + ", revoked=" + this.revoked + ", secrect=" + this.secrect + "]";
    }
}

