/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.RelayedMessage;
import de.dal33t.powerfolder.message.RelayedMessageExt;
import de.dal33t.powerfolder.net.AbstractRelayedConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.NodeManager;
import de.dal33t.powerfolder.net.RelayFinder;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.TransferCounter;
import de.dal33t.powerfolder.util.Waiter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RelayedConnectionManager
extends PFComponent {
    private static final Logger log = Logger.getLogger(RelayedConnectionManager.class.getName());
    private static long nextConnectionId = 0L;
    private Collection<AbstractRelayedConnectionHandler> pendingConHans;
    private RelayFinder relayFinder;
    private volatile Member currentRelay;
    private Lock pendingConHansLock = new ReentrantLock();
    private TransferCounter counter;
    private boolean printStats;
    private long nRelayedMsgs;

    public RelayedConnectionManager(Controller controller) {
        super(controller);
        this.pendingConHans = new CopyOnWriteArrayList<AbstractRelayedConnectionHandler>();
        this.relayFinder = controller.getDistribution().createRelayFinder();
        this.counter = new TransferCounter();
        this.printStats = false;
    }

    public void start() {
        this.getController().scheduleAndRepeat(new RelayConnectTask(), 20000L, 20000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionHandler initRelayedConnectionHandler(MemberInfo memberInfo) throws ConnectionException {
        if (this.getController().getMySelf().getInfo().equals(memberInfo)) {
            throw new ConnectionException("Illegal relayed loopback connection detection to myself");
        }
        Member member = this.getRelay();
        if (member == null) {
            throw new ConnectionException("Unable to open relayed connection to " + memberInfo + ". No relay found!");
        }
        if (this.isFiner()) {
            this.logFiner("Using relay " + member + " for connection to " + memberInfo + " / " + memberInfo.id);
        }
        if (this.isFiner()) {
            this.logFiner("Sending SYN for relayed connection to " + memberInfo.nick);
        }
        Object object = RelayedConnectionManager.class;
        synchronized (RelayedConnectionManager.class) {
            long l = nextConnectionId++;
            // ** MonitorExit[var5_3] (shouldn't be in output)
            object = this.getController().getIOProvider().getConnectionHandlerFactory().createRelayedConnectionHandler(memberInfo, l, member);
            this.pendingConHansLock.lock();
            this.pendingConHans.add((AbstractRelayedConnectionHandler)object);
            this.pendingConHansLock.unlock();
            if (this.pendingConHans.size() > 100) {
                this.logWarning(this.pendingConHans.size() + " pending relayed connection handlers found: " + this.pendingConHans);
            } else if (this.pendingConHans.size() > 500) {
                this.logSevere(this.pendingConHans.size() + " pending relayed connection handlers found: " + this.pendingConHans);
            }
            RelayedMessage relayedMessage = member.getProtocolVersion() >= 108 ? new RelayedMessageExt(RelayedMessage.Type.SYN, this.getController().getMySelf().getInfo(), memberInfo, l, null) : new RelayedMessage(RelayedMessage.Type.SYN, this.getController().getMySelf().getInfo(), memberInfo, l, null);
            try {
                member.sendMessage(relayedMessage);
                this.waitForAckOrNack((AbstractRelayedConnectionHandler)object);
                ((AbstractRelayedConnectionHandler)object).init();
            }
            catch (ConnectionException connectionException) {
                ((AbstractRelayedConnectionHandler)object).shutdown();
                this.removePedingRelayedConnectionHandler((AbstractRelayedConnectionHandler)object);
                throw connectionException;
            }
            return object;
        }
    }

    public void removePedingRelayedConnectionHandler(AbstractRelayedConnectionHandler abstractRelayedConnectionHandler) {
        Reject.ifNull(abstractRelayedConnectionHandler, "ConnectionHandler is null");
        this.pendingConHansLock.lock();
        this.pendingConHans.remove(abstractRelayedConnectionHandler);
        this.pendingConHansLock.unlock();
    }

    public void handleRelayedMessage(Member member, RelayedMessage relayedMessage) {
        if (!ConfigurationEntry.RELAYED_CONNECTIONS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            RelayedMessage relayedMessage2 = member.getProtocolVersion() >= 108 ? new RelayedMessageExt(RelayedMessage.Type.EOF, relayedMessage.getDestination(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null) : new RelayedMessage(RelayedMessage.Type.EOF, relayedMessage.getDestination(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null);
            member.sendMessagesAsynchron(relayedMessage2);
            return;
        }
        if (this.getController().getMySelf().getInfo().equals(relayedMessage.getDestination())) {
            this.processMessageForMySelf(member, relayedMessage);
        } else {
            this.relayMessage(member, relayedMessage);
        }
    }

    public void setRelayFiner(RelayFinder relayFinder) {
        Reject.ifNull(relayFinder, "relayFinder");
        this.relayFinder = relayFinder;
        this.currentRelay = relayFinder.findRelay(this.getController().getNodeManager());
    }

    public Member getRelay() {
        if (this.currentRelay == null) {
            this.currentRelay = this.relayFinder.findRelay(this.getController().getNodeManager());
        }
        return this.currentRelay;
    }

    public boolean isRelay(MemberInfo memberInfo) {
        Reject.ifNull(memberInfo, "Node info is null");
        Member member = memberInfo.getNode(this.getController(), false);
        return member != null && this.isRelay(member);
    }

    public boolean isRelay(Member member) {
        return this.getRelay() != null && member.equals(this.getRelay());
    }

    public TransferCounter getTransferCounter() {
        return this.counter;
    }

    private void relayMessage(Member member, RelayedMessage relayedMessage) {
        Member member2 = relayedMessage.getDestination().getNode(this.getController(), true);
        if (!member2.isCompletelyConnected()) {
            RelayedMessage.Type type = relayedMessage.getType().equals((Object)RelayedMessage.Type.SYN) ? RelayedMessage.Type.NACK : RelayedMessage.Type.EOF;
            RelayedMessage relayedMessage2 = member.getProtocolVersion() >= 108 ? new RelayedMessageExt(type, relayedMessage.getDestination(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null) : new RelayedMessage(type, relayedMessage.getDestination(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null);
            member.sendMessagesAsynchron(relayedMessage2);
            if (this.isFiner()) {
                this.logFiner("Unable to relay message. " + member2.getNick() + " not connected, sending EOF/NACK. msg: " + relayedMessage);
            }
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Relaying msg to " + member2.getNick() + ". msg: " + relayedMessage);
        }
        if (!this.printStats) {
            this.printStats = true;
            this.logInfo("Acting as relay. Received from " + member.getNick() + ", msg: " + relayedMessage);
            this.getController().scheduleAndRepeat(new TimerTask(){

                @Override
                public void run() {
                    RelayedConnectionManager.this.logFine("Relay stats (RelayedCon): " + RelayedConnectionManager.this.nRelayedMsgs + " msgs relayed. " + RelayedConnectionManager.this.counter);
                }
            }, 10000L);
        }
        RelayedMessage relayedMessage3 = relayedMessage;
        if (member2.getProtocolVersion() < 108 && relayedMessage instanceof RelayedMessageExt) {
            relayedMessage3 = new RelayedMessage(relayedMessage.getType(), relayedMessage.getSource(), relayedMessage.getDestination(), relayedMessage.getConnectionId(), relayedMessage.getPayload());
        }
        if (relayedMessage.getType().equals((Object)RelayedMessage.Type.DATA_ZIPPED)) {
            try {
                member2.sendMessage(relayedMessage3);
            }
            catch (ConnectionException connectionException) {
                log.log(Level.WARNING, "Connection broken while relaying message to " + member2.getNick() + ". " + connectionException);
                log.log(Level.FINER, connectionException.toString(), connectionException);
                RelayedMessage relayedMessage4 = member.getProtocolVersion() >= 108 ? new RelayedMessageExt(RelayedMessage.Type.EOF, relayedMessage.getDestination(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null) : new RelayedMessage(RelayedMessage.Type.EOF, relayedMessage.getDestination(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null);
                member.sendMessagesAsynchron(relayedMessage4);
            }
        } else {
            member2.sendMessagesAsynchron(relayedMessage3);
        }
    }

    private void processMessageForMySelf(Member member, RelayedMessage relayedMessage) {
        AbstractRelayedConnectionHandler abstractRelayedConnectionHandler = this.resolveRelHan(relayedMessage);
        switch (relayedMessage.getType()) {
            case SYN: {
                if (this.isFiner()) {
                    this.logFiner("SYN received from " + relayedMessage.getSource().nick);
                }
                if (!this.getController().getIOProvider().getConnectionHandlerFactory().useRelayedConnections()) {
                    RelayedMessage relayedMessage2 = member.getProtocolVersion() >= 108 ? new RelayedMessageExt(RelayedMessage.Type.NACK, this.getController().getMySelf().getInfo(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null) : new RelayedMessage(RelayedMessage.Type.NACK, this.getController().getMySelf().getInfo(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null);
                    member.sendMessagesAsynchron(relayedMessage2);
                    return;
                }
                AbstractRelayedConnectionHandler abstractRelayedConnectionHandler2 = this.getController().getIOProvider().getConnectionHandlerFactory().createRelayedConnectionHandler(relayedMessage.getSource(), relayedMessage.getConnectionId(), member);
                this.pendingConHansLock.lock();
                this.pendingConHans.add(abstractRelayedConnectionHandler2);
                this.pendingConHansLock.unlock();
                ConnectionInitializer connectionInitializer = new ConnectionInitializer(relayedMessage, abstractRelayedConnectionHandler2, member);
                this.getController().getIOProvider().startIO(connectionInitializer);
                return;
            }
            case ACK: {
                if (this.isFiner()) {
                    this.logFiner("ACK received from " + relayedMessage.getSource().nick);
                }
                if (abstractRelayedConnectionHandler != null) {
                    abstractRelayedConnectionHandler.setAckReceived(true);
                }
                return;
            }
            case NACK: {
                if (this.isFiner()) {
                    this.logFiner("NACK received from " + relayedMessage.getSource().nick);
                }
                if (abstractRelayedConnectionHandler != null) {
                    abstractRelayedConnectionHandler.setNackReceived(true);
                    abstractRelayedConnectionHandler.shutdownWithMember();
                    this.removePedingRelayedConnectionHandler(abstractRelayedConnectionHandler);
                }
                return;
            }
            case EOF: {
                if (this.isFiner()) {
                    this.logFiner("EOF received from " + relayedMessage.getSource().nick);
                }
                if (abstractRelayedConnectionHandler != null) {
                    abstractRelayedConnectionHandler.shutdownWithMember();
                    this.removePedingRelayedConnectionHandler(abstractRelayedConnectionHandler);
                }
                return;
            }
        }
        Reject.ifFalse(relayedMessage.getType().equals((Object)RelayedMessage.Type.DATA_ZIPPED), "Only zipped data allowed");
        if (this.isFiner()) {
            this.logFiner("DATA received from " + relayedMessage.getSource().nick + ": " + relayedMessage);
        }
        if (abstractRelayedConnectionHandler == null) {
            if (this.isFiner()) {
                this.logFiner("Got unknown peer, while processing relayed message from " + relayedMessage.getSource().nick);
            }
            RelayedMessage relayedMessage3 = member.getProtocolVersion() >= 108 ? new RelayedMessageExt(RelayedMessage.Type.EOF, relayedMessage.getDestination(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null) : new RelayedMessage(RelayedMessage.Type.EOF, this.getController().getMySelf().getInfo(), relayedMessage.getSource(), relayedMessage.getConnectionId(), null);
            member.sendMessagesAsynchron(relayedMessage3);
            return;
        }
        abstractRelayedConnectionHandler.receiveRelayedMessage(relayedMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractRelayedConnectionHandler resolveRelHan(RelayedMessage relayedMessage) {
        Member member = relayedMessage.getSource().getNode(this.getController(), true);
        ConnectionHandler connectionHandler = member.getPeer();
        if (connectionHandler == null) {
            try {
                this.pendingConHansLock.lock();
                for (AbstractRelayedConnectionHandler abstractRelayedConnectionHandler : this.pendingConHans) {
                    if (!abstractRelayedConnectionHandler.getRemote().equals(relayedMessage.getSource()) || abstractRelayedConnectionHandler.getConnectionId() != relayedMessage.getConnectionId()) continue;
                    connectionHandler = abstractRelayedConnectionHandler;
                    break;
                }
            }
            finally {
                this.pendingConHansLock.unlock();
            }
        }
        if (connectionHandler instanceof AbstractRelayedConnectionHandler) {
            return (AbstractRelayedConnectionHandler)connectionHandler;
        }
        if (relayedMessage.getType().equals((Object)RelayedMessage.Type.DATA_ZIPPED) && member.isInteresting() && this.isFine()) {
            this.logFine("Unable to resolved pending con handler for " + relayedMessage.getSource().nick + ", conId: " + relayedMessage.getConnectionId() + ". Got these: " + this.pendingConHans + ". msg: " + relayedMessage);
        }
        return null;
    }

    private void waitForAckOrNack(AbstractRelayedConnectionHandler abstractRelayedConnectionHandler) throws ConnectionException {
        Waiter waiter = new Waiter(60000L);
        if (this.isFiner()) {
            this.logFiner("Waiting for ack on " + abstractRelayedConnectionHandler);
        }
        while (!waiter.isTimeout()) {
            if (abstractRelayedConnectionHandler.isAckReceived()) {
                if (this.isFiner()) {
                    this.logFiner("Got ack on " + abstractRelayedConnectionHandler);
                }
                return;
            }
            if (abstractRelayedConnectionHandler.isNackReceived()) {
                throw new ConnectionException("NACK received: Unable to open relayed connection to " + abstractRelayedConnectionHandler.getRemote().nick);
            }
            if (!abstractRelayedConnectionHandler.getRelay().isCompletelyConnected()) {
                throw new ConnectionException("Unable to open relayed connection to " + abstractRelayedConnectionHandler.getRemote().nick + " relay " + abstractRelayedConnectionHandler.getRelay() + " disconnected.");
            }
            try {
                waiter.waitABit();
            }
            catch (RuntimeException runtimeException) {
                throw new ConnectionException("Shutdown", runtimeException);
            }
        }
        if (!abstractRelayedConnectionHandler.isAckReceived()) {
            throw new ConnectionException("Did not receive a ack after 60s from " + abstractRelayedConnectionHandler);
        }
    }

    private class RelayConnectTask
    extends TimerTask {
        private RelayConnectTask() {
        }

        @Override
        public void run() {
            if (!RelayedConnectionManager.this.getController().isStarted()) {
                return;
            }
            if (RelayedConnectionManager.this.isRelay(RelayedConnectionManager.this.getController().getMySelf().getInfo())) {
                return;
            }
            if (RelayedConnectionManager.this.getController().isLanOnly()) {
                return;
            }
            if (!RelayedConnectionManager.this.getController().getNodeManager().isStarted()) {
                return;
            }
            if (!ConfigurationEntry.RELAYED_CONNECTIONS_ENABLED.getValueBoolean(RelayedConnectionManager.this.getController()).booleanValue()) {
                return;
            }
            RelayedConnectionManager.this.currentRelay = RelayedConnectionManager.this.relayFinder.findRelay(RelayedConnectionManager.this.getController().getNodeManager());
            if (RelayedConnectionManager.this.isFine()) {
                if (RelayedConnectionManager.this.currentRelay != null) {
                    RelayedConnectionManager.this.logFine("Using relay: " + RelayedConnectionManager.this.currentRelay);
                } else {
                    RelayedConnectionManager.this.logFine("No relay server found yet");
                }
            }
            if (RelayedConnectionManager.this.currentRelay == null || RelayedConnectionManager.this.currentRelay.isConnected() || RelayedConnectionManager.this.currentRelay.isConnecting()) {
                return;
            }
            if (RelayedConnectionManager.this.isFine()) {
                RelayedConnectionManager.this.logFine("Triing to connect to relay: " + RelayedConnectionManager.this.currentRelay + " id: " + RelayedConnectionManager.this.currentRelay.getId());
            }
            RelayedConnectionManager.this.currentRelay.markForImmediateConnect();
        }
    }

    private final class ConnectionInitializer
    implements Runnable {
        private final RelayedMessage message;
        private final AbstractRelayedConnectionHandler relHan;
        private final Member receivedFrom;

        private ConnectionInitializer(RelayedMessage relayedMessage, AbstractRelayedConnectionHandler abstractRelayedConnectionHandler, Member member) {
            this.message = relayedMessage;
            this.relHan = abstractRelayedConnectionHandler;
            this.receivedFrom = member;
        }

        @Override
        public void run() {
            try {
                if (RelayedConnectionManager.this.isFiner()) {
                    RelayedConnectionManager.this.logFiner("Sending ACK to " + this.message.getSource().nick);
                }
                RelayedMessage relayedMessage = this.receivedFrom.getProtocolVersion() >= 108 ? new RelayedMessageExt(RelayedMessage.Type.ACK, RelayedConnectionManager.this.getController().getMySelf().getInfo(), this.message.getSource(), this.relHan.getConnectionId(), null) : new RelayedMessage(RelayedMessage.Type.ACK, RelayedConnectionManager.this.getController().getMySelf().getInfo(), this.message.getSource(), this.relHan.getConnectionId(), null);
                this.receivedFrom.sendMessagesAsynchron(relayedMessage);
                this.relHan.init();
                RelayedConnectionManager.this.getController().getNodeManager().acceptConnection(this.relHan);
            }
            catch (ConnectionException connectionException) {
                this.relHan.shutdown();
                RelayedConnectionManager.this.logFine("Unable to accept connection: " + this.relHan + ". " + connectionException.toString());
                RelayedConnectionManager.this.logFiner("ConnectionException", connectionException);
                RelayedMessage relayedMessage = this.receivedFrom.getProtocolVersion() >= 108 ? new RelayedMessageExt(RelayedMessage.Type.NACK, RelayedConnectionManager.this.getController().getMySelf().getInfo(), this.message.getSource(), this.message.getConnectionId(), null) : new RelayedMessage(RelayedMessage.Type.NACK, RelayedConnectionManager.this.getController().getMySelf().getInfo(), this.message.getSource(), this.message.getConnectionId(), null);
                this.receivedFrom.sendMessagesAsynchron(relayedMessage);
            }
            finally {
                RelayedConnectionManager.this.removePedingRelayedConnectionHandler(this.relHan);
            }
        }
    }

    public static class ServerIsRelayFinder
    implements RelayFinder {
        @Override
        public Member findRelay(NodeManager nodeManager) {
            Member member = nodeManager.getController().getOSClient().getServer();
            LinkedList<Member> linkedList = new LinkedList<Member>();
            for (Member member2 : nodeManager.getNodesAsCollection()) {
                if (!nodeManager.getController().getOSClient().isClusterServer(member2) || !member2.isCompletelyConnected() || member2.getPeer() instanceof AbstractRelayedConnectionHandler) continue;
                linkedList.add(member2);
            }
            if (linkedList.size() > 1) {
                linkedList.remove(member);
                Collections.shuffle(linkedList);
            }
            return linkedList.isEmpty() ? null : (Member)linkedList.get(0);
        }
    }
}

