/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.util.Reject;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NodeList {
    private List<MemberInfo> nodeList;
    private Set<MemberInfo> friendsSet;
    private Set<MemberInfo> serversSet;

    public NodeList() {
    }

    public NodeList(Collection<MemberInfo> collection, Collection<MemberInfo> collection2, Collection<MemberInfo> collection3) {
        this.nodeList = new ArrayList<MemberInfo>(collection);
        if (collection2 != null) {
            this.friendsSet = new HashSet<MemberInfo>(collection2);
        }
        if (collection3 != null) {
            this.serversSet = new HashSet<MemberInfo>(collection3);
        }
    }

    public boolean isEmpty() {
        return !(this.nodeList != null && !this.nodeList.isEmpty() || this.friendsSet != null && !this.friendsSet.isEmpty() || this.serversSet != null && !this.serversSet.isEmpty());
    }

    public Set<MemberInfo> getFriendsSet() {
        if (this.friendsSet == null) {
            this.friendsSet = new HashSet<MemberInfo>();
        }
        return this.friendsSet;
    }

    public Set<MemberInfo> getServersSet() {
        if (this.serversSet == null) {
            this.serversSet = new HashSet<MemberInfo>();
        }
        return this.serversSet;
    }

    public List<MemberInfo> getNodeList() {
        if (this.nodeList == null) {
            this.nodeList = new ArrayList<MemberInfo>();
        }
        return this.nodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
        try {
            this.nodeList = new ArrayList<MemberInfo>((List)objectInputStream.readObject());
            Object object = objectInputStream.readObject();
            if (object != null) {
                this.friendsSet = new HashSet<MemberInfo>((Set)object);
            }
            if ((object = objectInputStream.readObject()) != null) {
                this.serversSet = new HashSet<MemberInfo>((Set)object);
            }
        }
        catch (EOFException eOFException) {
        }
        finally {
            try {
                objectInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this.nodeList);
        objectOutputStream.writeObject(this.friendsSet);
        objectOutputStream.writeObject(this.serversSet);
        objectOutputStream.flush();
    }

    public void load(Path path) throws IOException, ClassNotFoundException {
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        this.load(inputStream);
        inputStream.close();
    }

    public boolean load(URL uRL) throws IOException, ClassNotFoundException {
        Reject.ifNull(uRL, "URL is null");
        Object object = uRL.getContent();
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            this.load(inputStream);
            inputStream.close();
            return true;
        }
        return false;
    }

    public void save(Path path) throws IOException {
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        this.save(outputStream);
        outputStream.close();
    }
}

