/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTTPProxySettings {
    private static final Logger LOG = Logger.getLogger(HTTPProxySettings.class.getName());
    private static boolean SYSTEM_PROXY_ENABLED = false;

    private HTTPProxySettings() {
        System.setProperty("java.net.useSystemProxies", "true");
    }

    private static void setProxyProperties(String string, int n, String string2) {
        if (StringUtils.isNotBlank(string)) {
            System.setProperty("http.proxyHost", string);
            System.setProperty("http.proxyPort", "" + n);
            System.setProperty("https.proxyHost", string);
            System.setProperty("https.proxyPort", "" + n);
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("http.nonProxyHosts");
            System.clearProperty("https.proxyHost");
            System.clearProperty("https.proxyPort");
            System.clearProperty("https.nonProxyHosts");
        }
        if (StringUtils.isNotBlank(string2)) {
            System.setProperty("http.nonProxyHosts", string2);
            System.setProperty("https.nonProxyHosts", string2);
        } else {
            System.clearProperty("http.nonProxyHosts");
            System.clearProperty("https.nonProxyHosts");
        }
    }

    private static void setCredentials(final String string, final String string2) {
        if (StringUtils.isBlank(string)) {
            Authenticator.setDefault(null);
        } else {
            Reject.ifBlank(string2, "Password is blank");
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(string, string2.toCharArray());
                }
            });
        }
    }

    public static void loadFromConfig(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        String string = ConfigurationEntry.HTTP_PROXY_HOST.getValue(controller);
        int n = ConfigurationEntry.HTTP_PROXY_PORT.getValueInt(controller);
        String string2 = ConfigurationEntry.HTTP_PROXY_NON_PROXY_HOSTS.getValue(controller);
        HTTPProxySettings.setProxyProperties(string, n, string2);
        String string3 = ConfigurationEntry.HTTP_PROXY_USERNAME.getValue(controller);
        String string4 = Util.toString(LoginUtil.deobfuscate(ConfigurationEntry.HTTP_PROXY_PASSWORD.getValue(controller)));
        try {
            HTTPProxySettings.setCredentials(string3, string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Could not set credentials for http proxy: " + illegalArgumentException.getMessage());
        }
        if (LOG.isLoggable(Level.WARNING)) {
            String string5 = StringUtils.isBlank(string3) ? "" : "(" + string3 + "/" + (Serializable)(string4 != null ? Integer.valueOf(string4.length()) : " n/a") + " chars)";
            LOG.fine("Loaded HTTP proxy settings: " + string + ":" + n + " " + string5);
        }
    }

    public static void saveToConfig(Controller controller, String string, int n, String string2, String string3, String string4) {
        Reject.ifNull(controller, "Controller is null");
        if (StringUtils.isNotBlank(string)) {
            ConfigurationEntry.HTTP_PROXY_HOST.setValue(controller, string);
        } else {
            ConfigurationEntry.HTTP_PROXY_HOST.removeValue(controller);
        }
        if (n > 0) {
            ConfigurationEntry.HTTP_PROXY_PORT.setValue(controller, String.valueOf(n));
        } else {
            ConfigurationEntry.HTTP_PROXY_PORT.removeValue(controller);
        }
        if (StringUtils.isNotBlank(string2)) {
            ConfigurationEntry.HTTP_PROXY_USERNAME.setValue(controller, string2);
        } else {
            ConfigurationEntry.HTTP_PROXY_USERNAME.removeValue(controller);
        }
        if (StringUtils.isNotBlank(string3)) {
            ConfigurationEntry.HTTP_PROXY_PASSWORD.setValue(controller, LoginUtil.obfuscate(Util.toCharArray(string3)));
        } else {
            ConfigurationEntry.HTTP_PROXY_PASSWORD.removeValue(controller);
        }
        if (StringUtils.isNotBlank(string4)) {
            ConfigurationEntry.HTTP_PROXY_NON_PROXY_HOSTS.setValue(controller, string4);
        } else {
            ConfigurationEntry.HTTP_PROXY_NON_PROXY_HOSTS.removeValue(controller);
        }
        HTTPProxySettings.setProxyProperties(string, n, string4);
        HTTPProxySettings.setCredentials(string2, string3);
        if (StringUtils.isBlank(string)) {
            LOG.fine("Removed proxy settings");
        } else {
            String string5 = StringUtils.isBlank(string2) ? "" : "(" + string2 + "/" + string3.length() + " chars)";
            LOG.fine("Saved HTTP proxy settings: " + string + ":" + n + " " + string5);
        }
    }

    public static final boolean useProxy(Controller controller) {
        return StringUtils.isNotBlank(ConfigurationEntry.HTTP_PROXY_HOST.getValue(controller));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean requiresProxyAuthorization(Controller controller) {
        String string = StringUtils.isNotBlank(controller.getUpdateSettings().versionCheckURL) ? controller.getUpdateSettings().versionCheckURL : (ConfigurationEntry.SERVER_WEB_URL.hasNonBlankValue(controller) ? ConfigurationEntry.SERVER_WEB_URL.getValue(controller) : (ConfigurationEntry.SERVER_HTTP_TUNNEL_RPC_URL.hasNonBlankValue(controller) ? ConfigurationEntry.SERVER_HTTP_TUNNEL_RPC_URL.getValue(controller) : ConfigurationEntry.PROVIDER_URL.getValue(controller)));
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(5000);
            uRLConnection.setReadTimeout(5000);
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
            inputStream.close();
            boolean bl = false;
            return bl;
        }
        catch (MalformedURLException malformedURLException) {
            LOG.warning("Unable to test for proxy authorization: " + string + ". " + malformedURLException.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl;
            boolean bl2 = bl = iOException.getMessage().contains("407") || iOException.getMessage().contains("Proxy Authorization Required");
            if (bl) {
                LOG.warning("Proxy authorization required for: " + string + ". " + iOException.getMessage());
            } else {
                LOG.warning(string + ". " + iOException);
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("java.net.useSystemProxies"))) {
            SYSTEM_PROXY_ENABLED = StringUtils.isNotBlank(System.getProperty("http.proxyHost", ""));
        }
    }
}

